/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.util.ArrayList;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTitleNumber;
import net.thevpc.nuts.runtime.core.format.text.AlphabetNutsTitleNumber;
import net.thevpc.nuts.runtime.core.format.text.IntNutsTitleNumber;

public class DefaultNutsTitleNumberSequence
implements NutsTextNumbering {
    private NutsTitleNumber[] value;
    private String[] separators;

    public DefaultNutsTitleNumberSequence(String pattern) {
        ArrayList<Object> p = new ArrayList<Object>();
        ArrayList<String> s = new ArrayList<String>();
        block6: for (char c : pattern.toCharArray()) {
            switch (c) {
                case '0': 
                case '1': {
                    p.add(new IntNutsTitleNumber(0));
                    continue block6;
                }
                case 'A': {
                    p.add(AlphabetNutsTitleNumber.ofUpperCased());
                    continue block6;
                }
                case 'a': {
                    p.add(AlphabetNutsTitleNumber.ofLowerCased());
                    continue block6;
                }
                case '-': 
                case '.': 
                case '/': {
                    s.add(String.valueOf(c));
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported sequence type " + pattern + " (error at '" + c + "')");
                }
            }
        }
        this.value = p.toArray(new NutsTitleNumber[0]);
    }

    public DefaultNutsTitleNumberSequence(NutsTitleNumber ... pattern) {
        this.value = new NutsTitleNumber[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            this.value[i] = pattern[i];
        }
        this.separators = new String[0];
    }

    public NutsTitleNumber[] getPattern() {
        NutsTitleNumber[] pattern = new NutsTitleNumber[this.value.length];
        for (int i = 0; i < pattern.length; ++i) {
            pattern[i] = this.value[i].none();
        }
        return pattern;
    }

    public NutsTitleNumber numberAt(int level, NutsTitleNumber[] all0, NutsTitleNumber[] all) {
        int a;
        int mm = Math.min(all0.length, all.length);
        for (int i = a = Math.min(level, mm - 1); i >= 0; --i) {
            if (i < all0.length && all0[i] != null) {
                return all0[i];
            }
            if (i >= all.length || all[i] == null) continue;
            return all[i];
        }
        return new IntNutsTitleNumber(0);
    }

    public NutsTextNumbering newLevel(int level) {
        int i;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level. must be >= 1");
        }
        int max = level >= this.value.length ? level + 1 : this.value.length;
        NutsTitleNumber[] pattern = new NutsTitleNumber[max];
        for (i = level + 1; i < this.value.length; ++i) {
            pattern[i] = this.value[i];
        }
        for (i = 0; i < level; ++i) {
            NutsTitleNumber nn = this.numberAt(i, this.value, pattern);
            if (nn.isNone()) {
                nn = nn.first();
            }
            pattern[i] = nn;
        }
        NutsTitleNumber nn = this.numberAt(level, this.value, pattern);
        pattern[level] = nn.next();
        for (int i2 = level + 1; i2 < pattern.length; ++i2) {
            pattern[i2] = this.value[i2].none();
        }
        return this.setValue(pattern);
    }

    private int depth() {
        for (int i = 0; i < this.value.length; ++i) {
            if (!this.value[i].isNone()) continue;
            return i;
        }
        return this.value.length;
    }

    public NutsTitleNumber getNumber(int index) {
        if (index >= 0 && index < this.value.length) {
            if (this.value[index] == null || this.value[index].isNone()) {
                return null;
            }
            return this.value[index];
        }
        return null;
    }

    public int size() {
        return this.value.length;
    }

    public NutsTitleNumber[] getValue() {
        ArrayList<NutsTitleNumber> ok = new ArrayList<NutsTitleNumber>();
        for (int i = 0; i < this.value.length && this.value[i] != null && !this.value[i].isNone(); ++i) {
            ok.add(this.value[i]);
        }
        return ok.toArray(new NutsTitleNumber[0]);
    }

    public NutsTextNumbering setValue(NutsTitleNumber[] newValue) {
        return new DefaultNutsTitleNumberSequence(newValue);
    }

    public String getSeparator(int index) {
        if (index >= 0) {
            String sep = ".";
            if (index < this.separators.length) {
                sep = this.separators[index];
            } else if (this.separators.length > 0) {
                sep = this.separators[this.separators.length - 1];
            }
            return sep;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        NutsTitleNumber[] v = this.getValue();
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                sb.append(this.getSeparator(i - 1));
            }
            sb.append(v[i].toString());
        }
        return sb.toString();
    }
}

