/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsDefaultSupportLevelContext;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementFactoryService;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementFactoryService;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.core.format.json.SimpleJson;
import net.thevpc.nuts.runtime.core.format.text.bloc.HadraBlocTextFormatter;
import net.thevpc.nuts.runtime.core.format.text.bloc.JavaBlocTextFormatter;
import net.thevpc.nuts.runtime.core.format.text.bloc.JsonCodeFormatter;
import net.thevpc.nuts.runtime.core.format.text.bloc.PlainBlocTextFormatter;
import net.thevpc.nuts.runtime.core.format.text.bloc.ShellBlocTextFormatter;
import net.thevpc.nuts.runtime.core.format.text.bloc.XmlCodeFormatter;
import net.thevpc.nuts.runtime.core.format.text.stylethemes.DefaultNutsTextFormatTheme;
import net.thevpc.nuts.runtime.core.format.text.stylethemes.NutsTextFormatPropertiesTheme;
import net.thevpc.nuts.runtime.core.format.text.stylethemes.NutsTextFormatThemeWrapper;
import net.thevpc.nuts.runtime.core.format.xml.DefaultXmlNutsElementStreamFormat;
import net.thevpc.nuts.runtime.core.format.yaml.SimpleYaml;

public class DefaultNutsTextManagerModel {
    private String styleThemeName;
    private NutsTextFormatTheme styleTheme;
    private final List<NutsCodeFormat> codeFormats = new ArrayList<NutsCodeFormat>();
    private JavaBlocTextFormatter javaBlocTextFormatter;
    private HadraBlocTextFormatter hadraBlocTextFormatter;
    private XmlCodeFormatter xmlBlocTextFormatter;
    private JsonCodeFormatter jsonBlocTextFormatter;
    private ShellBlocTextFormatter shellBlocTextFormatter;
    private PlainBlocTextFormatter plainBlocTextFormatter;
    private final NutsWorkspaceInitInformation info;
    private NutsTextFormatTheme defaultTheme;
    private final NutsWorkspace ws;
    private NutsElementFactoryService elementFactoryService;
    private NutsElementStreamFormat jsonMan;
    private NutsElementStreamFormat yamlMan;
    private NutsElementStreamFormat xmlMan;

    public DefaultNutsTextManagerModel(NutsWorkspace ws, NutsWorkspaceInitInformation info) {
        this.ws = ws;
        this.info = info;
    }

    public NutsTextFormatTheme createTheme(String y, NutsSession session) {
        String string = y = y == null ? "" : y.trim();
        if (NutsUtilStrings.isBlank((CharSequence)y)) {
            y = "default";
        }
        if ("default".equals(y)) {
            if (this.defaultTheme == null) {
                this.defaultTheme = session.getWorkspace().env().getOsFamily() == NutsOsFamily.WINDOWS ? new NutsTextFormatThemeWrapper(new NutsTextFormatPropertiesTheme("grass", null, session)) : new DefaultNutsTextFormatTheme(this.ws);
            }
            return this.defaultTheme;
        }
        return new NutsTextFormatThemeWrapper(new NutsTextFormatPropertiesTheme(y, null, session));
    }

    public NutsTextFormatTheme getTheme(NutsSession session) {
        if (this.styleTheme == null) {
            if (this.styleThemeName == null) {
                this.styleThemeName = this.info.getOptions().getTheme();
            }
            this.styleTheme = this.createTheme(this.styleThemeName, session);
        }
        return this.styleTheme;
    }

    public void setTheme(NutsTextFormatTheme styleTheme, NutsSession session) {
        this.styleTheme = styleTheme;
    }

    public void setTheme(String styleThemeName, NutsSession session) {
        if (styleThemeName == null || styleThemeName.trim().isEmpty()) {
            styleThemeName = "default";
        }
        styleThemeName = styleThemeName.trim();
        this.styleTheme = this.createTheme(styleThemeName, session);
        this.styleThemeName = styleThemeName;
    }

    public NutsCodeFormat getCodeFormat(String kind, NutsSession session) {
        NutsDefaultSupportLevelContext ctx = new NutsDefaultSupportLevelContext(session, (Object)kind);
        int bestCode = -1;
        NutsCodeFormat format = null;
        for (NutsCodeFormat codeFormat : this.getCodeFormats(session)) {
            int s = codeFormat.getSupportLevel((NutsSupportLevelContext)ctx);
            if (s <= bestCode) continue;
            format = codeFormat;
            bestCode = s;
        }
        if (format != null) {
            return format;
        }
        if (kind.length() > 0) {
            switch (kind.toLowerCase()) {
                case "sh": {
                    if (this.shellBlocTextFormatter == null) {
                        this.shellBlocTextFormatter = new ShellBlocTextFormatter(this.ws);
                    }
                    return this.shellBlocTextFormatter;
                }
                case "json": {
                    if (this.jsonBlocTextFormatter == null) {
                        this.jsonBlocTextFormatter = new JsonCodeFormatter(this.ws);
                    }
                    return this.jsonBlocTextFormatter;
                }
                case "xml": {
                    if (this.xmlBlocTextFormatter == null) {
                        this.xmlBlocTextFormatter = new XmlCodeFormatter(this.ws);
                    }
                    return this.xmlBlocTextFormatter;
                }
                case "java": {
                    if (this.javaBlocTextFormatter == null) {
                        this.javaBlocTextFormatter = new JavaBlocTextFormatter(this.ws);
                    }
                    return this.javaBlocTextFormatter;
                }
                case "hadra": {
                    if (this.hadraBlocTextFormatter == null) {
                        this.hadraBlocTextFormatter = new HadraBlocTextFormatter(this.ws);
                    }
                    return this.hadraBlocTextFormatter;
                }
                case "text": 
                case "plain": {
                    if (this.plainBlocTextFormatter == null) {
                        this.plainBlocTextFormatter = new PlainBlocTextFormatter(this.ws);
                    }
                    return this.plainBlocTextFormatter;
                }
            }
        }
        return null;
    }

    public void addCodeFormat(NutsCodeFormat format, NutsSession session) {
        this.codeFormats.add(format);
    }

    public void removeCodeFormat(NutsCodeFormat format, NutsSession session) {
        this.codeFormats.remove(format);
    }

    public NutsCodeFormat[] getCodeFormats(NutsSession session) {
        return this.codeFormats.toArray(new NutsCodeFormat[0]);
    }

    public NutsElementFactoryService getElementFactoryService(NutsSession session) {
        if (this.elementFactoryService == null) {
            this.elementFactoryService = new DefaultNutsElementFactoryService(this.ws, session);
        }
        return this.elementFactoryService;
    }

    public NutsElementStreamFormat getJsonMan(NutsSession session) {
        if (this.jsonMan == null) {
            this.jsonMan = new SimpleJson(this.ws);
        }
        return this.jsonMan;
    }

    public NutsElementStreamFormat getYamlMan(NutsSession session) {
        if (this.yamlMan == null) {
            this.yamlMan = new SimpleYaml(this.ws);
        }
        return this.yamlMan;
    }

    public NutsElementStreamFormat getXmlMan(NutsSession session) {
        if (this.xmlMan == null) {
            this.xmlMan = new DefaultXmlNutsElementStreamFormat();
        }
        return this.xmlMan;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }
}

