/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsFormattable;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextAnchor;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTextCommand;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextLink;
import net.thevpc.nuts.NutsTextList;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextNumbering;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManagerModel;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextNodeBuilder;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTitleNumberSequence;
import net.thevpc.nuts.runtime.core.format.text.bloc.CustomStyleBlocTextFormatter;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextAnchor;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextCode;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextCommand;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextLink;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextList;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeParser;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextPlain;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextStyled;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextTitle;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsTextManager
implements NutsTextManager {
    private NutsWorkspace ws;
    private NutsSession session;
    private DefaultNutsTextManagerModel shared;

    public DefaultNutsTextManager(NutsWorkspace ws, DefaultNutsTextManagerModel shared) {
        this.ws = ws;
        this.shared = shared;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.getSession());
    }

    public NutsTextBuilder builder() {
        this.checkSession();
        return new DefaultNutsTextNodeBuilder(this.getSession());
    }

    private NutsText _NutsMessage_toString(NutsMessage m) {
        Object[] params;
        this.checkSession();
        NutsTextFormatStyle style = m.getStyle();
        if (style == null) {
            style = NutsTextFormatStyle.JSTYLE;
        }
        if ((params = m.getParams()) == null) {
            params = new Object[]{};
        }
        String msg = m.getMessage();
        String sLocale = this.getSession() == null ? null : this.getSession().getLocale();
        Locale locale = NutsUtilStrings.isBlank((CharSequence)sLocale) ? null : new Locale(sLocale);
        Object[] args2 = new Object[params.length];
        NutsTextManager txt = this.getSession().getWorkspace().text();
        for (int i = 0; i < args2.length; ++i) {
            Object a = params[i];
            args2[i] = a == null ? null : (a instanceof Number || a instanceof Date || a instanceof Temporal ? a : txt.toText(a).toString());
        }
        switch (style) {
            case CSTYLE: {
                StringBuilder sb = new StringBuilder();
                new Formatter(sb, locale).format(msg, args2);
                return txt.parse(sb.toString());
            }
            case JSTYLE: {
                return txt.parse(MessageFormat.format(msg, args2));
            }
            case PLAIN: {
                return txt.forPlain(msg);
            }
            case FORMATTED: {
                return txt.parse(msg);
            }
        }
        throw new NutsUnsupportedEnumException(this.getSession(), (Enum)style);
    }

    public NutsText parse(String t) {
        return t == null ? this.forBlank() : this.parser().parse((Reader)new StringReader(t));
    }

    public NutsText title(NutsText t, int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("#");
        }
        sb.append(")");
        return this.createTitle(sb.toString(), level, t, true);
    }

    public NutsTextParser parser() {
        this.checkSession();
        return new DefaultNutsTextNodeParser(this.getSession());
    }

    public NutsText fg(String t, int level) {
        return this.fg((NutsText)this.forPlain(t), level);
    }

    public NutsText fg(NutsText t, int level) {
        NutsTextStyle textStyle = NutsTextStyle.primary((int)level);
        return this.createStyled("##:p" + level + ":", "##", t, NutsTextStyles.of((NutsTextStyle)textStyle), true);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsText bg(String t, int level) {
        return this.bg((NutsText)this.forPlain(t), level);
    }

    public DefaultNutsTextManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsText bg(NutsText t, int variant) {
        NutsTextStyle textStyle = NutsTextStyle.primary((int)variant);
        return this.createStyled("##:s" + variant + ":", "##", t, NutsTextStyles.of((NutsTextStyle)textStyle), true);
    }

    public NutsText forBlank() {
        return this.forPlain("");
    }

    public NutsText comments(String image) {
        return this.fg(image, 4);
    }

    public NutsText toText(Object t) {
        this.checkSession();
        if (t == null) {
            return this.forBlank();
        }
        if (t instanceof NutsText) {
            return (NutsText)t;
        }
        if (t instanceof NutsFormattable) {
            return ((NutsFormattable)t).formatter().setSession(this.getSession()).setNtf(true).format().toText();
        }
        if (t instanceof NutsMessage) {
            return this._NutsMessage_toString((NutsMessage)t);
        }
        if (t instanceof NutsString) {
            return ((NutsString)t).toText();
        }
        if (t instanceof NutsInput || t instanceof NutsOutput) {
            return this.forStyled(t.toString(), NutsTextStyle.path());
        }
        if (t instanceof Enum) {
            if (t instanceof NutsEnum) {
                return this.forStyled(((NutsEnum)t).id(), NutsTextStyle.option());
            }
            return this.forStyled(((Enum)t).name(), NutsTextStyle.option());
        }
        if (t instanceof Number) {
            return this.forStyled(t.toString(), NutsTextStyle.number());
        }
        if (t instanceof Date || t instanceof Temporal) {
            return this.forStyled(t.toString(), NutsTextStyle.date());
        }
        if (t instanceof Boolean) {
            return this.forStyled(t.toString(), NutsTextStyle.bool());
        }
        if (t instanceof Path || t instanceof File || t instanceof URL) {
            return this.forStyled(t.toString(), NutsTextStyle.path());
        }
        if (t instanceof Throwable) {
            return this.forStyled(this.toText(CoreStringUtils.exceptionToMessage((Throwable)t)), NutsTextStyle.error());
        }
        return this.forPlain(t.toString());
    }

    public NutsText literal(String image) {
        return this.fg(image, 1);
    }

    public NutsText stringLiteral(String image) {
        return this.fg(image, 3);
    }

    public NutsTextPlain forPlain(String t) {
        this.checkSession();
        return new DefaultNutsTextPlain(this.getSession(), t);
    }

    public NutsText numberLiteral(String image) {
        return this.fg(image, 1);
    }

    public NutsTextList forList(NutsText ... nodes) {
        return this.forList(Arrays.asList(nodes));
    }

    public NutsText reservedWord(String image) {
        return this.fg(image, 1);
    }

    public NutsTextList forList(Collection<NutsText> nodes) {
        this.checkSession();
        if (nodes == null) {
            return new DefaultNutsTextList(this.getSession(), new NutsText[0]);
        }
        return new DefaultNutsTextList(this.getSession(), nodes.toArray(new NutsText[0]));
    }

    public NutsText annotation(String image) {
        return this.fg(image, 3);
    }

    public NutsTextStyled forStyled(String other, NutsTextStyle decorations) {
        return this.forStyled((NutsText)this.forPlain(other), decorations);
    }

    public NutsText separator(String image) {
        return this.fg(image, 6);
    }

    public NutsTextStyled forStyled(NutsString other, NutsTextStyle decorations) {
        return this.forStyled(other.toText(), decorations);
    }

    public NutsText commandName(String image) {
        return this.fg(image, 1);
    }

    public NutsTextStyled forStyled(String other, NutsTextStyles decorations) {
        return this.forStyled((NutsText)this.forPlain(other), decorations);
    }

    public NutsText subCommand1Name(String image) {
        return this.fg(image, 2);
    }

    public NutsTextStyled forStyled(NutsString other, NutsTextStyles decorations) {
        this.checkSession();
        return this.forStyled(other.toText(), decorations);
    }

    public NutsText subCommand2Name(String image) {
        return this.fg(image, 3);
    }

    public NutsTextStyled forStyled(NutsText other, NutsTextStyles styles) {
        return this.createStyled(other, styles, true);
    }

    public NutsText optionName(String image) {
        return this.fg(image, 4);
    }

    public NutsTextCommand forCommand(NutsTerminalCommand command) {
        this.checkSession();
        return new DefaultNutsTextCommand(this.getSession(), "```!", command, "", "```");
    }

    public NutsText userInput(String image) {
        return this.fg(image, 8);
    }

    public NutsTextAnchor forAnchor(String anchorName) {
        return this.createAnchor("```!", "", "```", anchorName);
    }

    public NutsCodeFormat resolveBlocTextFormatter(String kind) {
        NutsCodeFormat format;
        this.checkSession();
        if (kind == null) {
            kind = "";
        }
        if ((format = this.getCodeFormat(kind)) != null) {
            return format;
        }
        if (kind.length() > 0) {
            try {
                String cc = kind.toUpperCase();
                int x = cc.length();
                while (Character.isDigit(cc.charAt(x - 1))) {
                    --x;
                }
                if (x < cc.length()) {
                    NutsTextStyle found = NutsTextStyle.of((NutsTextStyleType)NutsTextStyleType.valueOf((String)this.expandAlias(kind.toUpperCase().substring(0, x))), (int)Integer.parseInt(kind.substring(x)));
                    return new CustomStyleBlocTextFormatter(found, this.session);
                }
                NutsTextStyle found = NutsTextStyle.of((NutsTextStyleType)NutsTextStyleType.valueOf((String)this.expandAlias(kind.toUpperCase())));
                return new CustomStyleBlocTextFormatter(found, this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getCodeFormat("plain");
    }

    public NutsTextLink forLink(NutsText value) {
        return this.createLink("```!", "", "```", value);
    }

    private String expandAlias(String ss) {
        switch (ss.toUpperCase()) {
            case "BOOL": {
                ss = "BOOLEAN";
                break;
            }
            case "KW": {
                ss = "KEYWORD";
            }
        }
        return ss;
    }

    public NutsTextCode forCode(String lang, String text) {
        this.checkSession();
        if (text == null) {
            text = "";
        }
        DefaultNutsTextManager factory0 = (DefaultNutsTextManager)this.session.getWorkspace().text();
        if (text.indexOf(10) >= 0) {
            return factory0.createCode("```", lang, "\n", "```", text);
        }
        return factory0.createCode("```", lang, "", "```", text);
    }

    public NutsTextStyled createStyled(NutsText child, NutsTextStyles textStyles, boolean completed) {
        NutsText curr = child;
        if (textStyles == null || textStyles.isNone()) {
            return this.createStyled("", "", child, textStyles, completed);
        }
        block11: for (int i = textStyles.size() - 1; i >= 0; --i) {
            NutsTextStyle textStyle = textStyles.get(i);
            NutsTextStyles textStyle2 = NutsTextStyles.of((NutsTextStyle)textStyle);
            String svar = textStyle.getVariant() == 0 ? "" : "" + textStyle.getVariant();
            switch (textStyle.getType()) {
                case PRIMARY: {
                    curr = this.createStyled("##:p" + svar + ":", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case SECONDARY: {
                    curr = this.createStyled("##:s" + svar + ":", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case UNDERLINED: {
                    curr = this.createStyled("##:_:", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case BLINK: {
                    curr = this.createStyled("##:%:", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case ITALIC: {
                    curr = this.createStyled("##:/:", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case BOLD: {
                    curr = this.createStyled("##:+:", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case REVERSED: {
                    curr = this.createStyled("##:!:", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case FORE_COLOR: {
                    String s = Integer.toString(textStyle.getVariant(), 16);
                    while (s.length() < 8) {
                        s = "0" + s;
                    }
                    curr = this.createStyled("##:f" + s + ":", "##", curr, textStyle2, completed);
                    continue block11;
                }
                case BACK_COLOR: {
                    String s = Integer.toString(textStyle.getVariant(), 16);
                    while (s.length() < 8) {
                        s = "0" + s;
                    }
                    curr = this.createStyled("##:b" + svar + ":", "##", curr, textStyle2, completed);
                    continue block11;
                }
                default: {
                    curr = this.createStyled("##:" + textStyle.getType().toString().toUpperCase() + ":", "##", curr, textStyle2, completed);
                }
            }
        }
        return (NutsTextStyled)curr;
    }

    public NutsTextStyled createStyled(String start, String end, NutsText child, NutsTextStyles textStyle, boolean completed) {
        if (textStyle == null) {
            textStyle = NutsTextStyles.NONE;
        }
        this.checkSession();
        return new DefaultNutsTextStyled(this.getSession(), start, end, child, completed, textStyle);
    }

    public NutsTextCode createCode(String start, String kind, String separator, String end, String text) {
        this.checkSession();
        return new DefaultNutsTextCode(this.getSession(), start, kind, separator, end, text);
    }

    public NutsTextCommand createCommand(String start, NutsTerminalCommand command, String separator, String end) {
        this.checkSession();
        return new DefaultNutsTextCommand(this.getSession(), start, command, separator, end);
    }

    public NutsTextLink createLink(String start, String separator, String end, NutsText value) {
        this.checkSession();
        return new DefaultNutsTextLink(this.getSession(), start, separator, end, value);
    }

    public NutsTextAnchor createAnchor(String start, String separator, String end, String value) {
        this.checkSession();
        return new DefaultNutsTextAnchor(this.getSession(), start, separator, end, value);
    }

    public NutsText createTitle(String start, int level, NutsText child, boolean complete) {
        this.checkSession();
        return new DefaultNutsTextTitle(this.getSession(), start, level, child);
    }

    public NutsTextStyled forStyled(NutsText other, NutsTextStyle textNodeStyle) {
        return this.createStyled(other, NutsTextStyles.of((NutsTextStyle)textNodeStyle), true);
    }

    public NutsTextNumbering forNumbering() {
        this.checkSession();
        return new DefaultNutsTitleNumberSequence("");
    }

    public NutsTextNumbering forTitleNumberSequence(String pattern) {
        this.checkSession();
        return new DefaultNutsTitleNumberSequence(pattern == null || pattern.isEmpty() ? "1.1.1.a.1" : pattern);
    }

    public NutsTextFormatTheme getTheme() {
        this.checkSession();
        return this.shared.getTheme(this.getSession());
    }

    public NutsTextManager setTheme(NutsTextFormatTheme theme) {
        this.checkSession();
        this.shared.setTheme(theme, this.getSession());
        return this;
    }

    public NutsTextManager setTheme(String theme) {
        this.checkSession();
        this.shared.setTheme(theme, this.getSession());
        return this;
    }

    public NutsCodeFormat getCodeFormat(String kind) {
        this.checkSession();
        return this.shared.getCodeFormat(kind, this.getSession());
    }

    public NutsTextManager addCodeFormat(NutsCodeFormat format) {
        this.checkSession();
        this.shared.addCodeFormat(format, this.getSession());
        return this;
    }

    public NutsTextManager removeCodeFormat(NutsCodeFormat format) {
        this.checkSession();
        this.shared.removeCodeFormat(format, this.getSession());
        return this;
    }

    public NutsCodeFormat[] getCodeFormats() {
        this.checkSession();
        return this.shared.getCodeFormats(this.getSession());
    }
}

