/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import net.thevpc.nuts.NutsTitleNumber;

public class AlphabetNutsTitleNumber
implements NutsTitleNumber {
    String[] names;
    String separator;
    String[] value;

    public static AlphabetNutsTitleNumber ofUpperCased() {
        String[] all = new String[26];
        for (int i = 65; i <= 90; ++i) {
            all[i - 65] = String.valueOf((char)i);
        }
        return new AlphabetNutsTitleNumber(all, "", new String[0]);
    }

    public static AlphabetNutsTitleNumber ofLowerCased() {
        String[] all = new String[26];
        for (int i = 97; i <= 122; ++i) {
            all[i - 97] = String.valueOf((char)i);
        }
        return new AlphabetNutsTitleNumber(all, "", new String[0]);
    }

    public AlphabetNutsTitleNumber(String[] names, String separator, String[] value) {
        this.names = names;
        this.separator = separator;
        this.value = value;
    }

    public NutsTitleNumber none() {
        return new AlphabetNutsTitleNumber(this.names, this.separator, new String[0]);
    }

    public boolean isNone() {
        return this.value.length == 0;
    }

    public NutsTitleNumber first() {
        return new AlphabetNutsTitleNumber(this.names, this.separator, new String[]{this.names[0]});
    }

    public NutsTitleNumber next() {
        return new AlphabetNutsTitleNumber(this.names, this.separator, this.inc(0, this.value));
    }

    private int index(String n) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!this.names[i].equals(n)) continue;
            return i;
        }
        throw new IllegalArgumentException("invalid name " + n);
    }

    private String[] copy(String[] value) {
        String[] t = new String[value.length];
        System.arraycopy(value, 0, t, 0, value.length);
        return t;
    }

    private String[] ensureSize(int size, String[] value) {
        if (size > value.length) {
            String[] t = new String[value.length + 1];
            System.arraycopy(value, 0, t, 0, value.length);
            value = t;
        }
        return value;
    }

    private String[] inc(int pos, String[] value) {
        value = this.copy(value);
        if ((value = this.ensureSize(pos + 1, value))[pos] == null) {
            value[pos] = this.names[0];
        } else {
            int o = this.index(value[pos]);
            if (o < this.names.length - 1) {
                value[pos] = this.names[o + 1];
            } else {
                for (int i = 0; i <= pos; ++i) {
                    value[i] = this.names[0];
                }
                return this.inc(pos + 1, value);
            }
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.value.length && this.value[i] != null; ++i) {
            if (sb.length() > 0) {
                sb.insert(0, this.separator);
            }
            sb.insert(0, this.value[i]);
        }
        return sb.toString();
    }
}

