/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextFormatLoader;
import net.thevpc.nuts.NutsTextParser;
import net.thevpc.nuts.NutsTextVisitor;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.text.NutsTextNodeCollector;
import net.thevpc.nuts.runtime.core.format.text.parser.DefaultNutsTextNodeResourceParserHelper;

public abstract class AbstractNutsTextNodeParser
implements NutsTextParser {
    protected int bufferSize = 4096;
    protected NutsSession session;
    protected DefaultNutsTextNodeResourceParserHelper rp;

    public AbstractNutsTextNodeParser(NutsSession session) {
        this.session = session;
        this.rp = new DefaultNutsTextNodeResourceParserHelper(this, session);
    }

    public NutsWorkspace getWorkspace() {
        return this.session.getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public long parseIncremental(char buf, NutsTextVisitor visitor) {
        return this.parseIncremental(new char[]{buf}, visitor);
    }

    public long parse(InputStream in, NutsTextVisitor visitor) {
        return this.parse(new BufferedReader(new InputStreamReader(in)), visitor);
    }

    public long parse(Reader in, NutsTextVisitor visitor) {
        int count = 0;
        char[] buffer = new char[this.bufferSize];
        while (true) {
            int r;
            try {
                r = in.read(buffer);
                if (r <= 0) {
                    break;
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            this.parseIncremental(buffer, 0, r, visitor);
        }
        this.parseRemaining(visitor);
        return count;
    }

    public NutsText parse(InputStream in) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parse(in, (NutsTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parse(Reader in) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parse(in, (NutsTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    public long parseIncremental(byte[] buf, NutsTextVisitor visitor) {
        return this.parseIncremental(buf, 0, buf.length, visitor);
    }

    public long parseIncremental(char[] buf, NutsTextVisitor visitor) {
        return this.parseIncremental(new String(buf), visitor);
    }

    public long parseIncremental(String buf, NutsTextVisitor visitor) {
        return this.parseIncremental(buf.getBytes(), visitor);
    }

    public NutsText parseIncremental(byte[] buf) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseIncremental(buf, 0, buf.length, doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parseIncremental(char[] buf) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseIncremental(new String(buf), (NutsTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parseIncremental(String buf) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseIncremental(buf.getBytes(), (NutsTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parseIncremental(char buf) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseIncremental(buf, (NutsTextVisitor)doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parseIncremental(byte[] buf, int off, int len) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseIncremental(buf, off, len, doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parseIncremental(char[] buf, int off, int len) {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseIncremental(buf, off, len, doc);
        return doc.getRootOrEmpty();
    }

    public NutsText parseRemaining() {
        NutsTextNodeCollector doc = new NutsTextNodeCollector(this.session.getWorkspace());
        this.parseRemaining(doc);
        return doc.getRootOrNull();
    }

    public NutsText parseResource(String resourceName, NutsTextFormatLoader loader) {
        return this.rp.parseResource(resourceName, loader);
    }

    public NutsText parseResource(String resourceName, Reader reader, NutsTextFormatLoader loader) {
        return this.rp.parseResource(resourceName, reader, loader);
    }

    public NutsTextFormatLoader createLoader(ClassLoader loader) {
        return this.rp.createClassPathLoader(loader);
    }

    public NutsTextFormatLoader createLoader(File root) {
        return this.rp.createFileLoader(root);
    }
}

