/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.core.format.json.ReaderLocation;

public class SimpleJson
implements NutsElementStreamFormat {
    private NutsWorkspace ws;

    public SimpleJson(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsElement parseElement(String string, NutsElementFactoryContext context) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        return this.parseElement(new StringReader(string), context);
    }

    public void write(NutsPrintStream out, NutsElement data, boolean compact) {
        this.write(out, data, compact ? null : "");
    }

    private void write(NutsPrintStream out, NutsElement data, String indent) {
        switch (data.type()) {
            case NULL: {
                out.print("null");
                break;
            }
            case BOOLEAN: {
                out.print(data.asPrimitive().getBoolean());
                break;
            }
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                out.print((Object)data.asPrimitive().getNumber());
                break;
            }
            case INSTANT: 
            case STRING: {
                StringBuilder sb = new StringBuilder("\"");
                String str = data.asPrimitive().getString();
                char[] chars = str.toCharArray();
                block19: for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c < ' ') {
                        switch (c) {
                            case '\n': {
                                sb.append('\\').append('n');
                                break;
                            }
                            case '\f': {
                                sb.append('\\').append('f');
                                break;
                            }
                            case '\t': {
                                sb.append('\\').append('t');
                                break;
                            }
                            case '\r': {
                                sb.append('\\').append('r');
                                break;
                            }
                            case '\b': {
                                sb.append('\\').append('b');
                                break;
                            }
                            default: {
                                sb.append('\\');
                                sb.append('u');
                                sb.append(NutsUtilStrings.toHexChar((int)(c >> 12 & 0xF)));
                                sb.append(NutsUtilStrings.toHexChar((int)(c >> 8 & 0xF)));
                                sb.append(NutsUtilStrings.toHexChar((int)(c >> 4 & 0xF)));
                                sb.append(NutsUtilStrings.toHexChar((int)(c & 0xF)));
                                break;
                            }
                        }
                        continue;
                    }
                    switch (c) {
                        case '\\': {
                            sb.append(c).append(c);
                            continue block19;
                        }
                        case '\"': {
                            sb.append('\\').append('\"');
                            continue block19;
                        }
                        default: {
                            if (c > '~') {
                                sb.append('\\');
                                sb.append('u');
                                sb.append(NutsUtilStrings.toHexChar((int)(c >> 12 & 0xF)));
                                sb.append(NutsUtilStrings.toHexChar((int)(c >> 8 & 0xF)));
                                sb.append(NutsUtilStrings.toHexChar((int)(c >> 4 & 0xF)));
                                sb.append(NutsUtilStrings.toHexChar((int)(c & 0xF)));
                                continue block19;
                            }
                            sb.append(c);
                        }
                    }
                }
                sb.append('\"');
                out.print((Object)sb);
                break;
            }
            case ARRAY: {
                if (data.asArray().size() == 0) {
                    out.print("[]");
                    break;
                }
                out.print('[');
                boolean first = true;
                String indent2 = indent + "  ";
                for (NutsElement e : data.asArray().children()) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(',');
                    }
                    if (indent != null) {
                        out.print('\n');
                        out.print(indent2);
                        this.write(out, e, indent2);
                        continue;
                    }
                    this.write(out, e, null);
                }
                if (indent != null) {
                    out.print('\n');
                    out.print(indent);
                }
                out.print(']');
                break;
            }
            case OBJECT: {
                if (data.asObject().size() == 0) {
                    out.print("{}");
                    break;
                }
                out.print('{');
                boolean first = true;
                String indent2 = indent + "  ";
                for (NutsElementEntry e : data.asObject().children()) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(',');
                    }
                    if (indent != null) {
                        out.print('\n');
                        out.print(indent2);
                        this.write(out, e.getKey(), indent2);
                        out.print(':');
                        out.print(' ');
                        this.write(out, e.getValue(), indent2);
                        continue;
                    }
                    this.write(out, e.getKey(), null);
                    out.print(':');
                    this.write(out, e.getValue(), null);
                }
                if (indent != null) {
                    out.print('\n');
                    out.print(indent);
                }
                out.print('}');
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported");
            }
        }
    }

    @Override
    public NutsElement parseElement(Reader reader, NutsElementFactoryContext context) {
        return new ElementParser(context).parseElement(reader);
    }

    @Override
    public void printElement(NutsElement value, NutsPrintStream out, boolean compact, NutsElementFactoryContext context) {
        this.write(out, value, compact);
    }

    private static class ElementParser {
        private BufferedReader reader;
        private NutsElementFactoryContext context;
        private int fileOffset;
        private int lineNumber;
        private int lineOffset;
        private int current;
        private boolean skipLF;
        private NutsElementFormat ebuilder;

        public ElementParser(NutsElementFactoryContext context) {
            this.context = context;
        }

        public NutsElement parseElement(Reader reader) {
            if (reader == null) {
                throw new NullPointerException("reader is null");
            }
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.fileOffset = 0;
            this.lineNumber = 1;
            this.lineOffset = 0;
            this.current = 0;
            this.readNext();
            this.skipWhiteSpaceAndComments();
            NutsElement e = this.readValue();
            this.skipWhiteSpaceAndComments();
            if (this.current != -1) {
                throw this.error("unexpected character");
            }
            return e;
        }

        private NutsElement readValue() {
            switch (this.current) {
                case 110: {
                    String n = this.readStringLiteralUnQuoted();
                    if ("null".equals(n)) {
                        return this.builder().forNull();
                    }
                    return this.builder().forString(n);
                }
                case 116: {
                    String n = this.readStringLiteralUnQuoted();
                    if ("true".equals(n)) {
                        return this.builder().forTrue();
                    }
                    return this.builder().forString(n);
                }
                case 102: {
                    String n = this.readStringLiteralUnQuoted();
                    if ("false".equals(n)) {
                        return this.builder().forFalse();
                    }
                    return this.builder().forString(n);
                }
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber();
                }
                case 34: 
                case 39: 
                case 96: {
                    return this.readJsonString();
                }
                case 91: {
                    return this.readJsonArray();
                }
                case 123: {
                    return this.readJsonObject();
                }
            }
            if (Character.isAlphabetic(this.current)) {
                return this.readJsonString();
            }
            throw this.expected("value");
        }

        private NutsElement readJsonArray() {
            NutsArrayElementBuilder array = this.builder().forArray();
            this.readNext();
            this.skipWhiteSpaceAndComments();
            if (this.readChar(']')) {
                return array.build();
            }
            do {
                this.skipWhiteSpaceAndComments();
                if (this.current == 93) break;
                array.add(this.readValue());
                this.skipWhiteSpaceAndComments();
            } while (this.readChar(','));
            this.skipWhiteSpaceAndComments();
            if (!this.readChar(']')) {
                throw this.expected("',' or ']'");
            }
            return array.build();
        }

        private NutsElement readJsonObject() {
            NutsObjectElementBuilder object = this.builder().forObject();
            this.readNext();
            this.skipWhiteSpaceAndComments();
            if (this.readChar('}')) {
                return object.build();
            }
            do {
                String name;
                this.skipWhiteSpaceAndComments();
                if (this.current == 125) break;
                NutsElement k = this.readValue();
                switch (k.type()) {
                    case ARRAY: 
                    case OBJECT: {
                        throw this.expected("name");
                    }
                    case NULL: {
                        name = "null";
                        break;
                    }
                    default: {
                        name = k.asString();
                    }
                }
                this.skipWhiteSpaceAndComments();
                if (!this.readChar(':')) {
                    throw this.expected("':'");
                }
                this.skipWhiteSpaceAndComments();
                NutsElement v = this.readValue();
                object.set(name, v);
                this.skipWhiteSpaceAndComments();
            } while (this.readChar(','));
            if (!this.readChar('}')) {
                throw this.expected("',' or '}'");
            }
            return object.build();
        }

        private void readTerminal(String s) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (this.readChar(ch)) continue;
                throw this.expected("'" + ch + "'");
            }
        }

        private NutsElement readJsonString() {
            return this.builder().forString(this.readStringLiteral());
        }

        private String readStringLiteral() {
            if (this.current == 34) {
                return this.readStringLiteralDblQuoted();
            }
            if (this.current == 39) {
                return this.readStringLiteralSimpleQuoted();
            }
            if (this.current == 96) {
                return this.readStringLiteralAntiQuoted();
            }
            return this.readStringLiteralUnQuoted();
        }

        private String readStringLiteralDblQuoted() {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != 34) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                sb.append((char)this.current);
                this.readNext();
            }
            this.readNext();
            return sb.toString();
        }

        private String readStringLiteralSimpleQuoted() {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != 39) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                sb.append((char)this.current);
                this.readNext();
            }
            this.readNext();
            return sb.toString();
        }

        private String readStringLiteralAntiQuoted() {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != 96) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: 
                        case 96: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                sb.append((char)this.current);
                this.readNext();
            }
            this.readNext();
            return sb.toString();
        }

        private String readStringLiteralUnQuotedPar(char end) {
            this.readNext();
            StringBuilder sb = new StringBuilder();
            while (this.current != -1 && this.current != end) {
                sb.append(this.skipWhiteSpaceAndComments());
                sb.append(this.readStringLiteralUnQuoted());
            }
            if (this.current != -1) {
                this.readNext();
            }
            return sb.toString();
        }

        private String readStringLiteralUnQuoted() {
            StringBuilder sb = new StringBuilder();
            while (this.current > 32) {
                if (this.current == 92) {
                    this.readNext();
                    switch (this.current) {
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)this.current);
                            break;
                        }
                        case 98: {
                            sb.append('\b');
                            break;
                        }
                        case 102: {
                            sb.append('\f');
                            break;
                        }
                        case 110: {
                            sb.append('\n');
                            break;
                        }
                        case 114: {
                            sb.append('\r');
                            break;
                        }
                        case 116: {
                            sb.append('\t');
                            break;
                        }
                        case 117: {
                            char[] hexChars = new char[4];
                            for (int i = 0; i < 4; ++i) {
                                this.readNext();
                                if (!this.isHexDigit()) {
                                    throw this.expected("hexadecimal digit");
                                }
                                hexChars[i] = (char)this.current;
                            }
                            sb.append((char)Integer.parseInt(new String(hexChars), 16));
                            break;
                        }
                        default: {
                            throw this.expected("valid escape sequence");
                        }
                    }
                    this.readNext();
                    continue;
                }
                if (this.current == 40) {
                    sb.append(this.readStringLiteralUnQuotedPar(')'));
                    continue;
                }
                if (this.current == 123) {
                    sb.append(this.readStringLiteralUnQuotedPar('}'));
                    continue;
                }
                if (this.current == 91) {
                    sb.append(this.readStringLiteralUnQuotedPar(']'));
                    continue;
                }
                if (this.current == 34 || this.current == 39 || this.current == 96) {
                    sb.append(this.readStringLiteral());
                    continue;
                }
                if (this.current == 58 || this.current == 44 || this.current == 41 || this.current == 125 || this.current == 93) break;
                sb.append((char)this.current);
                this.readNext();
            }
            return sb.toString();
        }

        private NutsElement readNumber() {
            StringBuilder sb = new StringBuilder();
            boolean inWhile = true;
            block4: while (inWhile) {
                switch (this.current) {
                    case -1: {
                        throw this.expected("number");
                    }
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 69: 
                    case 101: {
                        sb.append((char)this.current);
                        this.readNext();
                        continue block4;
                    }
                }
                inWhile = false;
            }
            return this.builder().forNumber(sb.toString());
        }

        private boolean readChar(char ch) {
            if (this.current != ch) {
                return false;
            }
            this.readNext();
            return true;
        }

        private String skipWhiteSpaceAndComments() {
            StringBuilder sb = new StringBuilder();
            block0: while (true) {
                if (this.current == 32 || this.current == 9 || this.current == 10 || this.current == 13) {
                    sb.append((char)this.current);
                    this.readNext();
                    continue;
                }
                if (this.current != 47) break;
                String s = this.foreSeek(2);
                if ("//".equals(s)) {
                    sb.append((char)this.current);
                    this.readNext();
                    sb.append((char)this.current);
                    this.readNext();
                    while (true) {
                        if (this.current <= 0 || this.current == 13 || this.current == 10) continue block0;
                        sb.append((char)this.current);
                        this.readNext();
                    }
                }
                if (!"/*".equals(s)) break;
                sb.append((char)this.current);
                this.readNext();
                sb.append((char)this.current);
                this.readNext();
                while (true) {
                    if (this.current <= 0) continue block0;
                    if (this.current == 42 && "*/".equals(this.foreSeek(2))) {
                        sb.append((char)this.current);
                        this.readNext();
                        sb.append((char)this.current);
                        this.readNext();
                        continue block0;
                    }
                    sb.append((char)this.current);
                    this.readNext();
                }
                break;
            }
            return sb.toString();
        }

        private String foreSeek(int count) {
            StringBuilder sb = new StringBuilder();
            if (this.current > 0) {
                sb.append((char)this.current);
                --count;
            }
            if (count > 0) {
                try {
                    int r;
                    this.reader.mark(count);
                    for (int i = 0; i < count && (r = this.reader.read()) >= 0; ++i) {
                        sb.append((char)r);
                    }
                    if (sb.length() > 0) {
                        this.reader.reset();
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            return sb.toString();
        }

        private void readNext() {
            try {
                this.current = this.reader.read();
                if (this.current != -1) {
                    ++this.lineOffset;
                    ++this.fileOffset;
                    if (this.skipLF) {
                        if (this.current == 10) {
                            this.current = this.reader.read();
                        }
                        this.skipLF = false;
                    }
                    switch (this.current) {
                        case 13: {
                            this.skipLF = true;
                        }
                        case 10: {
                            ++this.lineNumber;
                            this.lineOffset = 0;
                            this.current = 10;
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        ReaderLocation getLocation() {
            return new ReaderLocation(this.fileOffset, this.lineNumber, this.lineOffset);
        }

        private RuntimeException expected(String expected) {
            if (this.current == -1) {
                return this.error("unexpected end of input");
            }
            return this.error("expected " + expected);
        }

        private RuntimeException error(String message) {
            return new RuntimeException(message + ":" + this.getLocation().toString());
        }

        private boolean isHexDigit() {
            return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
        }

        public NutsElementFormat builder() {
            if (this.ebuilder == null) {
                this.ebuilder = this.context.getSession().getWorkspace().elem();
            }
            return this.ebuilder;
        }
    }
}

