/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Date;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsElementPath;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsIterableFormat;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsArrayElementBuilder;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementEntry;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementFactoryContext;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementFactoryService;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsObjectElementBuilder;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsPrimitiveElement;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementFactoryService;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementPathFilter;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.core.format.json.DefaultSearchFormatJson;
import net.thevpc.nuts.runtime.core.format.plain.DefaultSearchFormatPlain;
import net.thevpc.nuts.runtime.core.format.props.DefaultSearchFormatProps;
import net.thevpc.nuts.runtime.core.format.table.DefaultSearchFormatTable;
import net.thevpc.nuts.runtime.core.format.text.DefaultNutsTextManagerModel;
import net.thevpc.nuts.runtime.core.format.tree.DefaultSearchFormatTree;
import net.thevpc.nuts.runtime.core.format.xml.DefaultSearchFormatXml;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsElementFormat
extends DefaultFormatBase<NutsElementFormat>
implements NutsElementFormat {
    private Object value;
    private NutsContentType contentType = NutsContentType.JSON;
    private boolean compact;
    private final DefaultNutsTextManagerModel model;
    private Predicate<Type> destructTypeFilter;

    public DefaultNutsElementFormat(DefaultNutsTextManagerModel model) {
        super(model.getWorkspace(), "element-format");
        this.model = model;
    }

    public NutsContentType getContentType() {
        return this.contentType;
    }

    public NutsElementFormat setContentType(NutsContentType contentType) {
        this.contentType = contentType == null ? NutsContentType.JSON : contentType;
        return this;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public NutsElementFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T parse(URL url, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                try {
                    try (InputStream is = NutsWorkspaceUtils.of(this.getSession()).openURL(url);){
                        T t = this.parse(new InputStreamReader(is), clazz);
                        return t;
                    }
                    catch (NutsException ex) {
                        throw ex;
                    }
                    catch (UncheckedIOException ex) {
                        throw new NutsIOException(this.getSession(), (Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse url %s", (Object[])new Object[]{url}), (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse url %s", (Object[])new Object[]{url}), (Throwable)ex);
                }
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(InputStream inputStream, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parse(new InputStreamReader(inputStream), clazz);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(String string, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parse(new StringReader(string), clazz);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(byte[] bytes, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parse(new InputStreamReader(new ByteArrayInputStream(bytes)), clazz);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    private NutsElementStreamFormat resolveStructuredFormat() {
        this.checkSession();
        switch (this.contentType) {
            case JSON: {
                return this.model.getJsonMan(this.getSession());
            }
            case YAML: {
                return this.model.getYamlMan(this.getSession());
            }
            case XML: {
                return this.model.getXmlMan(this.getSession());
            }
            case TSON: {
                throw new IllegalArgumentException("tson not supported yet");
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(Reader reader, Class<T> clazz) {
        return (T)this.elementToObject(this.resolveStructuredFormat().parseElement(reader, this.createFactoryContext()), clazz);
    }

    private DefaultNutsElementFactoryContext createFactoryContext() {
        return new DefaultNutsElementFactoryContext(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T parse(Path file, Class<T> clazz) {
        this.checkSession();
        try (BufferedReader r = Files.newBufferedReader(file);){
            T t = this.parse(r, clazz);
            return t;
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T parse(File file, Class<T> clazz) {
        this.checkSession();
        try (FileReader r = new FileReader(file);){
            T t = this.parse(r, clazz);
            return t;
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        return false;
    }

    public Object getValue() {
        return this.value;
    }

    public NutsElementFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    public NutsElementPath compilePath(String pathExpression) {
        this.checkSession();
        return NutsElementPathFilter.compile(pathExpression, this.getSession());
    }

    public <T> T convert(Object any, Class<T> to) {
        if (to == null || to.isInstance(any)) {
            return (T)any;
        }
        NutsElement e = this.toElement(any);
        return (T)this.elementToObject(e, to);
    }

    private void print(NutsPrintStream out, NutsElementStreamFormat format) {
        this.checkSession();
        NutsElement elem = this.toElement(this.value);
        if (out.isNtf()) {
            NutsMemoryPrintStream bos = this.getSession().getWorkspace().io().createMemoryPrintStream();
            format.printElement(elem, (NutsPrintStream)bos, this.compact, this.createFactoryContext());
            out.print((NutsString)this.getSession().getWorkspace().text().forCode(this.getContentType().id(), bos.toString()));
        } else {
            format.printElement(elem, out, this.compact, this.createFactoryContext());
        }
        out.flush();
    }

    @Override
    public void print(NutsPrintStream out) {
        this.print(out, this.resolveStructuredFormat());
    }

    public Object destruct(Object any) {
        return this.createFactoryContext().destruct(any, null);
    }

    public NutsElement toElement(Object o) {
        return this.createFactoryContext().objectToElement(o, null);
    }

    public Object elementToObject(NutsElement o, Type type) {
        return this.createFactoryContext().elementToObject(o, type);
    }

    public NutsElementEntry forEntry(NutsElement key, NutsElement value) {
        return new DefaultNutsElementEntry((NutsElement)(key == null ? this.forNull() : key), (NutsElement)(value == null ? this.forNull() : value));
    }

    public NutsObjectElementBuilder forObject() {
        return new DefaultNutsObjectElementBuilder(this.getSession());
    }

    public NutsArrayElementBuilder forArray() {
        return new DefaultNutsArrayElementBuilder(this.getSession());
    }

    public void setMapper(Class type, NutsElementMapper mapper) {
        this.checkSession();
        ((DefaultNutsElementFactoryService)this.getElementFactoryService()).setMapper(type, mapper);
    }

    public NutsElementFactoryService getElementFactoryService() {
        return this.model.getElementFactoryService(this.getSession());
    }

    public NutsPrimitiveElement forString(String str) {
        this.checkSession();
        return str == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.STRING, str, this.getSession());
    }

    public NutsPrimitiveElement forBoolean(boolean value) {
        this.checkSession();
        if (value) {
            return new DefaultNutsPrimitiveElement(NutsElementType.BOOLEAN, true, this.getSession());
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.BOOLEAN, false, this.getSession());
    }

    public NutsPrimitiveElement forBoolean(String value) {
        return this.forBoolean(NutsUtilStrings.parseBoolean((String)value, (Boolean)false, (Boolean)false));
    }

    public NutsPrimitiveElement forTrue() {
        return this.forBoolean(true);
    }

    public NutsPrimitiveElement forNull() {
        this.checkSession();
        return new DefaultNutsPrimitiveElement(NutsElementType.NULL, null, this.getSession());
    }

    public NutsPrimitiveElement forInstant(Instant instant) {
        this.checkSession();
        return instant == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.INSTANT, instant, this.getSession());
    }

    public NutsPrimitiveElement forByte(Byte value) {
        this.checkSession();
        return value == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.BYTE, value, this.getSession());
    }

    public NutsPrimitiveElement forInt(Integer value) {
        this.checkSession();
        return value == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.INTEGER, value, this.getSession());
    }

    public NutsPrimitiveElement forLong(Long value) {
        this.checkSession();
        return value == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.LONG, value, this.getSession());
    }

    public NutsPrimitiveElement forDouble(Double value) {
        this.checkSession();
        return value == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.DOUBLE, value, this.getSession());
    }

    public NutsPrimitiveElement forFloat(Float value) {
        this.checkSession();
        return value == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.FLOAT, value, this.getSession());
    }

    public NutsPrimitiveElement forFloat(Short value) {
        this.checkSession();
        return value == null ? this.forNull() : new DefaultNutsPrimitiveElement(NutsElementType.SHORT, value, this.getSession());
    }

    public NutsPrimitiveElement forNumber(Number value) {
        this.checkSession();
        if (value == null) {
            return this.forNull();
        }
        switch (value.getClass().getName()) {
            case "java.lang.Byte": {
                return new DefaultNutsPrimitiveElement(NutsElementType.BYTE, value, this.getSession());
            }
            case "java.lang.Short": {
                return new DefaultNutsPrimitiveElement(NutsElementType.SHORT, value, this.getSession());
            }
            case "java.lang.Integer": {
                return new DefaultNutsPrimitiveElement(NutsElementType.INTEGER, value, this.getSession());
            }
            case "java.lang.Long": {
                return new DefaultNutsPrimitiveElement(NutsElementType.LONG, value, this.getSession());
            }
            case "java.math.BigInteger": {
                return new DefaultNutsPrimitiveElement(NutsElementType.BIG_INTEGER, value, this.getSession());
            }
            case "java.lang.float": {
                return new DefaultNutsPrimitiveElement(NutsElementType.FLOAT, value, this.getSession());
            }
            case "java.lang.Double": {
                return new DefaultNutsPrimitiveElement(NutsElementType.DOUBLE, value, this.getSession());
            }
            case "java.math.BigDecimal": {
                return new DefaultNutsPrimitiveElement(NutsElementType.BIG_DECIMAL, value, this.getSession());
            }
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.FLOAT, value, this.getSession());
    }

    public NutsPrimitiveElement forFalse() {
        return this.forBoolean(false);
    }

    public Predicate<Type> getDestructTypeFilter() {
        return this.destructTypeFilter;
    }

    public NutsElementFormat setDestructTypeFilter(Predicate<Type> destructTypeFilter) {
        this.destructTypeFilter = destructTypeFilter;
        return this;
    }

    public NutsPrimitiveElement forNumber(String value) {
        this.checkSession();
        if (value == null) {
            return this.forNull();
        }
        if (value.indexOf(46) >= 0) {
            try {
                return this.forNumber(Double.parseDouble(value));
            }
            catch (Exception exception) {
                try {
                    return this.forNumber(new BigDecimal(value));
                }
                catch (Exception exception2) {
                }
            }
        } else {
            try {
                return this.forNumber(Integer.parseInt(value));
            }
            catch (Exception exception) {
                try {
                    return this.forNumber(Long.parseLong(value));
                }
                catch (Exception exception3) {
                    try {
                        return this.forNumber(new BigInteger(value));
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
        }
        throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse number %s", (Object[])new Object[]{value}));
    }

    public NutsPrimitiveElement forInstant(Date value) {
        this.checkSession();
        if (value == null) {
            return this.forNull();
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.INSTANT, value.toInstant(), this.getSession());
    }

    public NutsPrimitiveElement forInstant(String value) {
        this.checkSession();
        if (value == null) {
            return this.forNull();
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.INSTANT, DefaultNutsPrimitiveElement.parseDate(value), this.getSession());
    }

    public NutsIterableFormat iter(NutsPrintStream writer) {
        switch (this.getContentType()) {
            case JSON: {
                return new DefaultSearchFormatJson(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession().getWorkspace()));
            }
            case XML: {
                return new DefaultSearchFormatXml(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession().getWorkspace()));
            }
            case PLAIN: {
                return new DefaultSearchFormatPlain(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession().getWorkspace()));
            }
            case TABLE: {
                return new DefaultSearchFormatTable(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession().getWorkspace()));
            }
            case TREE: {
                return new DefaultSearchFormatTree(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession().getWorkspace()));
            }
            case PROPS: {
                return new DefaultSearchFormatProps(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession().getWorkspace()));
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)("unsupported iterator for " + this.getContentType()), (Object[])new Object[0]));
    }

    public NutsElement parse(URL url) {
        return this.parse(url, NutsElement.class);
    }

    public NutsElement parse(InputStream inputStream) {
        return this.parse(inputStream, NutsElement.class);
    }

    public NutsElement parse(String string) {
        if (string == null || string.isEmpty()) {
            return this.forNull();
        }
        return this.parse(string, NutsElement.class);
    }

    public NutsElement parse(byte[] bytes) {
        return this.parse(bytes, NutsElement.class);
    }

    public NutsElement parse(Reader reader) {
        return this.parse(reader, NutsElement.class);
    }

    public NutsElement parse(Path file) {
        return this.parse(file, NutsElement.class);
    }

    public NutsElement parse(File file) {
        return this.parse(file, NutsElement.class);
    }
}

