/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsClassifierMapping;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.collections.ClassMap;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectProperty;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectRepository;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectType;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectUtils;
import net.thevpc.nuts.runtime.bundles.reflect.SimpleParametrizedType;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsArrayElement;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsElementEntry;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsObjectElement;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementFactoryService;
import net.thevpc.nuts.runtime.core.format.xml.NutsElementFactoryXmlDocument;
import net.thevpc.nuts.runtime.core.format.xml.NutsElementFactoryXmlElement;
import net.thevpc.nuts.runtime.core.model.DefaultNutsArtifactCall;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDependencyBuilder;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNutsClassifierMapping;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsIdLocationBuilder;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultNutsElementFactoryService
implements NutsElementFactoryService {
    private static final NutsElementMapper F_NULL = new NutsElementFactoryNull();
    private static final NutsElementMapper F_NUTS_ARR = new NutsElementSerializationAdapterArr();
    private static final NutsElementMapper F_STRINGS = new NutsElementFactoryString();
    private static final NutsElementMapper F_CHAR = new NutsElementFactoryChar();
    private static final NutsElementMapper F_NUMBERS = new NutsElementFactoryNumber();
    private static final NutsElementMapper F_BOOLEANS = new NutsElementFactoryBoolean();
    private static final NutsElementMapper F_ENUMS = new NutsElementFactoryEnum();
    private static final NutsElementMapper F_INSTANT = new NutsElementFactoryInstant();
    private static final NutsElementMapper F_DATE = new NutsElementFactoryUtilDate();
    private static final NutsElementMapper F_PATH = new NutsElementFactoryPath();
    private static final NutsElementMapper F_FILE = new NutsElementFactoryFile();
    private static final NutsElementMapper F_ITERATOR = new NutsElementFactoryIterator();
    private static final NutsElementMapper F_NAMED_ELEM = new NutsElementFactoryNamedElement();
    private static final NutsElementMapper F_MAPENTRY = new NutsElementFactoryMapEntry();
    private static final NutsElementMapper F_XML_ELEMENT = new NutsElementFactoryXmlElement();
    private static final NutsElementMapper F_XML_DOCUMENT = new NutsElementFactoryXmlDocument();
    private static final NutsElementMapper F_NUTS_DEF = new NutsElementFactoryNutsDefinition();
    private static final NutsElementMapper F_NUTS_ID = new NutsElementFactoryNutsId();
    private static final NutsElementMapper F_NUTS_VERSION = new NutsElementFactoryNutsVersion();
    private static final NutsElementMapper F_NUTS_DESCRIPTOR = new NutsElementFactoryNutsDescriptor();
    private static final NutsElementMapper F_NUTS_DEPENDENCY = new NutsElementFactoryNutsDependency();
    private static final NutsElementMapper F_NUTS_SDK_LOCATION = new NutsElementFactoryNutsSdkLocation();
    private static final NutsElementMapper F_NUTS_ID_LOCATION = new NutsElementFactoryNutsIdLocation();
    private static final NutsElementMapper F_NUTS_CLASSIFIER_MAPPING = new NutsElementFactoryNutsClassifierMapping();
    private static final NutsElementMapper F_ARTIFACT_CALL = new NutsElementFactoryNutsArtifactCall();
    private final ClassMap<NutsElementMapper> defaultMappers = new ClassMap<NutsElementMapper>(null, NutsElementMapper.class);
    private final Map<Class, NutsElementMapper> coreMappers = new HashMap<Class, NutsElementMapper>();
    private final ClassMap<NutsElementMapper> customMappers = new ClassMap<NutsElementMapper>(null, NutsElementMapper.class);
    private ReflectRepository typesRepository;
    private final NutsWorkspace ws;
    private final NutsElementMapper F_OBJ = new NutsElemenSerializationAdapterObjReflect();
    private final NutsElementMapper F_COLLECTION = new NutsElementFactoryCollection();
    private final NutsElementMapper F_MAP = new NutsElementFactoryMap();

    public DefaultNutsElementFactoryService(NutsWorkspace ws, NutsSession session) {
        this.typesRepository = NutsWorkspaceUtils.of(session).getReflectRepository();
        this.addDefaultFactory(Boolean.class, F_BOOLEANS);
        this.addDefaultFactory(Boolean.TYPE, F_BOOLEANS);
        this.addDefaultFactory(Byte.TYPE, F_NUMBERS);
        this.addDefaultFactory(Short.TYPE, F_NUMBERS);
        this.addDefaultFactory(Integer.TYPE, F_NUMBERS);
        this.addDefaultFactory(Long.TYPE, F_NUMBERS);
        this.addDefaultFactory(Float.TYPE, F_NUMBERS);
        this.addDefaultFactory(Double.TYPE, F_NUMBERS);
        this.addDefaultFactory(Number.class, F_NUMBERS);
        this.addDefaultFactory(Character.TYPE, F_CHAR);
        this.addDefaultFactory(Character.class, F_CHAR);
        this.addDefaultFactory(Object.class, this.F_OBJ);
        this.addDefaultFactory(String.class, F_STRINGS);
        this.addDefaultFactory(StringBuilder.class, F_STRINGS);
        this.addDefaultFactory(StringBuffer.class, F_STRINGS);
        this.addDefaultFactory(Path.class, F_PATH);
        this.addDefaultFactory(File.class, F_FILE);
        this.addDefaultFactory(Date.class, F_DATE);
        this.addDefaultFactory(Instant.class, F_INSTANT);
        this.addDefaultFactory(Enum.class, F_ENUMS);
        this.addDefaultFactory(Collection.class, this.F_COLLECTION);
        this.addDefaultFactory(Iterator.class, F_ITERATOR);
        this.addDefaultFactory(Map.class, this.F_MAP);
        this.addDefaultFactory(Map.Entry.class, F_MAPENTRY);
        this.addDefaultFactory(Element.class, F_XML_ELEMENT);
        this.addDefaultFactory(Document.class, F_XML_DOCUMENT);
        this.addDefaultFactory(boolean[].class, new NutsElementFactoryPrimitiveBooleanArray());
        this.addDefaultFactory(byte[].class, new NutsElementFactoryPrimitiveByteArray());
        this.addDefaultFactory(short[].class, new NutsElementFactoryPrimitiveShortArray());
        this.addDefaultFactory(char[].class, new NutsElementFactoryPrimitiveCharArray());
        this.addDefaultFactory(int[].class, new NutsElementFactoryPrimitiveIntArray());
        this.addDefaultFactory(long[].class, new NutsElementFactoryPrimitiveLongArray());
        this.addDefaultFactory(float[].class, new NutsElementFactoryFloatArray());
        this.addDefaultFactory(double[].class, new NutsElementFactoryPrimitiveDoubleArray());
        this.addDefaultFactory(Object[].class, new NutsElementFactoryObjectArray());
        this.addDefaultFactory(NutsPrimitiveElement.class, new NutsElementFactoryNutsPrimitiveElement());
        this.addDefaultFactory(NutsArrayElement.class, new NutsElementFactoryNutsArrayElement());
        this.addDefaultFactory(NutsObjectElement.class, new NutsElementFactoryNutsObjectElement());
        this.addDefaultFactory(NutsElement.class, new NutsElementFactoryNutsElement());
        this.addDefaultFactory(NutsElementEntry.class, F_NAMED_ELEM);
        this.addDefaultFactory(NutsCommandLine.class, new NutsElementFactoryCommandLine());
        this.addDefaultFactory(NutsString.class, new NutsElementFactoryNutsString());
        this.addDefaultFactory(NutsText.class, new NutsElementFactoryNutsText());
        this.addDefaultFactory(NutsPath.class, new NutsElementFactoryNutsPath());
        this.setCoreMapper(NutsDefinition.class, F_NUTS_DEF);
        this.setCoreMapper(NutsId.class, F_NUTS_ID);
        this.setCoreMapper(NutsVersion.class, F_NUTS_VERSION);
        this.setCoreMapper(NutsDescriptor.class, F_NUTS_DESCRIPTOR);
        this.setCoreMapper(NutsDependency.class, F_NUTS_DEPENDENCY);
        this.setCoreMapper(NutsIdLocation.class, F_NUTS_ID_LOCATION);
        this.setCoreMapper(NutsClassifierMapping.class, F_NUTS_CLASSIFIER_MAPPING);
        this.setCoreMapper(NutsArtifactCall.class, F_ARTIFACT_CALL);
        this.setCoreMapper(NutsSdkLocation.class, F_NUTS_SDK_LOCATION);
        this.ws = ws;
    }

    public final void addDefaultFactory(Class cls, NutsElementMapper instance) {
        this.defaultMappers.put(cls, instance);
    }

    public final void setCoreMapper(Class cls, NutsElementMapper instance) {
        this.coreMappers.put(cls, instance);
        this.customMappers.put(cls, instance);
    }

    public final void setMapper(Class cls, NutsElementMapper instance) {
        if (instance == null) {
            NutsElementMapper cc = this.coreMappers.get(cls);
            if (cc != null) {
                this.customMappers.put(cls, cc);
            } else {
                this.customMappers.remove(cls);
            }
        } else {
            this.customMappers.put(cls, instance);
        }
    }

    public NutsElementMapper getMapper(Type type, boolean defaultOnly) {
        NutsElementMapper f;
        if (type == null) {
            return F_NULL;
        }
        Class cls = ReflectUtils.getRawClass(type);
        if (cls.isArray()) {
            NutsElementMapper f2 = this.defaultMappers.getExact(cls);
            if (f2 != null) {
                return f2;
            }
            return F_NUTS_ARR;
        }
        if (!defaultOnly && (f = this.customMappers.get(cls)) != null) {
            return f;
        }
        NutsElementMapper r = this.defaultMappers.get(cls);
        if (r != null) {
            return r;
        }
        throw new IllegalArgumentException("Unable to find serialization factory for " + type);
    }

    protected Object createObject(NutsElement o, Type to, NutsElementFactoryContext context, boolean defaultOnly) {
        if (o == null || o.type() == NutsElementType.NULL) {
            return F_NULL.createObject(o, (Type)((Object)to), context);
        }
        if (to == null) {
            switch (o.type()) {
                case OBJECT: {
                    to = Map.class;
                    break;
                }
                case ARRAY: {
                    to = List.class;
                    break;
                }
                case STRING: {
                    to = String.class;
                    break;
                }
                case INTEGER: {
                    to = Integer.class;
                    break;
                }
                case FLOAT: {
                    to = Float.class;
                    break;
                }
                case DOUBLE: {
                    to = Double.class;
                    break;
                }
                case BOOLEAN: {
                    to = Boolean.class;
                    break;
                }
                case INSTANT: {
                    to = Instant.class;
                    break;
                }
                case BIG_DECIMAL: {
                    to = BigDecimal.class;
                    break;
                }
                case BIG_INTEGER: {
                    to = BigInteger.class;
                    break;
                }
                case LONG: {
                    to = Long.class;
                    break;
                }
                case BYTE: {
                    to = Byte.class;
                    break;
                }
                case SHORT: {
                    to = Short.class;
                    break;
                }
                case NULL: {
                    return null;
                }
                default: {
                    throw new IllegalArgumentException("unsupported yet " + o.type());
                }
            }
        }
        NutsElementMapper f = this.getMapper((Type)((Object)to), defaultOnly);
        return f.createObject(o, to, context);
    }

    @Override
    public Object createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
        return this.createObject(o, to, context, false);
    }

    @Override
    public Object defaultCreateObject(NutsElement o, Type to, NutsElementFactoryContext context) {
        return this.createObject(o, to, context, true);
    }

    protected Object destruct(Object o, Type expectedType, NutsElementFactoryContext context, boolean defaultOnly) {
        if (o == null) {
            return null;
        }
        if (expectedType == null) {
            expectedType = o.getClass();
        }
        if (context.getDestructTypeFilter() != null && !context.getDestructTypeFilter().test(o.getClass())) {
            return o;
        }
        return this.getMapper(expectedType, defaultOnly).destruct(o, expectedType, context);
    }

    @Override
    public Object destruct(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.destruct(o, expectedType, context, false);
    }

    @Override
    public Object defaultDestruct(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.destruct(o, expectedType, context, true);
    }

    protected NutsElement createElement(Object o, Type expectedType, NutsElementFactoryContext context, boolean defaultOnly) {
        if (o == null) {
            return context.element().forNull();
        }
        if (expectedType == null) {
            expectedType = o.getClass();
        }
        return this.getMapper(expectedType, defaultOnly).createElement(o, expectedType, context);
    }

    @Override
    public NutsElement createElement(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.createElement(o, expectedType, context, false);
    }

    @Override
    public NutsElement defaultCreateElement(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.createElement(o, expectedType, context, true);
    }

    private static List<Object> _destructArray1(Object array, NutsElementFactoryContext context) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> preloaded = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                preloaded.add(context.destruct(Array.get(array, i), null));
            }
            return preloaded;
        }
        return Arrays.stream((Object[])array).map(x -> context.objectToElement(x, null)).collect(Collectors.toList());
    }

    private static NutsArrayElement _createArray1(Object array, NutsElementFactoryContext context) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<NutsElement> preloaded = new ArrayList<NutsElement>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                preloaded.add(context.objectToElement(Array.get(array, i), null));
            }
            return new DefaultNutsArrayElement(preloaded, context.getSession());
        }
        return new DefaultNutsArrayElement(Arrays.stream((Object[])array).map(x -> context.objectToElement(x, null)).collect(Collectors.toList()), context.getSession());
    }

    private static class NutsElementFactoryNutsElement
    implements NutsElementMapper<NutsElement> {
        public Object destruct(NutsElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            switch (src.type()) {
                case ARRAY: {
                    return context.objectToElement((Object)src, NutsArrayElement.class);
                }
                case OBJECT: {
                    return context.objectToElement((Object)src, NutsObjectElement.class);
                }
            }
            return context.objectToElement((Object)src, NutsPrimitiveElement.class);
        }

        public NutsElement createElement(NutsElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            return o;
        }
    }

    private static class NutsElementFactoryNutsObjectElement
    implements NutsElementMapper<NutsObjectElement> {
        public Object destruct(NutsObjectElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            HashSet<Object> visited = new HashSet<Object>();
            boolean map = true;
            ArrayList<AbstractMap.SimpleEntry<Object, Object>> all = new ArrayList<AbstractMap.SimpleEntry<Object, Object>>();
            for (NutsElementEntry nutsElementEntry : src.children()) {
                Object object = context.defaultDestruct((Object)nutsElementEntry.getKey(), null);
                Object v = context.defaultDestruct((Object)nutsElementEntry.getValue(), null);
                if (map && visited.contains(object)) {
                    map = false;
                } else {
                    visited.add(object);
                }
                all.add(new AbstractMap.SimpleEntry<Object, Object>(object, v));
            }
            if (map) {
                LinkedHashMap m = new LinkedHashMap();
                for (Map.Entry entry : all) {
                    m.put(entry.getKey(), entry.getValue());
                }
                return m;
            }
            return all;
        }

        public NutsElement createElement(NutsObjectElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsObjectElement createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            if (o.type() == NutsElementType.OBJECT) {
                return o.asObject();
            }
            return context.element().forObject().set("value", o).build();
        }
    }

    private static class NutsElementFactoryNutsArrayElement
    implements NutsElementMapper<NutsArrayElement> {
        public Object destruct(NutsArrayElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src.children().stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
        }

        public NutsElement createElement(NutsArrayElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsArrayElement createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            if (o.type() == NutsElementType.ARRAY) {
                return o.asArray();
            }
            return context.element().forArray().add(o).build();
        }
    }

    private static class NutsElementFactoryNutsPrimitiveElement
    implements NutsElementMapper<NutsPrimitiveElement> {
        public Object destruct(NutsPrimitiveElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src.getValue();
        }

        public NutsElement createElement(NutsPrimitiveElement src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsPrimitiveElement createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            if (o.type().isPrimitive()) {
                return o.asPrimitive();
            }
            return context.element().forString(o.toString());
        }
    }

    private static class NutsElementFactoryObjectArray
    implements NutsElementMapper<Object[]> {
        public NutsElement createElement(Object[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(Object[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public Object[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            Object[] arr = new Object[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = context.elementToObject(earr.get(i), Object.class);
            }
            return arr;
        }
    }

    private static class NutsElementFactoryPrimitiveDoubleArray
    implements NutsElementMapper<double[]> {
        public NutsElement createElement(double[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(double[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public double[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            double[] arr = new double[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Double)context.elementToObject(earr.get(i), Double.TYPE);
            }
            return arr;
        }
    }

    private static class NutsElementFactoryFloatArray
    implements NutsElementMapper<float[]> {
        public NutsElement createElement(float[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(float[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public float[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            float[] arr = new float[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = ((Float)context.elementToObject(earr.get(i), Float.TYPE)).floatValue();
            }
            return arr;
        }
    }

    private static class NutsElementFactoryPrimitiveLongArray
    implements NutsElementMapper<long[]> {
        public NutsElement createElement(long[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(long[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public long[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            long[] arr = new long[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Long)context.elementToObject(earr.get(i), Long.TYPE);
            }
            return arr;
        }
    }

    private static class NutsElementFactoryPrimitiveIntArray
    implements NutsElementMapper<int[]> {
        public NutsElement createElement(int[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(int[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public int[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            int[] arr = new int[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Integer)context.elementToObject(earr.get(i), Integer.TYPE);
            }
            return arr;
        }
    }

    private static class NutsElementFactoryPrimitiveCharArray
    implements NutsElementMapper<char[]> {
        public Object destruct(char[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public NutsElement createElement(char[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forString(new String(src));
        }

        public char[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            String s = (String)context.elementToObject(o, String.class);
            return s.toCharArray();
        }
    }

    private static class NutsElementFactoryPrimitiveShortArray
    implements NutsElementMapper<short[]> {
        public NutsElement createElement(short[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(short[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public short[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            short[] arr = new short[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Short)context.elementToObject(earr.get(i), Short.TYPE);
            }
            return arr;
        }
    }

    private static class NutsElementFactoryPrimitiveByteArray
    implements NutsElementMapper<byte[]> {
        public NutsElement createElement(byte[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(byte[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public byte[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            byte[] arr = new byte[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Byte)context.elementToObject(earr.get(i), Byte.TYPE);
            }
            return arr;
        }
    }

    private static class NutsElementFactoryPrimitiveBooleanArray
    implements NutsElementMapper<boolean[]> {
        public Object destruct(boolean[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }

        public NutsElement createElement(boolean[] src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public boolean[] createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement earr = o.asArray();
            boolean[] arr = new boolean[earr.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Boolean)context.elementToObject(earr.get(i), Boolean.TYPE);
            }
            return arr;
        }
    }

    private static class NutsElementSerializationAdapterArr
    implements NutsElementMapper<Object> {
        public Object createObject(NutsElement json, Type typeOfResult, NutsElementFactoryContext context) {
            NutsArrayElement e = (NutsArrayElement)json;
            Class arrType = (Class)typeOfResult;
            Class<?> componentType = arrType.getComponentType();
            switch (componentType.getName()) {
                case "boolean": {
                    boolean[] x = new boolean[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getBoolean();
                    }
                    return x;
                }
                case "byte": {
                    byte[] x = new byte[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getByte();
                    }
                    return x;
                }
                case "short": {
                    short[] x = new short[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getShort();
                    }
                    return x;
                }
                case "int": {
                    int[] x = new int[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getInt();
                    }
                    return x;
                }
                case "long": {
                    long[] x = new long[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getLong();
                    }
                    return x;
                }
                case "float": {
                    float[] x = new float[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getFloat();
                    }
                    return x;
                }
                case "double": {
                    double[] x = new double[e.size()];
                    for (int i = 0; i < e.size(); ++i) {
                        x[i] = e.get(i).asPrimitive().getDouble();
                    }
                    return x;
                }
            }
            Object[] x = (Object[])Array.newInstance(componentType, e.size());
            for (int i = 0; i < e.size(); ++i) {
                x[i] = context.elementToObject(e.get(i), componentType);
            }
            return x;
        }

        public NutsElement createElement(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._createArray1(src, context);
        }

        public Object destruct(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
            return DefaultNutsElementFactoryService._destructArray1(src, context);
        }
    }

    private class NutsElemenSerializationAdapterObjReflect
    implements NutsElementMapper<Object> {
        private NutsElemenSerializationAdapterObjReflect() {
        }

        public Object destruct(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
            ReflectType m = DefaultNutsElementFactoryService.this.typesRepository.getType(typeOfSrc);
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
            for (ReflectProperty property : m.getProperties()) {
                Object v;
                if (property.isDefaultValue(v = property.read(src))) continue;
                obj.put(property.getName(), context.destruct(v, null));
            }
            return obj;
        }

        public NutsElement createElement(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
            ReflectType m = DefaultNutsElementFactoryService.this.typesRepository.getType(typeOfSrc);
            NutsObjectElementBuilder obj = context.element().forObject();
            for (ReflectProperty property : m.getProperties()) {
                Object v;
                if (property.isDefaultValue(v = property.read(src))) continue;
                obj.set(property.getName(), context.objectToElement(v, null));
            }
            return obj.build();
        }

        public Object createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            Class c = ReflectUtils.getRawClass(typeOfResult);
            int mod = c.getModifiers();
            if (Modifier.isAbstract(mod)) {
                throw new IllegalArgumentException("cannot instantiate abstract class " + typeOfResult);
            }
            ReflectType m = DefaultNutsElementFactoryService.this.typesRepository.getType(typeOfResult);
            Object instance = m.newInstance();
            NutsObjectElement eobj = o.asObject();
            NutsElementFormat prv = context.element();
            for (ReflectProperty property : m.getProperties()) {
                NutsElement v;
                if (!property.isWrite() || (v = eobj.get((NutsElement)prv.forString(property.getName()))) == null) continue;
                property.write(instance, context.elementToObject(v, property.getPropertyType()));
            }
            return instance;
        }
    }

    private static class NutsElementFactoryNutsIdLocation
    implements NutsElementMapper<NutsIdLocation> {
        private NutsElementFactoryNutsIdLocation() {
        }

        public Object destruct(NutsIdLocation src, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultDestruct((Object)new DefaultNutsIdLocationBuilder().set(src), null);
        }

        public NutsElement createElement(NutsIdLocation o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement((Object)new DefaultNutsIdLocationBuilder().set(o), null);
        }

        public NutsIdLocation createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            DefaultNutsIdLocationBuilder builder = (DefaultNutsIdLocationBuilder)context.defaultElementToObject(o, DefaultNutsIdLocationBuilder.class);
            return builder.build();
        }
    }

    private static class NutsElementFactoryNutsDependency
    implements NutsElementMapper<NutsDependency> {
        private NutsElementFactoryNutsDependency() {
        }

        public Object destruct(NutsDependency o, Type typeOfSrc, NutsElementFactoryContext context) {
            if (o.getExclusions().length == 0) {
                if (context.element().isNtf()) {
                    NutsWorkspace ws = context.getSession().getWorkspace();
                    return ws.dependency().formatter().setNtf(true).setValue(o).format();
                }
                return context.defaultDestruct((Object)context.getSession().getWorkspace().dependency().formatter(o).setNtf(context.element().isNtf()).format(), null);
            }
            return context.defaultDestruct((Object)context.getSession().getWorkspace().dependency().builder().set(o), null);
        }

        public NutsElement createElement(NutsDependency o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement((Object)context.getSession().getWorkspace().dependency().formatter(o).setNtf(context.element().isNtf()).format(), null);
        }

        public NutsDependency createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            if (o.type() == NutsElementType.STRING) {
                return context.getSession().getWorkspace().dependency().parser().setLenient(false).parseDependency(o.asPrimitive().getString());
            }
            DefaultNutsDependencyBuilder builder = (DefaultNutsDependencyBuilder)context.defaultElementToObject(o, DefaultNutsDependencyBuilder.class);
            return context.getSession().getWorkspace().dependency().builder().set((NutsDependencyBuilder)builder).build();
        }
    }

    private static class NutsElementFactoryNutsSdkLocation
    implements NutsElementMapper<NutsSdkLocation> {
        private NutsElementFactoryNutsSdkLocation() {
        }

        public Object destruct(NutsSdkLocation src, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultDestruct((Object)src, null);
        }

        public NutsElement createElement(NutsSdkLocation o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement((Object)o, null);
        }

        public NutsSdkLocation createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsObjectElement obj = o.asObject();
            NutsElementFormat _prm = context.element();
            NutsId id = (NutsId)context.elementToObject(obj.get((NutsElement)_prm.forString("id")), NutsId.class);
            String product = (String)context.elementToObject(obj.get((NutsElement)_prm.forString("product")), String.class);
            String name = (String)context.elementToObject(obj.get((NutsElement)_prm.forString("name")), String.class);
            String path = (String)context.elementToObject(obj.get((NutsElement)_prm.forString("path")), String.class);
            String version = (String)context.elementToObject(obj.get((NutsElement)_prm.forString("version")), String.class);
            String packaging = (String)context.elementToObject(obj.get((NutsElement)_prm.forString("packaging")), String.class);
            int priority = (Integer)context.elementToObject(obj.get((NutsElement)_prm.forString("priority")), Integer.TYPE);
            return new NutsSdkLocation(id, product, name, path, version, packaging, priority);
        }
    }

    private static class NutsElementFactoryNutsDescriptor
    implements NutsElementMapper<NutsDescriptor> {
        private NutsElementFactoryNutsDescriptor() {
        }

        public Object destruct(NutsDescriptor src, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultDestruct((Object)context.getSession().getWorkspace().descriptor().descriptorBuilder().set(src), null);
        }

        public NutsElement createElement(NutsDescriptor o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement((Object)context.getSession().getWorkspace().descriptor().descriptorBuilder().set(o), null);
        }

        public NutsDescriptor createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            DefaultNutsDescriptorBuilder builder = (DefaultNutsDescriptorBuilder)context.defaultElementToObject(o, DefaultNutsDescriptorBuilder.class);
            return context.getSession().getWorkspace().descriptor().descriptorBuilder().set((NutsDescriptorBuilder)builder).build();
        }
    }

    private static class NutsElementFactoryFile
    implements NutsElementMapper<File> {
        private NutsElementFactoryFile() {
        }

        public Object destruct(File src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(File o, Type typeOfSrc, NutsElementFactoryContext context) {
            if (context.element().isNtf()) {
                NutsWorkspace ws = context.getSession().getWorkspace();
                NutsTextStyled n = ws.text().forStyled(o.toString(), NutsTextStyle.path());
                return ws.elem().forString(n.toString());
            }
            return context.defaultObjectToElement((Object)o.toString(), null);
        }

        public File createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            return new File(o.asPrimitive().getString());
        }
    }

    private static class NutsElementFactoryPath
    implements NutsElementMapper<Path> {
        private NutsElementFactoryPath() {
        }

        public Object destruct(Path src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Path o, Type typeOfSrc, NutsElementFactoryContext context) {
            if (context.element().isNtf()) {
                NutsWorkspace ws = context.getSession().getWorkspace();
                NutsTextStyled n = ws.text().forStyled(o.toString(), NutsTextStyle.path());
                return ws.elem().forString(n.toString());
            }
            return context.defaultObjectToElement((Object)o.toString(), null);
        }

        public Path createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            return Paths.get(o.asPrimitive().getString(), new String[0]);
        }
    }

    private static class NutsElementFactoryNutsVersion
    implements NutsElementMapper<NutsVersion> {
        private NutsElementFactoryNutsVersion() {
        }

        public Object destruct(NutsVersion src, Type typeOfSrc, NutsElementFactoryContext context) {
            if (context.element().isNtf()) {
                NutsWorkspace ws = context.getSession().getWorkspace();
                return ws.version().formatter(src).setNtf(true).format();
            }
            return src.toString();
        }

        public NutsElement createElement(NutsVersion o, Type typeOfSrc, NutsElementFactoryContext context) {
            if (context.element().isNtf()) {
                NutsWorkspace ws = context.getSession().getWorkspace();
                return ws.elem().forString(ws.version().formatter(o).setNtf(true).format().toString());
            }
            return context.defaultObjectToElement((Object)o.toString(), null);
        }

        public NutsVersion createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            return context.getSession().getWorkspace().version().parser().parse(o.asPrimitive().getString());
        }
    }

    private static class NutsElementFactoryNutsId
    implements NutsElementMapper<NutsId> {
        private NutsElementFactoryNutsId() {
        }

        public Object destruct(NutsId o, Type typeOfSrc, NutsElementFactoryContext context) {
            if (context.element().isNtf()) {
                return context.getSession().getWorkspace().id().formatter(o).setNtf(true).format();
            }
            return o.toString();
        }

        public NutsElement createElement(NutsId o, Type typeOfSrc, NutsElementFactoryContext context) {
            if (context.element().isNtf()) {
                NutsWorkspace ws = context.getSession().getWorkspace();
                return ws.elem().forString(ws.id().formatter(o).setNtf(true).format().toString());
            }
            return context.defaultObjectToElement((Object)o.toString(), null);
        }

        public NutsId createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            return context.getSession().getWorkspace().id().parser().parse(o.asPrimitive().getString());
        }
    }

    private static class NutsElementFactoryNutsArtifactCall
    implements NutsElementMapper<NutsArtifactCall> {
        private NutsElementFactoryNutsArtifactCall() {
        }

        public Object destruct(NutsArtifactCall o, Type typeOfSrc, NutsElementFactoryContext context) {
            DefaultNutsArtifactCall dd = o instanceof DefaultNutsArtifactCall ? (DefaultNutsArtifactCall)o : new DefaultNutsArtifactCall(o);
            return context.defaultDestruct((Object)dd, null);
        }

        public NutsElement createElement(NutsArtifactCall o, Type typeOfSrc, NutsElementFactoryContext context) {
            DefaultNutsArtifactCall dd = o instanceof DefaultNutsArtifactCall ? (DefaultNutsArtifactCall)o : new DefaultNutsArtifactCall(o);
            return context.defaultObjectToElement((Object)dd, null);
        }

        public NutsArtifactCall createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsObjectElement object = o.asObject();
            NutsId id = (NutsId)context.elementToObject(object.get((NutsElement)context.element().forString("id")), NutsId.class);
            String[] arguments = (String[])context.elementToObject(object.get((NutsElement)context.element().forString("arguments")), String[].class);
            Map properties = (Map)context.elementToObject(object.get((NutsElement)context.element().forString("properties")), (Type)ReflectUtils.createParametrizedType(Map.class, new Type[]{String.class, String.class}));
            return new DefaultNutsArtifactCall(id, arguments, properties);
        }
    }

    private static class NutsElementFactoryNutsClassifierMapping
    implements NutsElementMapper<NutsClassifierMapping> {
        private NutsElementFactoryNutsClassifierMapping() {
        }

        public Object destruct(NutsClassifierMapping src, Type typeOfSrc, NutsElementFactoryContext context) {
            DefaultNutsClassifierMapping dd = src instanceof DefaultNutsClassifierMapping ? (DefaultNutsClassifierMapping)src : new DefaultNutsClassifierMapping(src);
            return context.defaultDestruct((Object)dd, null);
        }

        public NutsElement createElement(NutsClassifierMapping o, Type typeOfSrc, NutsElementFactoryContext context) {
            DefaultNutsClassifierMapping dd = o instanceof DefaultNutsClassifierMapping ? (DefaultNutsClassifierMapping)o : new DefaultNutsClassifierMapping(o);
            return context.defaultObjectToElement((Object)dd, null);
        }

        public NutsClassifierMapping createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            return (NutsClassifierMapping)context.defaultElementToObject(o, DefaultNutsClassifierMapping.class);
        }
    }

    private static class NutsElementFactoryNutsDefinition
    implements NutsElementMapper<NutsDefinition> {
        private NutsElementFactoryNutsDefinition() {
        }

        public Object destruct(NutsDefinition src, Type typeOfSrc, NutsElementFactoryContext context) {
            DefaultNutsDefinition dd = src instanceof DefaultNutsDefinition ? (DefaultNutsDefinition)src : new DefaultNutsDefinition(src, context.getSession());
            return context.defaultDestruct((Object)dd, null);
        }

        public NutsElement createElement(NutsDefinition o, Type typeOfSrc, NutsElementFactoryContext context) {
            DefaultNutsDefinition dd = o instanceof DefaultNutsDefinition ? (DefaultNutsDefinition)o : new DefaultNutsDefinition(o, context.getSession());
            return context.defaultObjectToElement((Object)dd, null);
        }

        public NutsDefinition createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            NutsDefinition d = (NutsDefinition)context.defaultElementToObject(o, DefaultNutsDefinition.class);
            return new DefaultNutsDefinition(d, context.getSession());
        }
    }

    private static class NutsElementFactoryNull
    implements NutsElementMapper<Object> {
        private NutsElementFactoryNull() {
        }

        public Object destruct(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
            return null;
        }

        public NutsElement createElement(Object o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forNull();
        }

        public Object createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            Class c;
            if (to instanceof Class && (c = (Class)to).isPrimitive()) {
                switch (c.getName()) {
                    case "boolean": {
                        return false;
                    }
                    case "byte": {
                        return (byte)0;
                    }
                    case "short": {
                        return (short)0;
                    }
                    case "int": {
                        return 0;
                    }
                    case "char": {
                        return Character.valueOf('\u0000');
                    }
                    case "long": {
                        return 0L;
                    }
                    case "float": {
                        return Float.valueOf(0.0f);
                    }
                    case "double": {
                        return 0.0;
                    }
                }
            }
            return null;
        }
    }

    private static class NutsElementFactoryString
    implements NutsElementMapper<String> {
        private NutsElementFactoryString() {
        }

        public Object destruct(String src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(String o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forString(String.valueOf(o));
        }

        public String createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            return o.asPrimitive().getString();
        }
    }

    private static class NutsElementFactoryChar
    implements NutsElementMapper<Character> {
        private NutsElementFactoryChar() {
        }

        public Object destruct(Character src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Character o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forString(String.valueOf(o));
        }

        public Character createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            String s = o.asPrimitive().getString();
            return Character.valueOf(s == null || s.isEmpty() ? (to instanceof Class && ((Class)to).isPrimitive() ? Character.valueOf('\u0000') : null).charValue() : s.charAt(0));
        }
    }

    private static class NutsElementFactoryEnum
    implements NutsElementMapper<Enum> {
        private NutsElementFactoryEnum() {
        }

        public Object destruct(Enum src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Enum o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forString(String.valueOf(o));
        }

        public Enum createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            switch (o.type()) {
                case INTEGER: 
                case LONG: 
                case BYTE: 
                case SHORT: {
                    NutsPrimitiveElement p = o.asPrimitive();
                    return (Enum)((Class)to).getEnumConstants()[p.getInt()];
                }
                case STRING: {
                    NutsPrimitiveElement p = o.asPrimitive();
                    return Enum.valueOf(ReflectUtils.getRawClass(to), p.getString());
                }
            }
            throw new IllegalArgumentException("unexpected");
        }
    }

    private static class NutsElementFactoryBoolean
    implements NutsElementMapper<Boolean> {
        private NutsElementFactoryBoolean() {
        }

        public Object destruct(Boolean src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Boolean o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forBoolean(o.booleanValue());
        }

        public Boolean createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            switch (((Class)to).getName()) {
                case "boolean": 
                case "java.lang.Boolean": {
                    return o.asPrimitive().getBoolean();
                }
            }
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class NutsElementFactoryNumber
    implements NutsElementMapper<Number> {
        private NutsElementFactoryNumber() {
        }

        public Object destruct(Number src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Number o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forNumber(o);
        }

        public Number createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            switch (((Class)to).getName()) {
                case "byte": 
                case "java.lang.Byte": {
                    return o.asPrimitive().getByte();
                }
                case "short": 
                case "java.lang.Short": {
                    return o.asPrimitive().getShort();
                }
                case "int": 
                case "java.lang.Integer": {
                    return o.asPrimitive().getInt();
                }
                case "long": 
                case "java.lang.Long": {
                    return o.asPrimitive().getShort();
                }
                case "float": 
                case "java.lang.Float": {
                    return o.asPrimitive().getShort();
                }
                case "double": 
                case "java.lang.Double": {
                    return o.asPrimitive().getShort();
                }
                case "java.lang.BigDecimal": {
                    return new BigDecimal(o.asPrimitive().getString());
                }
                case "java.lang.BigInteger": {
                    return new BigInteger(o.asPrimitive().getString());
                }
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class NutsElementFactoryNutsPath
    implements NutsElementMapper<NutsPath> {
        private NutsElementFactoryNutsPath() {
        }

        public Object destruct(NutsPath src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src.toString();
        }

        public NutsElement createElement(NutsPath o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement(this.destruct(o, (Type)null, context), null);
        }

        public NutsPath createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            String i = (String)context.defaultElementToObject(o, String.class);
            return context.getSession().getWorkspace().io().path(i);
        }
    }

    private static class NutsElementFactoryNutsText
    implements NutsElementMapper<NutsText> {
        private NutsElementFactoryNutsText() {
        }

        public Object destruct(NutsText src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src.filteredText();
        }

        public NutsElement createElement(NutsText o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement(this.destruct(o, (Type)null, context), null);
        }

        public NutsText createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            String i = (String)context.defaultElementToObject(o, String.class);
            return context.getSession().getWorkspace().text().forPlain(i).toText();
        }
    }

    private static class NutsElementFactoryNutsString
    implements NutsElementMapper<NutsString> {
        private NutsElementFactoryNutsString() {
        }

        public Object destruct(NutsString src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src.toString();
        }

        public NutsElement createElement(NutsString o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement(this.destruct(o, (Type)null, context), null);
        }

        public NutsString createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            String i = (String)context.defaultElementToObject(o, String.class);
            return context.getSession().getWorkspace().text().parse(i);
        }
    }

    private static class NutsElementFactoryCommandLine
    implements NutsElementMapper<NutsCommandLine> {
        private NutsElementFactoryCommandLine() {
        }

        public Object destruct(NutsCommandLine src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src.toStringArray();
        }

        public NutsElement createElement(NutsCommandLine o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.defaultObjectToElement(this.destruct(o, (Type)null, context), null);
        }

        public NutsCommandLine createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            String[] i = (String[])context.defaultElementToObject(o, String[].class);
            return context.getSession().getWorkspace().commandLine().create(i);
        }
    }

    private static class NutsElementFactoryUtilDate
    implements NutsElementMapper<Date> {
        private NutsElementFactoryUtilDate() {
        }

        public Object destruct(Date src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Date o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forInstant(o.toInstant());
        }

        public Date createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            Instant i = (Instant)context.defaultElementToObject(o, Instant.class);
            return new Date(i.toEpochMilli());
        }
    }

    private static class NutsElementFactoryInstant
    implements NutsElementMapper<Instant> {
        private NutsElementFactoryInstant() {
        }

        public Object destruct(Instant src, Type typeOfSrc, NutsElementFactoryContext context) {
            return src;
        }

        public NutsElement createElement(Instant o, Type typeOfSrc, NutsElementFactoryContext context) {
            return context.element().forInstant(o);
        }

        public Instant createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            switch (o.type()) {
                case INSTANT: {
                    return o.asPrimitive().getInstant();
                }
                case INTEGER: {
                    return Instant.ofEpochMilli(o.asPrimitive().getInt());
                }
                case LONG: {
                    return Instant.ofEpochMilli(o.asPrimitive().getLong());
                }
                case STRING: {
                    return Instant.parse(o.asPrimitive().getString());
                }
            }
            throw new IllegalArgumentException("unable to parse instant " + o);
        }
    }

    private static class NutsElementFactoryIterator
    implements NutsElementMapper<Iterator> {
        private NutsElementFactoryIterator() {
        }

        public Object destruct(Iterator o, Type typeOfSrc, NutsElementFactoryContext context) {
            Iterator nl = o;
            ArrayList<Object> values = new ArrayList<Object>();
            while (nl.hasNext()) {
                values.add(context.destruct(nl.next(), null));
            }
            return values;
        }

        public NutsElement createElement(Iterator o, Type typeOfSrc, NutsElementFactoryContext context) {
            Iterator nl = o;
            ArrayList<NutsElement> values = new ArrayList<NutsElement>();
            while (nl.hasNext()) {
                values.add(context.objectToElement(nl.next(), null));
            }
            return new DefaultNutsArrayElement(values, context.getSession());
        }

        public Iterator createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            return o.asArray().children().stream().map(x -> context.elementToObject(x, Object.class)).collect(Collectors.toList()).iterator();
        }
    }

    private class NutsElementFactoryCollection
    implements NutsElementMapper {
        private NutsElementFactoryCollection() {
        }

        public Object destruct(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
            Collection coll = (Collection)src;
            return coll.stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
        }

        public NutsElement createElement(Object o, Type typeOfSrc, NutsElementFactoryContext context) {
            Collection coll = (Collection)o;
            List<NutsElement> collect = coll.stream().map(x -> context.objectToElement(x, null)).collect(Collectors.toList());
            return new DefaultNutsArrayElement(collect, context.getSession());
        }

        public Collection fillObject(NutsElement o, Collection coll, Type elemType, Type to, NutsElementFactoryContext context) {
            for (NutsElement nutsElement : o.asArray().children()) {
                coll.add(context.elementToObject(nutsElement, elemType));
            }
            return coll;
        }

        public Collection createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            Class cls = ReflectUtils.getRawClass(to);
            Object elemType = Object.class;
            if (to instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)to;
                elemType = pt.getActualTypeArguments()[0];
            }
            switch (cls.getName()) {
                case "java.util.Collection": 
                case "java.util.List": 
                case "java.util.ArrayList": {
                    return this.fillObject(o, new ArrayList(o.asArray().size()), (Type)elemType, to, context);
                }
                case "java.util.Set": 
                case "java.util.LinkedHashset": {
                    return this.fillObject(o, new LinkedHashSet(), (Type)elemType, to, context);
                }
                case "java.util.Hashset": {
                    return this.fillObject(o, new HashSet(), (Type)elemType, to, context);
                }
                case "java.util.SortedSet": 
                case "java.util.NavigableSet": 
                case "java.util.TreeSet": {
                    return this.fillObject(o, new TreeSet(), (Type)elemType, to, context);
                }
                case "java.util.Queue": {
                    return this.fillObject(o, new LinkedList(), (Type)elemType, to, context);
                }
                case "java.util.BlockingQueue": {
                    return this.fillObject(o, new LinkedBlockingQueue(), (Type)elemType, to, context);
                }
                case "java.util.TransferQueue": {
                    return this.fillObject(o, new LinkedTransferQueue(), (Type)elemType, to, context);
                }
                case "java.util.Deque": {
                    return this.fillObject(o, new ArrayList(), (Type)elemType, to, context);
                }
            }
            ReflectType m = DefaultNutsElementFactoryService.this.typesRepository.getType(to);
            return this.fillObject(o, (Collection)m.newInstance(), (Type)elemType, to, context);
        }
    }

    private static class NutsElementFactoryMapEntry
    implements NutsElementMapper<Map.Entry> {
        private NutsElementFactoryMapEntry() {
        }

        public NutsElement createElement(Map.Entry o, Type typeOfSrc, NutsElementFactoryContext context) {
            Map.Entry je = o;
            return context.element().forObject().set("key", context.objectToElement(je.getKey(), null)).set("value", context.objectToElement(je.getValue(), null)).build();
        }

        public Object destruct(Map.Entry src, Type typeOfSrc, NutsElementFactoryContext context) {
            Map.Entry je = src;
            return new AbstractMap.SimpleEntry<Object, Object>(context.destruct(je.getKey(), null), context.destruct(je.getValue(), null));
        }

        public Map.Entry createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            if (to instanceof ParameterizedType) {
                Type[] kvt = ((ParameterizedType)to).getActualTypeArguments();
                return new AbstractMap.SimpleEntry<Object, Object>(context.elementToObject(o.asObject().get((NutsElement)context.element().forString("key")), kvt[0]), context.elementToObject(o.asObject().get((NutsElement)context.element().forString("value")), kvt[0]));
            }
            return new AbstractMap.SimpleEntry<Object, Object>(context.elementToObject(o.asObject().get((NutsElement)context.element().forString("key")), Object.class), context.elementToObject(o.asObject().get((NutsElement)context.element().forString("value")), Object.class));
        }
    }

    private class NutsElementFactoryMap
    implements NutsElementMapper<Map> {
        private NutsElementFactoryMap() {
        }

        public Object destruct(Map src, Type typeOfSrc, NutsElementFactoryContext context) {
            Map je = src;
            LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
            if (je != null) {
                Iterator iterator = je.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e0;
                    Map.Entry e = e0 = iterator.next();
                    Object k = context.destruct(e.getKey(), null);
                    Object v = context.destruct(e.getValue(), null);
                    m.put(k, v);
                }
            }
            return m;
        }

        public NutsElement createElement(Map o, Type typeOfSrc, NutsElementFactoryContext context) {
            Map je = o;
            LinkedHashMap<NutsElement, NutsElement> m = new LinkedHashMap<NutsElement, NutsElement>();
            if (je != null) {
                Iterator iterator = je.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry e0;
                    Map.Entry e = e0 = iterator.next();
                    NutsElement k = context.objectToElement(e.getKey(), null);
                    NutsElement v = context.objectToElement(e.getValue(), null);
                    m.put(k, v);
                }
            }
            return new DefaultNutsObjectElement(m, context.getSession());
        }

        public Map fillObject(NutsElement o, Map all, Type elemType1, Type elemType2, Type to, NutsElementFactoryContext context) {
            if (o.type() == NutsElementType.OBJECT) {
                for (NutsElementEntry kv : o.asObject().children()) {
                    NutsElement k = kv.getKey();
                    NutsElement v = kv.getValue();
                    all.put(context.elementToObject(k, elemType1), context.elementToObject(v, elemType2));
                }
            } else if (o.type() == NutsElementType.ARRAY) {
                for (NutsElement ee : o.asArray().children()) {
                    NutsObjectElement kv = ee.asObject();
                    NutsElement k = kv.get((NutsElement)context.element().forString("key"));
                    NutsElement v = kv.get((NutsElement)context.element().forString("value"));
                    all.put(context.elementToObject(k, elemType1), context.elementToObject(v, elemType2));
                }
            } else {
                throw new IllegalArgumentException("unsupported");
            }
            return all;
        }

        public Map createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
            Class cls = Map.class;
            Type elemType1 = null;
            Type elemType2 = null;
            if (to instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)to;
                Type rawType = pt.getRawType();
                if (rawType instanceof Class) {
                    cls = (Class)rawType;
                }
                elemType1 = pt.getActualTypeArguments()[0];
                elemType2 = pt.getActualTypeArguments()[1];
            }
            if (cls == null) {
                throw new IllegalArgumentException("invalid");
            }
            switch (cls.getName()) {
                case "java.util.Map": 
                case "java.util.LinkedHashMap": {
                    return this.fillObject(o, new LinkedHashMap(o.asObject().size()), elemType1, elemType2, to, context);
                }
                case "java.util.HashMap": {
                    return this.fillObject(o, new HashMap(o.asObject().size()), elemType1, elemType2, to, context);
                }
                case "java.util.SortedMap": 
                case "java.util.NavigableMap": {
                    return this.fillObject(o, new TreeMap(), elemType1, elemType2, to, context);
                }
            }
            return this.fillObject(o, (Map)DefaultNutsElementFactoryService.this.typesRepository.getType(to).newInstance(), elemType1, elemType2, to, context);
        }
    }

    private static class NutsElementFactoryNamedElement
    implements NutsElementMapper<NutsElementEntry> {
        private NutsElementFactoryNamedElement() {
        }

        public Object destruct(NutsElementEntry src, Type typeOfSrc, NutsElementFactoryContext context) {
            return new AbstractMap.SimpleEntry<Object, Object>(context.defaultDestruct((Object)src.getKey(), NutsElement.class), context.defaultDestruct((Object)src.getValue(), NutsElement.class));
        }

        public NutsElement createElement(NutsElementEntry o, Type typeOfSrc, NutsElementFactoryContext context) {
            NutsElementEntry je = o;
            HashMap<String, NutsElement> m = new HashMap<String, NutsElement>();
            m.put("key", je.getKey());
            m.put("value", je.getValue());
            return context.objectToElement(m, (Type)ReflectUtils.createParametrizedType(Map.class, new Type[]{String.class, Object.class}));
        }

        public NutsElementEntry createObject(NutsElement o, Type typeOfResult, NutsElementFactoryContext context) {
            Type[] typeArray;
            if (typeOfResult instanceof ParameterizedType) {
                typeArray = ((ParameterizedType)typeOfResult).getActualTypeArguments();
            } else {
                Type[] typeArray2 = new Type[2];
                typeArray2[0] = Object.class;
                typeArray = typeArray2;
                typeArray2[1] = Object.class;
            }
            Type[] args = typeArray;
            SimpleParametrizedType mapType = new SimpleParametrizedType((Type)((Object)Map.class), args);
            Map map = (Map)context.elementToObject(o, (Type)mapType);
            return new DefaultNutsElementEntry((NutsElement)map.get("key"), (NutsElement)map.get("value"));
        }
    }
}

