/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsArrayElement;

public class DefaultNutsArrayElementBuilder
implements NutsArrayElementBuilder {
    private final List<NutsElement> values = new ArrayList<NutsElement>();
    private NutsSession session;

    public DefaultNutsArrayElementBuilder(NutsSession session) {
        this.session = session;
        if (session == null) {
            throw new NullPointerException();
        }
    }

    public List<NutsElement> children() {
        return Collections.unmodifiableList(this.values);
    }

    public int size() {
        return this.values.size();
    }

    public NutsElement get(int index) {
        return this.values.get(index);
    }

    public NutsArrayElementBuilder addAll(NutsArrayElement value) {
        if (value == null) {
            this.add((NutsElement)this._elements().forNull());
        } else {
            for (NutsElement child : value.children()) {
                this.add(child);
            }
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(NutsElement[] value) {
        for (NutsElement e : value) {
            this.add(e);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(NutsArrayElementBuilder value) {
        if (value == null) {
            this.add((NutsElement)this._elements().forNull());
        } else {
            for (NutsElement child : value.children()) {
                this.add(child);
            }
        }
        return this;
    }

    public NutsArrayElementBuilder add(NutsElement e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.values.add(this.denull(e));
        return this;
    }

    public NutsArrayElementBuilder insert(int index, NutsElement e) {
        this.values.add(index, this.denull(e));
        return this;
    }

    public NutsArrayElementBuilder set(int index, NutsElement e) {
        this.values.set(index, this.denull(e));
        return this;
    }

    public NutsArrayElementBuilder clear() {
        this.values.clear();
        return this;
    }

    public NutsArrayElementBuilder remove(int index) {
        this.values.remove(index);
        return this;
    }

    public NutsArrayElementBuilder set(NutsArrayElementBuilder other) {
        this.clear();
        this.addAll(other);
        return this;
    }

    public NutsArrayElementBuilder set(NutsArrayElement other) {
        this.clear();
        this.addAll(other);
        return this;
    }

    public NutsArrayElementBuilder addAll(String[] value) {
        for (String b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(int[] value) {
        for (int b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(double[] value) {
        for (double b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(long[] value) {
        for (long b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(float[] value) {
        for (float b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(boolean[] value) {
        for (boolean b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(char[] value) {
        for (char b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder addAll(byte[] value) {
        for (byte b : value) {
            this.add(b);
        }
        return this;
    }

    public NutsArrayElementBuilder add(int value) {
        return this.add((NutsElement)this._elements().forInt(Integer.valueOf(value)));
    }

    public NutsArrayElementBuilder add(long value) {
        return this.add((NutsElement)this._elements().forLong(Long.valueOf(value)));
    }

    public NutsArrayElementBuilder add(double value) {
        return this.add((NutsElement)this._elements().forDouble(Double.valueOf(value)));
    }

    public NutsArrayElementBuilder add(float value) {
        return this.add((NutsElement)this._elements().forFloat(Float.valueOf(value)));
    }

    public NutsArrayElementBuilder add(byte value) {
        return this.add((NutsElement)this._elements().forByte(Byte.valueOf(value)));
    }

    public NutsArrayElementBuilder add(boolean value) {
        return this.add((NutsElement)this._elements().forBoolean(value));
    }

    public NutsArrayElementBuilder add(char value) {
        return this.add((NutsElement)this._elements().forString(String.valueOf(value)));
    }

    public NutsArrayElementBuilder add(Number value) {
        return this.add((NutsElement)this._elements().forNumber(value));
    }

    public NutsArrayElementBuilder add(String value) {
        return this.add((NutsElement)this._elements().forString(value));
    }

    public NutsArrayElement build() {
        return new DefaultNutsArrayElement(this.values, this.session);
    }

    public String toString() {
        return "[" + this.children().stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private NutsElement denull(NutsElement e) {
        if (e == null) {
            return this._elements().forNull();
        }
        return e;
    }

    private NutsElementFormat _elements() {
        return this.session.getWorkspace().elem().setSession(this.session);
    }
}

