/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.elem;

import java.time.Instant;
import java.util.LinkedHashMap;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsArrayElement;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsObjectElement;

public abstract class AbstractNutsElement
implements NutsElement {
    protected transient NutsSession session;
    private NutsElementType type;

    public AbstractNutsElement(NutsElementType type, NutsSession session) {
        this.type = type;
        this.session = session;
    }

    public NutsElementType type() {
        return this.type;
    }

    public NutsPrimitiveElement asPrimitive() {
        if (this instanceof NutsPrimitiveElement) {
            return (NutsPrimitiveElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to primitive" + this);
    }

    public NutsObjectElement asObject() {
        if (this instanceof NutsObjectElement) {
            return (NutsObjectElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to object: " + this);
    }

    public NutsArrayElement asArray() {
        if (this instanceof NutsArrayElement) {
            return (NutsArrayElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to array" + this);
    }

    public NutsObjectElement asSafeObject() {
        if (this instanceof NutsObjectElement) {
            return (NutsObjectElement)this;
        }
        return new DefaultNutsObjectElement(new LinkedHashMap<NutsElement, NutsElement>(), this.session);
    }

    public NutsArrayElement asSafeArray() {
        if (this instanceof NutsArrayElement) {
            return (NutsArrayElement)this;
        }
        return new DefaultNutsArrayElement(new NutsElement[0], this.session);
    }

    public boolean isPrimitive() {
        NutsElementType t = this.type();
        return t != NutsElementType.ARRAY && t != NutsElementType.OBJECT;
    }

    public boolean isNumber() {
        NutsElementType t = this.type();
        switch (t) {
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNull() {
        NutsElementType t = this.type();
        return t == NutsElementType.NULL;
    }

    public boolean isString() {
        NutsElementType t = this.type();
        return t == NutsElementType.STRING;
    }

    public boolean isByte() {
        return this.type() == NutsElementType.BYTE;
    }

    public boolean isInt() {
        NutsElementType t = this.type();
        return t == NutsElementType.INTEGER;
    }

    public boolean isLong() {
        return this.type() == NutsElementType.LONG;
    }

    public boolean isShort() {
        return this.type() == NutsElementType.SHORT;
    }

    public boolean isFloat() {
        return this.type() == NutsElementType.FLOAT;
    }

    public boolean isDouble() {
        return this.type() == NutsElementType.DOUBLE;
    }

    public boolean isObject() {
        NutsElementType t = this.type();
        return t == NutsElementType.OBJECT;
    }

    public boolean isArray() {
        NutsElementType t = this.type();
        return t == NutsElementType.ARRAY;
    }

    public boolean isInstant() {
        return this.type() == NutsElementType.INSTANT;
    }

    public String asString() {
        return this.asPrimitive().getString();
    }

    public boolean asBoolean() {
        return this.asPrimitive().getBoolean();
    }

    public byte asByte() {
        return this.asPrimitive().getByte();
    }

    public double asDouble() {
        return this.asPrimitive().getDouble();
    }

    public float asFloat() {
        return this.asPrimitive().getFloat();
    }

    public Instant asInstant() {
        return this.asPrimitive().getInstant();
    }

    public Integer asSafeInt() {
        if (this.isNumber()) {
            return this.asInt();
        }
        return null;
    }

    public int asSafeInt(int def) {
        Integer i = this.asSafeInt();
        return i == null ? def : i;
    }

    public Long asSafeLong() {
        if (this.isNumber()) {
            return this.asLong();
        }
        return null;
    }

    public long asSafeLong(long def) {
        Long i = this.asSafeLong();
        return i == null ? def : i;
    }

    public Double asSafeDouble() {
        if (this.isNumber()) {
            return this.asDouble();
        }
        return null;
    }

    public short asSafeShort(short def) {
        Short i = this.asSafeShort();
        return i == null ? def : i;
    }

    public Short asSafeShort() {
        if (this.isNumber()) {
            return this.asShort();
        }
        return null;
    }

    public byte asSafeByte(byte def) {
        Byte i = this.asSafeByte();
        return i == null ? def : i;
    }

    public Byte asSafeByte() {
        if (this.isNumber()) {
            return this.asByte();
        }
        return null;
    }

    public double asSafeDouble(double def) {
        Double i = this.asSafeDouble();
        return i == null ? def : i;
    }

    public Float asSafeFloat() {
        if (this.isNumber()) {
            return Float.valueOf(this.asFloat());
        }
        return null;
    }

    public float asSafeFloat(float def) {
        Float i = this.asSafeFloat();
        return i == null ? def : i.floatValue();
    }

    public String asSafeString(String def) {
        if (this.isString()) {
            return this.asPrimitive().getString();
        }
        return def;
    }

    public String asSafeString() {
        if (this.isPrimitive()) {
            return this.asPrimitive().getString();
        }
        return null;
    }

    public int asInt() {
        return this.asPrimitive().getInt();
    }

    public long asLong() {
        return this.asPrimitive().getLong();
    }

    public short asShort() {
        return this.asPrimitive().getShort();
    }
}

