/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.util.Iterator;
import net.thevpc.nuts.NutsIterableFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;

public class NutsPrintIterator<T>
implements Iterator<T> {
    Iterator<T> curr;
    NutsWorkspace ws;
    NutsIterableFormat listFormat;
    NutsPrintStream out;
    NutsFetchDisplayOptions displayOptions;
    long count = 0L;

    public NutsPrintIterator(Iterator<T> curr, NutsWorkspace ws, NutsPrintStream out, NutsFetchDisplayOptions displayOptions, NutsSession session) {
        this.curr = curr;
        this.ws = ws;
        this.out = out;
        this.listFormat = session.getIterableOutput();
        this.displayOptions = displayOptions;
        if (this.listFormat == null) {
            this.listFormat = session.getWorkspace().elem().setContentType(session.getOutputFormat()).iter(out);
        }
        this.listFormat.configure(true, displayOptions.toCommandLineOptions());
    }

    @Override
    public boolean hasNext() {
        boolean p = this.curr.hasNext();
        if (!p) {
            this.listFormat.complete(this.count);
        }
        return p;
    }

    @Override
    public T next() {
        T n = this.curr.next();
        if (this.count == 0L) {
            this.listFormat.start();
        }
        this.listFormat.next(n, this.count);
        ++this.count;
        return n;
    }
}

