/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsIterableFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;

public abstract class DefaultSearchFormatBase
implements NutsIterableFormat {
    private final NutsFetchDisplayOptions displayOptions;
    private final NutsSession session;
    private final NutsPrintStream writer;
    private final NutsContentType format;

    public DefaultSearchFormatBase(NutsSession session, NutsPrintStream writer, NutsContentType format, NutsFetchDisplayOptions options) {
        this.format = format;
        this.writer = writer;
        this.session = session;
        this.displayOptions = new NutsFetchDisplayOptions(session.getWorkspace());
        if (options != null) {
            this.displayOptions.configure(true, options.toCommandLineOptions());
        }
    }

    public NutsContentType getOutputFormat() {
        return this.format;
    }

    public NutsFetchDisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, commandLine);
    }

    public NutsIterableFormat configure(boolean skipUnsupported, String ... args) {
        return (NutsIterableFormat)NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, args, "search-" + this.getOutputFormat().id());
    }

    public NutsWorkspace getWorkspace() {
        return this.session.getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsPrintStream getWriter() {
        return this.writer;
    }
}

