/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.io.File;
import java.io.Writer;
import java.nio.file.Path;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.NutsObjectFormatBase;
import net.thevpc.nuts.runtime.core.format.plain.NutsObjectFormatPlain;

public class DefaultNutsObjectFormat
extends NutsObjectFormatBase {
    private NutsContentType outputFormat;
    private NutsObjectFormat base;

    public DefaultNutsObjectFormat(NutsWorkspace ws) {
        super(ws, "object-format");
    }

    @Override
    public NutsObjectFormat setSession(NutsSession session) {
        super.setSession(session);
        if (this.base != null) {
            this.base.setSession(this.getSession());
        }
        return this;
    }

    @Override
    public NutsObjectFormat setValue(Object value) {
        super.setValue(value);
        if (this.base != null) {
            this.base.setValue(value);
        }
        return this;
    }

    public NutsContentType getOutputFormat() {
        this.checkSession();
        NutsContentType t = this.getSession().getOutputFormat();
        NutsContentType nutsContentType = t = t == null ? NutsContentType.PLAIN : t;
        if (this.getSession().isBot()) {
            switch (t) {
                case PLAIN: {
                    return NutsContentType.PROPS;
                }
                case TREE: 
                case TABLE: {
                    return NutsContentType.JSON;
                }
            }
        }
        return t;
    }

    public NutsObjectFormat getBase() {
        this.checkSession();
        NutsSession session = this.getSession();
        NutsContentType nextOutputFormat = this.getOutputFormat();
        if (this.base == null || this.outputFormat != nextOutputFormat) {
            this.outputFormat = nextOutputFormat;
            this.base = this.createObjectFormat();
            this.base.setValue(this.getValue());
            this.base.setSession(session);
            this.base.configure(true, session.getWorkspace().env().getBootOptions().getOutputFormatOptions());
            this.base.configure(true, session.getOutputFormatOptions());
        }
        return this.base;
    }

    public NutsObjectFormat createObjectFormat() {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        switch (this.getOutputFormat()) {
            case XML: 
            case JSON: {
                return ws.elem().setContentType(this.getOutputFormat());
            }
            case PROPS: {
                return ws.formats().props();
            }
            case TREE: {
                return ws.formats().tree();
            }
            case PLAIN: {
                return new NutsObjectFormatPlain(ws);
            }
            case TABLE: {
                return ws.formats().table();
            }
        }
        throw new NutsException(this.getSession(), NutsMessage.cstyle((String)"unsupported format %s", (Object[])new Object[]{this.getOutputFormat()}));
    }

    @Override
    public NutsSession getSession() {
        return this.base != null ? this.base.getSession() : super.getSession();
    }

    @Override
    public NutsString format() {
        return this.getBase().format();
    }

    @Override
    public void print(NutsPrintStream out) {
        this.getBase().print(out);
    }

    @Override
    public void print(Writer out) {
        this.getBase().print(out);
    }

    @Override
    public void print(Path out) {
        this.getBase().print(out);
    }

    @Override
    public void print(File out) {
        this.getBase().print(out);
    }

    @Override
    public void print() {
        this.getBase().print();
    }

    @Override
    public void print(NutsSessionTerminal terminal) {
        this.getBase().print(terminal);
    }

    @Override
    public void println(Writer w) {
        this.getBase().println(w);
    }

    @Override
    public void println(NutsPrintStream out) {
        this.getBase().println(out);
    }

    @Override
    public void println(Path path) {
        this.getBase().println(path);
    }

    @Override
    public void println() {
        this.getBase().println();
    }

    @Override
    public void println(NutsSessionTerminal terminal) {
        this.getBase().println(terminal);
    }

    @Override
    public void println(File file) {
        this.getBase().println(file);
    }

    @Override
    public boolean configureFirst(NutsCommandLine commandLine) {
        return this.getBase().configureFirst(commandLine);
    }
}

