/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInfoFormat;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.util.CoreCommonUtils;
import net.thevpc.nuts.runtime.core.util.CoreTimeUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;

public class DefaultNutsInfoFormat
extends DefaultFormatBase<NutsInfoFormat>
implements NutsInfoFormat {
    private final Map<String, String> extraProperties = new LinkedHashMap<String, String>();
    private boolean showRepositories = false;
    private boolean fancy = false;
    private List<String> requests = new ArrayList<String>();
    private Predicate<String> filter = NutsPredicates.always();
    private boolean lenient = false;

    public DefaultNutsInfoFormat(NutsWorkspace ws) {
        super(ws, "info");
    }

    public NutsInfoFormat setShowRepositories(boolean enable) {
        this.showRepositories = true;
        return this;
    }

    public boolean isShowRepositories() {
        return this.showRepositories;
    }

    public NutsInfoFormat addProperty(String key, String value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
        return this;
    }

    public NutsInfoFormat addProperties(Map<String, String> customProperties) {
        if (customProperties != null) {
            for (Map.Entry<String, String> e : customProperties.entrySet()) {
                this.addProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public boolean isFancy() {
        return this.fancy;
    }

    public NutsInfoFormat setFancy(boolean fancy) {
        this.fancy = fancy;
        return this;
    }

    @Override
    public void print(NutsPrintStream w) {
        this.checkSession();
        ArrayList<String> args = new ArrayList<String>();
        args.add("--escape-text=false");
        if (this.isFancy()) {
            args.add("--multiline-property=nuts-runtime-path=;");
            args.add("--multiline-property=java-classpath=" + File.pathSeparator);
            args.add("--multiline-property=java-library-path=" + File.pathSeparator);
            args.add("--multiline-property=nuts-boot-runtime-path=:|;");
            args.add("--multiline-property=java.class.path=" + File.pathSeparator);
            args.add("--multiline-property=java-class-path=" + File.pathSeparator);
            args.add("--multiline-property=java.library.path=" + File.pathSeparator);
        }
        Object result = null;
        if (this.requests.isEmpty()) {
            result = this.buildWorkspaceMap(this.isShowRepositories());
        } else if (this.requests.size() == 1) {
            String key;
            Map<String, Object> t = this.buildWorkspaceMap(true);
            Object v = t.get(key = this.requests.get(0));
            if (v != null) {
                result = v;
            } else if (!this.isLenient()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"property not found : %s", (Object[])new Object[]{key}));
            }
        } else {
            Map<String, Object> t = this.buildWorkspaceMap(true);
            LinkedHashMap<String, Object> e = new LinkedHashMap<String, Object>();
            result = e;
            for (String request : this.requests) {
                if (t.containsKey(request)) {
                    e.put(request, t.get(request));
                    continue;
                }
                if (this.isLenient()) continue;
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"property not found : %s", (Object[])new Object[]{request}));
            }
        }
        this.getSession().getWorkspace().formats().object(result).configure(true, args.toArray(new String[0])).print(w);
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "-r": 
            case "--repos": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setShowRepositories(val);
                }
                return true;
            }
            case "--fancy": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setFancy(val);
                }
                return true;
            }
            case "-l": 
            case "--lenient": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setLenient(val);
                }
                return true;
            }
            case "--add": {
                NutsArgument val = cmdLine.nextString(new String[0]).getArgumentValue();
                if (enabled) {
                    this.extraProperties.put(val.getStringKey(), val.getStringValue());
                }
                return true;
            }
            case "-p": 
            case "--path": {
                cmdLine.skip();
                if (enabled) {
                    this.requests.add("nuts-workspace");
                    for (NutsStoreLocation folderType : NutsStoreLocation.values()) {
                        this.requests.add("nuts-workspace-" + folderType.id());
                    }
                    this.requests.add("user-home");
                    this.requests.add("user-dir");
                }
                return true;
            }
            case "-e": 
            case "--env": {
                cmdLine.skip();
                if (enabled) {
                    this.requests.add("platform");
                    this.requests.add("java-version");
                    this.requests.add("java-home");
                    this.requests.add("java-executable");
                    this.requests.add("java-classpath");
                    this.requests.add("os-name");
                    this.requests.add("os-family");
                    this.requests.add("os-dist");
                    this.requests.add("os-arch");
                    this.requests.add("user-name");
                }
                return true;
            }
            case "-c": 
            case "--cmd": {
                cmdLine.skip();
                if (enabled) {
                    this.requests.add("command-line-long");
                    this.requests.add("command-line-short");
                    this.requests.add("inherited");
                    this.requests.add("inherited-nuts-boot-args");
                    this.requests.add("inherited-nuts-args");
                }
                return true;
            }
            case "-g": 
            case "--get": {
                NutsArgument p;
                String r = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.requests.add(r);
                }
                while ((p = cmdLine.peek()) != null && !p.isOption()) {
                    cmdLine.skip();
                    if (!enabled) continue;
                    this.requests.add(p.getString());
                }
                return true;
            }
        }
        return this.getSession().configureFirst(cmdLine);
    }

    private static String key(String prefix, String key) {
        if (NutsUtilStrings.isBlank((CharSequence)prefix)) {
            return key;
        }
        return prefix + "." + key;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> buildWorkspaceMap(boolean deep) {
        String prefix = null;
        FilteredMap props = new FilteredMap(this.filter);
        NutsWorkspace ws = this.getSession().getWorkspace();
        NutsWorkspaceConfigManager rt = ws.config();
        NutsWorkspaceOptions options = ws.env().getBootOptions();
        TreeSet<String> extraKeys = new TreeSet<String>(this.extraProperties.keySet());
        props.put("name", this.stringValue(ws.getName()));
        props.put("nuts-api-version", ws.getApiVersion());
        props.put("nuts-api-id", ws.getApiId());
        props.put("nuts-runtime-id", ws.getRuntimeId());
        URL[] cl = ws.env().getBootClassWorldURLs();
        ArrayList<NutsPath> runtimeClassPath = new ArrayList<NutsPath>();
        if (cl != null) {
            for (URL uRL : cl) {
                if (uRL == null) continue;
                String s = uRL.toString();
                try {
                    s = Paths.get(uRL.toURI()).toFile().getPath();
                }
                catch (URISyntaxException ex) {
                    s = s.replace(":", "\\:");
                }
                runtimeClassPath.add(ws.io().path(s));
            }
        }
        props.put("nuts-runtime-classpath", ws.text().builder().appendJoined((Object)";", runtimeClassPath));
        props.put("nuts-workspace-id", this.stringValue(ws.getUuid()));
        props.put("nuts-store-layout", ws.locations().getStoreLocationLayout());
        props.put("nuts-store-strategy", ws.locations().getStoreLocationStrategy());
        props.put("nuts-repo-store-strategy", ws.locations().getRepositoryStoreLocationStrategy());
        props.put("nuts-global", options.isGlobal());
        props.put("nuts-workspace", ws.io().path(ws.locations().getWorkspaceLocation()));
        for (URL uRL : NutsStoreLocation.values()) {
            props.put("nuts-workspace-" + uRL.id(), ws.io().path(ws.locations().getStoreLocation((NutsStoreLocation)uRL)));
        }
        props.put("nuts-open-mode", options.getOpenMode() == null ? NutsOpenMode.OPEN_OR_CREATE : options.getOpenMode());
        props.put("nuts-secure", ws.security().isSecure());
        props.put("nuts-gui", options.isGui());
        props.put("nuts-inherited", options.isInherited());
        props.put("nuts-recover", options.isRecover());
        props.put("nuts-reset", options.isReset());
        props.put("nuts-debug", options.isDebug());
        props.put("nuts-trace", options.isTrace());
        props.put("nuts-read-only", options.isReadOnly());
        props.put("nuts-skip-companions", options.isSkipCompanions());
        props.put("nuts-skip-welcome", options.isSkipWelcome());
        props.put("nuts-skip-boot", options.isSkipBoot());
        props.put("java-version", ws.version().parser().parse(System.getProperty("java.version")));
        props.put("platform", ws.env().getPlatform());
        props.put("java-home", ws.io().path(System.getProperty("java.home")));
        props.put("java-executable", ws.io().path(NutsJavaSdkUtils.of(ws).resolveJavaCommandByHome(null, this.getSession())));
        props.put("java-classpath", ws.text().builder().appendJoined((Object)";", (Collection)Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(x -> ws.io().path(x)).collect(Collectors.toList())));
        props.put("java-library-path", ws.text().builder().appendJoined((Object)";", (Collection)Arrays.stream(System.getProperty("java.library.path").split(File.pathSeparator)).map(x -> ws.io().path(x)).collect(Collectors.toList())));
        props.put("os-name", ws.env().getOs());
        props.put("os-family", ws.env().getOsFamily());
        if (ws.env().getOsDist() != null) {
            props.put("os-dist", ws.env().getOsDist());
        }
        props.put("os-arch", ws.env().getArchFamily());
        props.put("user-name", this.stringValue(System.getProperty("user.name")));
        props.put("user-home", ws.io().path(System.getProperty("user.home")));
        props.put("user-dir", ws.io().path(System.getProperty("user.dir")));
        props.put("command-line-long", ws.env().getBootOptions().formatter().setCompact(false).getBootCommandLine());
        props.put("command-line-short", ws.env().getBootOptions().formatter().setCompact(true).getBootCommandLine());
        props.put("inherited", ws.env().getBootOptions().isInherited());
        props.put("inherited-nuts-boot-args", ws.commandLine().setCommandlineFamily(NutsCommandlineFamily.BASH).parse(System.getProperty("nuts.boot.args")).format());
        props.put("inherited-nuts-args", ws.commandLine().parse(System.getProperty("nuts.args")).format());
        props.put("creation-started", Instant.ofEpochMilli(ws.env().getCreationStartTimeMillis()));
        props.put("creation-finished", Instant.ofEpochMilli(ws.env().getCreationFinishTimeMillis()));
        props.put("creation-within", CoreTimeUtils.formatPeriodMilli(ws.env().getCreationTimeMillis()).trim());
        props.put("repositories-count", ws.repos().setSession(this.getSession()).getRepositories().length);
        for (String extraKey : extraKeys) {
            props.put(extraKey, this.extraProperties.get(extraKey));
        }
        if (deep) {
            void var13_19;
            LinkedHashMap<String, Map<String, Object>> repositories = new LinkedHashMap<String, Map<String, Object>>();
            props.put("repos", repositories);
            NutsRepository[] nutsRepositoryArray = ws.repos().setSession(this.getSession()).getRepositories();
            int n = nutsRepositoryArray.length;
            boolean bl = false;
            while (var13_19 < n) {
                NutsRepository repository = nutsRepositoryArray[var13_19];
                repositories.put(repository.getName(), this.buildRepoRepoMap(repository, deep, prefix));
                ++var13_19;
            }
        }
        return props.build();
    }

    private Map<String, Object> buildRepoRepoMap(NutsRepository repo, boolean deep, String prefix) {
        NutsWorkspace ws = this.getSession().getWorkspace();
        FilteredMap props = new FilteredMap(this.filter);
        props.put(DefaultNutsInfoFormat.key(prefix, "name"), this.stringValue(repo.getName()));
        props.put(DefaultNutsInfoFormat.key(prefix, "global-name"), repo.config().getGlobalName());
        props.put(DefaultNutsInfoFormat.key(prefix, "uuid"), this.stringValue(repo.getUuid()));
        props.put(DefaultNutsInfoFormat.key(prefix, "type"), ws.text().forStyled(repo.config().getType(), NutsTextStyle.option()));
        props.put(DefaultNutsInfoFormat.key(prefix, "speed"), repo.config().getSpeed());
        props.put(DefaultNutsInfoFormat.key(prefix, "enabled"), repo.config().isEnabled());
        props.put(DefaultNutsInfoFormat.key(prefix, "index-enabled"), repo.config().isIndexEnabled());
        props.put(DefaultNutsInfoFormat.key(prefix, "index-subscribed"), repo.config().setSession(this.getSession()).isIndexSubscribed());
        props.put(DefaultNutsInfoFormat.key(prefix, "location"), repo.config().getLocation(false));
        if (repo.config().getLocation(false) != null) {
            props.put(DefaultNutsInfoFormat.key(prefix, "location-expanded"), repo.config().getLocation(true));
        }
        props.put(DefaultNutsInfoFormat.key(prefix, "deploy-order"), repo.config().getDeployOrder());
        props.put(DefaultNutsInfoFormat.key(prefix, "store-location-strategy"), repo.config().getStoreLocationStrategy());
        props.put(DefaultNutsInfoFormat.key(prefix, "store-location"), ws.io().path(repo.config().getStoreLocation()));
        for (NutsStoreLocation value : NutsStoreLocation.values()) {
            props.put(DefaultNutsInfoFormat.key(prefix, "store-location-" + value.id()), ws.io().path(repo.config().getStoreLocation(value)));
        }
        props.put(DefaultNutsInfoFormat.key(prefix, "supported-mirroring"), repo.config().isSupportedMirroring());
        if (repo.config().isSupportedMirroring()) {
            props.put(DefaultNutsInfoFormat.key(prefix, "mirrors-count"), !repo.config().setSession(this.getSession()).isSupportedMirroring() ? 0 : repo.config().setSession(this.getSession()).getMirrors().length);
        }
        if (deep && repo.config().isSupportedMirroring()) {
            LinkedHashMap<String, Map<String, Object>> mirrors = new LinkedHashMap<String, Map<String, Object>>();
            props.put("mirrors", mirrors);
            for (NutsRepository mirror : repo.config().setSession(this.getSession()).getMirrors()) {
                mirrors.put(mirror.getName(), this.buildRepoRepoMap(mirror, deep, null));
            }
        }
        return props.build();
    }

    private String stringValue(Object s) {
        return this.getSession().getWorkspace().text().builder().append((Object)CoreCommonUtils.stringValue(s)).toString();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsInfoFormat setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    @Override
    public NutsInfoFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    private static class FilteredMap {
        private Predicate<String> filter;
        private LinkedHashMap<String, Object> data = new LinkedHashMap();

        public FilteredMap(Predicate<String> filter) {
            this.filter = filter;
        }

        public boolean accept(String s) {
            return this.filter.test(s);
        }

        public void put(String s, Supplier<Object> v) {
            if (this.filter.test(s)) {
                this.data.put(s, v.get());
            }
        }

        public void putAnyway(String s, Object v) {
            this.data.put(s, v);
        }

        public void put(String s, Object v) {
            if (this.filter.test(s)) {
                this.data.put(s, v);
            }
        }

        public Map<String, Object> build() {
            return this.data;
        }
    }
}

