/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;

public class DefaultNutsIdFormat
extends DefaultFormatBase<NutsIdFormat>
implements NutsIdFormat {
    private boolean omitRepository;
    private boolean omitGroup;
    private boolean omitImportedGroup;
    private boolean omitProperties;
    private boolean highlightImportedGroup;
    private boolean highlightScope;
    private boolean highlightOptional;
    private Set<String> omittedProperties = new HashSet<String>();
    private NutsId id;

    public DefaultNutsIdFormat(NutsWorkspace ws) {
        super(ws, "id-format");
    }

    @Override
    public NutsIdFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    public boolean isOmitRepository() {
        return this.omitRepository;
    }

    public NutsIdFormat setOmitRepository(boolean value) {
        this.omitRepository = value;
        return this;
    }

    public boolean isOmitGroupId() {
        return this.omitGroup;
    }

    public NutsIdFormat setOmitGroupId(boolean value) {
        this.omitGroup = value;
        return this;
    }

    public boolean isOmitImportedGroupId() {
        return this.omitImportedGroup;
    }

    public NutsIdFormat setOmitImportedGroupId(boolean value) {
        this.omitImportedGroup = value;
        return this;
    }

    public boolean isOmitOtherProperties() {
        return this.omitProperties;
    }

    public NutsIdFormat setOmitOtherProperties(boolean value) {
        this.omitProperties = value;
        return this;
    }

    public boolean isOmitFace() {
        return this.isOmitProperty("face");
    }

    public NutsIdFormat setOmitFace(boolean value) {
        return this.setOmitProperty("face", value);
    }

    public boolean isHighlightImportedGroupId() {
        return this.highlightImportedGroup;
    }

    public NutsIdFormat setHighlightImportedGroupId(boolean value) {
        this.highlightImportedGroup = value;
        return this;
    }

    public boolean isHighlightScope() {
        return this.highlightScope;
    }

    public NutsIdFormat setHighlightScope(boolean value) {
        this.highlightScope = value;
        return this;
    }

    public boolean isHighlightOptional() {
        return this.highlightOptional;
    }

    public NutsIdFormat setHighlightOptional(boolean value) {
        this.highlightOptional = value;
        return this;
    }

    public boolean isOmitClassifier() {
        return this.isOmitProperty("classifier");
    }

    public NutsIdFormat setOmitClassifier(boolean value) {
        return this.setOmitProperty("classifier", value);
    }

    public String[] getOmitProperties() {
        return this.omittedProperties.toArray(new String[0]);
    }

    public boolean isOmitProperty(String name) {
        return this.omittedProperties.contains(name);
    }

    public NutsIdFormat setOmitProperty(String name, boolean value) {
        if (value) {
            this.omittedProperties.add(name);
        } else {
            this.omittedProperties.remove(name);
        }
        return this;
    }

    public NutsId getValue() {
        return this.id;
    }

    public NutsIdFormat setValue(NutsId id) {
        this.id = id;
        return this;
    }

    @Override
    public NutsString format() {
        this.checkSession();
        if (this.id == null) {
            return this.isNtf() ? this.getSession().getWorkspace().text().forStyled("<null>", NutsTextStyle.of((NutsTextStyleType)NutsTextStyleType.BOOLEAN)) : this.getSession().getWorkspace().text().forPlain("<null>");
        }
        Map queryMap = this.id.getProperties();
        String scope = (String)queryMap.remove("scope");
        String optional = (String)queryMap.remove("optional");
        String classifier = (String)queryMap.remove("classifier");
        String exclusions = (String)queryMap.remove("exclusions");
        String repo = (String)queryMap.remove("repo");
        NutsIdBuilder idBuilder = this.id.builder();
        if (this.isOmitOtherProperties()) {
            idBuilder.setProperties(new LinkedHashMap());
        }
        if (this.isOmitFace()) {
            idBuilder.setProperty("face", null);
        }
        this.id = idBuilder.build();
        NutsTextBuilder sb = this.getSession().getWorkspace().text().builder();
        if (!this.isOmitGroupId() && !NutsUtilStrings.isBlank((CharSequence)this.id.getGroupId())) {
            boolean importedGroup2 = "net.thevpc.nuts".equals(this.id.getGroupId());
            boolean importedGroup = this.getSession().getWorkspace().imports().getAll().contains(this.id.getGroupId());
            if (!importedGroup || !this.isOmitImportedGroupId()) {
                if (importedGroup || importedGroup2) {
                    sb.append((Object)this.id.getGroupId(), NutsTextStyle.pale());
                } else {
                    sb.append((Object)this.id.getGroupId());
                }
                sb.append((Object)":", NutsTextStyle.separator());
            }
        }
        sb.append((Object)this.id.getArtifactId(), NutsTextStyle.primary1());
        if (!NutsUtilStrings.isBlank((CharSequence)this.id.getVersion().getValue())) {
            sb.append((Object)"#", NutsTextStyle.separator());
            sb.append((Object)this.id.getVersion());
        }
        boolean firstQ = true;
        if (!NutsUtilStrings.isBlank((CharSequence)classifier)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"classifier", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)classifier);
        }
        if (!NutsDependencyScopes.isDefaultScope(scope)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"scope", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)scope);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)optional) && !"false".equalsIgnoreCase(optional)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"optional", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)optional);
        }
        if (!this.isOmitRepository() && !NutsUtilStrings.isBlank((CharSequence)this.id.getRepository())) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"repo", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this.id.getRepository(), NutsTextStyle.pale());
        }
        if (!NutsUtilStrings.isBlank((CharSequence)exclusions)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"exclusions", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)exclusions, NutsTextStyle.warn());
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.id.getPropertiesQuery())) {
            TreeSet otherKeys = new TreeSet(queryMap.keySet());
            for (String k : otherKeys) {
                String v = (String)queryMap.get(k);
                if (v == null) continue;
                if (firstQ) {
                    sb.append((Object)"?", NutsTextStyle.separator());
                    firstQ = false;
                } else {
                    sb.append((Object)"&", NutsTextStyle.separator());
                }
                sb.append((Object)k, NutsTextStyle.pale());
                sb.append((Object)"=", NutsTextStyle.separator());
                sb.append((Object)v);
            }
        }
        if (this.isNtf()) {
            return sb.immutable();
        }
        return this.getSession().getWorkspace().text().forPlain(sb.filteredText());
    }

    @Override
    public void print(NutsPrintStream out) {
        out.print(this.format());
    }

    @Override
    public String toString() {
        return "NutsIdFormat{omitRepository=" + this.omitRepository + ", omitGroup=" + this.omitGroup + ", omitImportedGroup=" + this.omitImportedGroup + ", omitProperties=" + this.omitProperties + ", highlightImportedGroup=" + this.highlightImportedGroup + ", highlightScope=" + this.highlightScope + ", highlightOptional=" + this.highlightOptional + ", omittedProperties=" + this.omittedProperties + ", id=" + this.id + '}';
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "--omit-env": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitOtherProperties(val);
                }
                return true;
            }
            case "--omit-face": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitFace(val);
                }
                return true;
            }
            case "--omit-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitGroupId(val);
                }
                return true;
            }
            case "--omit-imported-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitImportedGroupId(val);
                }
                return true;
            }
            case "--omit-repo": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitRepository(val);
                }
                return true;
            }
            case "--highlight-imported-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setHighlightImportedGroupId(val);
                }
                return true;
            }
            case "--highlight-optional": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setHighlightOptional(val);
                }
                return true;
            }
            case "--highlight-scope": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setHighlightScope(val);
                }
                return true;
            }
        }
        return false;
    }
}

