/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format;

import java.io.InputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecCommandFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;

public class DefaultNutsExecCommandFormat
extends DefaultFormatBase<NutsExecCommandFormat>
implements NutsExecCommandFormat {
    private Predicate<NutsExecCommandFormat.ArgEntry> argumentFilter;
    private Function<NutsExecCommandFormat.ArgEntry, String> argumentReplacer;
    private Predicate<NutsExecCommandFormat.EnvEntry> envFilter;
    private Function<NutsExecCommandFormat.EnvEntry, String> envReplacer;
    private boolean redirectInput = true;
    private boolean redirectOutput = true;
    private boolean redirectError = true;
    private NutsExecCommand value;

    public DefaultNutsExecCommandFormat(NutsWorkspace ws) {
        super(ws, "exec-command");
    }

    public boolean isRedirectInput() {
        return this.redirectInput;
    }

    public NutsExecCommandFormat setRedirectInput(boolean redirectInput) {
        this.redirectInput = redirectInput;
        return this;
    }

    public boolean isRedirectOutput() {
        return this.redirectOutput;
    }

    public NutsExecCommandFormat setRedirectOutput(boolean redirectOutput) {
        this.redirectOutput = redirectOutput;
        return this;
    }

    public boolean isRedirectError() {
        return this.redirectError;
    }

    public NutsExecCommandFormat setRedirectError(boolean redirectError) {
        this.redirectError = redirectError;
        return this;
    }

    public NutsExecCommand getValue() {
        return this.value;
    }

    public NutsExecCommandFormat setValue(NutsExecCommand value) {
        this.value = value;
        return this;
    }

    public Predicate<NutsExecCommandFormat.ArgEntry> getArgumentFilter() {
        return this.argumentFilter;
    }

    public NutsExecCommandFormat setArgumentFilter(Predicate<NutsExecCommandFormat.ArgEntry> filter) {
        this.argumentFilter = filter;
        return this;
    }

    public Function<NutsExecCommandFormat.ArgEntry, String> getArgumentReplacer() {
        return this.argumentReplacer;
    }

    public DefaultNutsExecCommandFormat setArgumentReplacer(Function<NutsExecCommandFormat.ArgEntry, String> argumentReplacer) {
        this.argumentReplacer = argumentReplacer;
        return this;
    }

    public Predicate<NutsExecCommandFormat.EnvEntry> getEnvFilter() {
        return this.envFilter;
    }

    public NutsExecCommandFormat setEnvFilter(Predicate<NutsExecCommandFormat.EnvEntry> filter) {
        this.envFilter = filter;
        return this;
    }

    public Function<NutsExecCommandFormat.EnvEntry, String> getEnvReplacer() {
        return this.envReplacer;
    }

    public NutsExecCommandFormat setEnvReplacer(Function<NutsExecCommandFormat.EnvEntry, String> envReplacer) {
        this.envReplacer = envReplacer;
        return this;
    }

    @Override
    public void print(NutsPrintStream out) {
        StringBuilder sb = new StringBuilder();
        NutsExecCommand ec = this.getValue();
        NutsPrintStream _out = ec.getOut();
        NutsPrintStream err = ec.getErr();
        InputStream in = ec.getIn();
        Map env = ec.getEnv();
        String[] command = ec.getCommand();
        if (env != null) {
            for (Map.Entry e : env.entrySet()) {
                String k = (String)e.getKey();
                String v = (String)e.getValue();
                DefaultEnvEntry ee = new DefaultEnvEntry(k, v);
                if (this.getEnvFilter() != null && !this.getEnvFilter().test(ee)) continue;
                if (this.getEnvReplacer() != null) {
                    String v2 = this.getEnvReplacer().apply(ee);
                    if (v2 == null) continue;
                    v = v2;
                }
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(DefaultNutsExecCommandFormat.enforceDoubleQuote(k)).append("=").append(DefaultNutsExecCommandFormat.enforceDoubleQuote(v));
            }
        }
        for (int i = 0; i < command.length; ++i) {
            String s = command[i];
            if (s == null) {
                s = "";
            }
            DefaultArgEntry aa = new DefaultArgEntry(i, s);
            if (this.getArgumentFilter() != null && !this.getArgumentFilter().test(aa)) continue;
            if (this.getArgumentReplacer() != null) {
                String y = this.getArgumentReplacer().apply(aa);
                if (y == null) continue;
                s = y;
            }
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(DefaultNutsExecCommandFormat.enforceDoubleQuote(s));
        }
        if (this.isRedirectError()) {
            if (_out != null) {
                if (this.isRedirectOutput()) {
                    sb.append(" > ").append("{stream}");
                }
                if (this.isRedirectError()) {
                    sb.append(" 2>&1");
                }
            }
            if (in != null && this.isRedirectInput()) {
                sb.append(" < ").append("{stream}");
            }
        } else {
            if (_out != null && this.isRedirectOutput()) {
                sb.append(" > ").append("{stream}");
            }
            if (err != null && this.isRedirectError()) {
                sb.append(" 2> ").append("{stream}");
            }
            if (in != null && this.isRedirectInput()) {
                sb.append(" < ").append("{stream}");
            }
        }
        out.print(sb.toString());
    }

    private static String enforceDoubleQuote(String s) {
        if (s.isEmpty() || s.contains(" ") || s.contains("\"")) {
            s = "\"" + s.replace("\"", "\\\"") + "\"";
        }
        return s;
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        return false;
    }

    private static class DefaultArgEntry
    implements NutsExecCommandFormat.ArgEntry {
        private int index;
        private String value;

        public DefaultArgEntry(int index, String value) {
            this.index = index;
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class DefaultEnvEntry
    implements NutsExecCommandFormat.EnvEntry {
        private String name;
        private String value;

        public DefaultEnvEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

