/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.version;

import java.util.Objects;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.bundles.common.JavascriptHelper;
import net.thevpc.nuts.runtime.core.filters.version.AbstractVersionFilter;
import net.thevpc.nuts.runtime.core.filters.version.JsNutsVersionFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.core.util.Simplifiable;

public class NutsVersionJavascriptFilter
extends AbstractVersionFilter
implements NutsVersionFilter,
Simplifiable<NutsVersionFilter>,
JsNutsVersionFilter {
    private String code;
    private JavascriptHelper engineHelper;

    public static NutsVersionFilter valueOf(String value, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            return (NutsVersionFilter)session.getWorkspace().version().filter().always();
        }
        return new NutsVersionJavascriptFilter(session, value);
    }

    public NutsVersionJavascriptFilter(NutsSession ws, String code) {
        super(ws, NutsFilterOp.CUSTOM);
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public boolean acceptVersion(NutsVersion d, NutsSession session) {
        JavascriptHelper engineHelper = new JavascriptHelper(this.code, "var dependency=x; var id=x.getId(); var version=id.getVersion();", null, null, session);
        return engineHelper.accept(d);
    }

    @Override
    public NutsVersionFilter simplify() {
        return this;
    }

    @Override
    public String toJsNutsVersionFilterExpr() {
        return "util.matches(version,'" + CoreStringUtils.escapeQuoteStrings(this.code) + "')";
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.code);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsVersionJavascriptFilter other = (NutsVersionJavascriptFilter)obj;
        return Objects.equals(this.code, other.code);
    }

    public String toString() {
        return "NutsVersionJavascriptFilter{" + this.code + '}';
    }
}

