/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.core.filters.id.NutsScriptAwareIdFilter;
import net.thevpc.nuts.runtime.core.filters.version.AbstractVersionFilter;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.Simplifiable;

public class NutsVersionFilterNone
extends AbstractVersionFilter
implements NutsVersionFilter,
Simplifiable<NutsVersionFilter>,
NutsScriptAwareIdFilter {
    private NutsVersionFilter[] all;

    public NutsVersionFilterNone(NutsSession ws, NutsVersionFilter ... all) {
        super(ws, NutsFilterOp.NOT);
        ArrayList<NutsVersionFilter> valid = new ArrayList<NutsVersionFilter>();
        if (all != null) {
            for (NutsVersionFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NutsVersionFilter[0]);
    }

    public boolean acceptVersion(NutsVersion id, NutsSession session) {
        if (this.all.length == 0) {
            return true;
        }
        for (NutsVersionFilter filter : this.all) {
            if (!filter.acceptVersion(id, session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsVersionFilter simplify() {
        return CoreNutsUtils.simplifyFilterNone(this.getWorkspace(), NutsVersionFilter.class, this, (NutsFilter[])this.all);
    }

    @Override
    public String toJsNutsIdFilterExpr() {
        StringBuilder sb = new StringBuilder();
        if (this.all.length == 0) {
            return "true";
        }
        if (this.all.length > 1) {
            sb.append("(");
        }
        for (NutsVersionFilter id : this.all) {
            String expr;
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            if (id instanceof NutsScriptAwareIdFilter) {
                NutsScriptAwareIdFilter b = (NutsScriptAwareIdFilter)id;
                expr = b.toJsNutsIdFilterExpr();
                if (NutsUtilStrings.isBlank((CharSequence)expr)) {
                    return null;
                }
            } else {
                return null;
            }
            sb.append("(").append(expr).append("')");
        }
        if (this.all.length > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsVersionFilterNone other = (NutsVersionFilterNone)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    public String toString() {
        return "Not(" + String.join((CharSequence)" Or ", Arrays.asList(this.all).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList())) + ")";
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.all;
    }
}

