/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.repository.AbstractRepositoryFilter;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;

public class NutsRepositoryFilterNone
extends AbstractRepositoryFilter {
    private NutsRepositoryFilter[] all;

    public NutsRepositoryFilterNone(NutsSession ws, NutsRepositoryFilter ... all) {
        super(ws, NutsFilterOp.NOT);
        ArrayList<NutsRepositoryFilter> valid = new ArrayList<NutsRepositoryFilter>();
        if (all != null) {
            for (NutsRepositoryFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NutsRepositoryFilter[0]);
    }

    public boolean acceptRepository(NutsRepository id) {
        if (this.all.length == 0) {
            return true;
        }
        for (NutsRepositoryFilter filter : this.all) {
            if (!filter.acceptRepository(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsRepositoryFilter simplify() {
        return CoreNutsUtils.simplifyFilterNone(this.getWorkspace(), NutsRepositoryFilter.class, this, (NutsFilter[])this.all);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsRepositoryFilterNone that = (NutsRepositoryFilterNone)o;
        return Arrays.equals(this.all, that.all);
    }

    public int hashCode() {
        return Arrays.hashCode(this.all);
    }

    public String toString() {
        return "Not(" + String.join((CharSequence)" Or ", Arrays.asList(this.all).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList())) + ")";
    }

    @Override
    public NutsFilterOp getFilterOp() {
        return NutsFilterOp.NOT;
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.all;
    }
}

