/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;

public class NutsExecExtensionFilter
extends AbstractDescriptorFilter {
    private NutsId apiId;

    public NutsExecExtensionFilter(NutsSession ws, NutsId apiId) {
        super(ws, NutsFilterOp.CUSTOM);
        this.apiId = apiId;
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        if (!NutsUtilStrings.parseBoolean((String)((String)other.getProperties().get("nuts-extension")), (Boolean)false, (Boolean)false).booleanValue()) {
            return false;
        }
        for (NutsDependency dependency : other.getDependencies()) {
            if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
            if (this.apiId == null) {
                return true;
            }
            return this.apiId.getVersion().equals(dependency.toId().getVersion());
        }
        return false;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "extension";
        }
        return "extension(" + this.apiId.getVersion() + ")";
    }
}

