/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;

public class NutsExecCompanionFilter
extends AbstractDescriptorFilter {
    private NutsId apiId;
    private Set<String> companions;

    public NutsExecCompanionFilter(NutsSession ws, NutsId apiId, String[] shortIds) {
        super(ws, NutsFilterOp.CUSTOM);
        this.apiId = apiId;
        this.companions = new HashSet<String>(Arrays.asList(shortIds));
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        if (this.companions.contains(other.getId().getShortName())) {
            for (NutsDependency dependency : other.getDependencies()) {
                if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                if (this.apiId == null) {
                    return true;
                }
                return this.apiId.getVersion().equals(dependency.toId().getVersion());
            }
            return false;
        }
        return false;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "companion";
        }
        return "companion(" + this.apiId.getVersion() + ")";
    }
}

