/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.id;

import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;

public class BootAPINutsDescriptorFilter
extends AbstractDescriptorFilter {
    private final NutsVersion bootApiVersion;

    public BootAPINutsDescriptorFilter(NutsSession ws, NutsVersion bootApiVersion) {
        super(ws, NutsFilterOp.CUSTOM);
        this.bootApiVersion = bootApiVersion;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        for (NutsDependency dependency : descriptor.getDependencies()) {
            if (!dependency.getSimpleName().equals("net.thevpc.nuts:nuts")) continue;
            return this.bootApiVersion.matches(dependency.getVersion().toString());
        }
        return false;
    }

    public String toString() {
        return "BootAPI(" + this.bootApiVersion + ')';
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }
}

