/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.descriptor.JsNutsDescriptorFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NutsDescriptorFilterPackaging
extends AbstractDescriptorFilter
implements JsNutsDescriptorFilter {
    private final String packaging;

    public NutsDescriptorFilterPackaging(NutsSession ws, String packaging) {
        super(ws, NutsFilterOp.CUSTOM);
        this.packaging = packaging;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesPackaging(this.packaging, descriptor, session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsUtilStrings.isBlank((CharSequence)this.packaging)) {
            return null;
        }
        return this;
    }

    @Override
    public String toJsNutsDescriptorFilterExpr() {
        return "descriptor.matchesPackaging('" + CoreStringUtils.escapeQuoteStrings(this.packaging) + "')";
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.packaging);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterPackaging other = (NutsDescriptorFilterPackaging)obj;
        return Objects.equals(this.packaging, other.packaging);
    }

    public String toString() {
        return "Packaging{" + this.packaging + '}';
    }
}

