/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.descriptor.JsNutsDescriptorFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NutsDescriptorFilterOsdist
extends AbstractDescriptorFilter
implements JsNutsDescriptorFilter {
    private final String osdist;

    public NutsDescriptorFilterOsdist(NutsSession ws, String osdist) {
        super(ws, NutsFilterOp.CUSTOM);
        this.osdist = osdist;
    }

    public String getOsdist() {
        return this.osdist;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesOsdist(this.osdist, descriptor, session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsUtilStrings.isBlank((CharSequence)this.osdist)) {
            return null;
        }
        return this;
    }

    @Override
    public String toJsNutsDescriptorFilterExpr() {
        return "descriptor.matchesOsdist('" + CoreStringUtils.escapeQuoteStrings(this.osdist) + "')";
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.osdist);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterOsdist other = (NutsDescriptorFilterOsdist)obj;
        return Objects.equals(this.osdist, other.osdist);
    }

    public String toString() {
        return "Osdist{" + this.osdist + '}';
    }
}

