/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.descriptor.JsNutsDescriptorFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NutsDescriptorFilterOs
extends AbstractDescriptorFilter
implements JsNutsDescriptorFilter {
    private final String os;

    public NutsDescriptorFilterOs(NutsSession ws, String os) {
        super(ws, NutsFilterOp.CUSTOM);
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesOs(this.os, descriptor, session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsUtilStrings.isBlank((CharSequence)this.os)) {
            return null;
        }
        return this;
    }

    @Override
    public String toJsNutsDescriptorFilterExpr() {
        return "descriptor.matchesOs('" + CoreStringUtils.escapeQuoteStrings(this.os) + "')";
    }

    public String toString() {
        return "Os{" + this.os + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.os);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterOs other = (NutsDescriptorFilterOs)obj;
        return Objects.equals(this.os, other.os);
    }
}

