/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.core.filters.descriptor.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.core.filters.descriptor.JsNutsDescriptorFilter;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class NutsDescriptorFilterArch
extends AbstractDescriptorFilter
implements JsNutsDescriptorFilter {
    private final String arch;

    public NutsDescriptorFilterArch(NutsSession ws, String packaging) {
        super(ws, NutsFilterOp.CUSTOM);
        this.arch = packaging;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesArch(this.arch, descriptor, session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsUtilStrings.isBlank((CharSequence)this.arch)) {
            return null;
        }
        return this;
    }

    @Override
    public String toJsNutsDescriptorFilterExpr() {
        return "descriptor.matchesArch('" + CoreStringUtils.escapeQuoteStrings(this.arch) + "')";
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.arch);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterArch other = (NutsDescriptorFilterArch)obj;
        return Objects.equals(this.arch, other.arch);
    }

    public String toString() {
        return "Arch{" + this.arch + '}';
    }
}

