/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.dependency.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.core.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;

public class NutsDependencyScopeFilter
extends AbstractDependencyFilter {
    private EnumSet<NutsDependencyScope> scope = EnumSet.noneOf(NutsDependencyScope.class);

    public NutsDependencyScopeFilter(NutsSession ws) {
        super(ws, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyScopeFilter(NutsSession ws, Collection<NutsDependencyScope> scope) {
        super(ws, NutsFilterOp.CUSTOM);
        this.scope = EnumSet.copyOf(scope);
    }

    public NutsDependencyScopeFilter add(Collection<NutsDependencyScope> scope) {
        EnumSet<NutsDependencyScope> s2 = EnumSet.copyOf(this.scope);
        s2.addAll(scope);
        return new NutsDependencyScopeFilter(this.getSession(), s2);
    }

    public NutsDependencyScopeFilter addScopePatterns(Collection<NutsDependencyScopePattern> scope) {
        EnumSet<NutsDependencyScope> s2 = EnumSet.copyOf(this.scope);
        for (NutsDependencyScopePattern ss : scope) {
            s2.addAll(NutsDependencyScopes.expand(ss));
        }
        return new NutsDependencyScopeFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        return this.scope.isEmpty() || this.scope.contains(NutsDependencyScopes.parseDependencyScope(dependency.getScope()));
    }

    public String toString() {
        return this.scope.isEmpty() ? "true" : "scope in (" + this.scope.stream().map(CoreEnumUtils::getEnumString).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.scope.isEmpty() ? (NutsDependencyFilter)this.getWorkspace().filters().dependency().always() : this;
    }
}

