/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters.dependency;

import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.filters.dependency.AbstractDependencyFilter;

public class NutsDependencyOptionFilter
extends AbstractDependencyFilter {
    private final Boolean optional;

    public NutsDependencyOptionFilter(NutsSession ws, Boolean optional) {
        super(ws, NutsFilterOp.CUSTOM);
        this.optional = optional;
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        if (this.optional == null) {
            return false;
        }
        return this.optional.booleanValue() == dependency.isOptional();
    }

    @Override
    public NutsDependencyFilter simplify() {
        if (this.optional == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        if (this.optional == null) {
            return "any optional";
        }
        return this.optional != false ? "optional" : "not(optional)";
    }
}

