/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.bundles.string.GlobUtils;
import net.thevpc.nuts.runtime.core.filters.id.AbstractIdFilter;

public class NutsPatternIdFilter
extends AbstractIdFilter
implements NutsIdFilter {
    private NutsId id;
    private Pattern g;
    private Pattern n;
    private boolean wildcard;
    private NutsVersionFilter v;
    private Map<String, String> qm;
    private List<Predicate<Map<String, String>>> q = new ArrayList<Predicate<Map<String, String>>>();

    public NutsPatternIdFilter(NutsSession ws, NutsId id) {
        super(ws, NutsFilterOp.CUSTOM);
        this.id = id;
        this.wildcard = NutsPatternIdFilter.containsWildcad(id.toString());
        this.g = GlobUtils.ofExact(id.getGroupId());
        this.n = GlobUtils.ofExact(id.getArtifactId());
        this.v = id.getVersion().filter();
        this.qm = id.getProperties();
        for (Map.Entry entry : id.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!key.contains("*")) {
                this.q.add((Predicate<Map<String, String>>)((Object)new PredicateStaticKey(key, val)));
                continue;
            }
            if (!val.contains("*")) {
                // empty if block
            }
            this.q.add((Predicate<Map<String, String>>)((Object)new PredicateWildKey(key, val)));
        }
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public NutsId getId() {
        return this.id;
    }

    public boolean acceptId(NutsId other, NutsSession session) {
        if (!this.g.matcher(other.getGroupId()).matches()) {
            return false;
        }
        if (!this.n.matcher(other.getArtifactId()).matches()) {
            return false;
        }
        if (!this.v.acceptVersion(other.getVersion(), session)) {
            return false;
        }
        Map oqm = null;
        for (Predicate<Map<String, String>> pp : this.q) {
            if (oqm == null) {
                oqm = other.getProperties();
            }
            if (pp.test(oqm)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsPatternIdFilter other = (NutsPatternIdFilter)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return this.id.toString();
    }

    public static boolean containsWildcad(String id) {
        return id.indexOf(42) >= 0;
    }

    @Override
    public NutsIdFilter simplify() {
        return this;
    }

    private static class PredicateWildKey
    extends NutsPredicates.BasePredicate<Map<String, String>> {
        private Pattern keyPattern;
        private Pattern valPattern;

        public PredicateWildKey(String key, String val) {
            this.keyPattern = GlobUtils.ofExact(key);
            this.valPattern = GlobUtils.ofExact(val);
        }

        public boolean test(Map<String, String> x) {
            for (Map.Entry<String, String> entry : x.entrySet()) {
                if (!this.keyPattern.matcher(entry.getKey()).matches()) continue;
                String sv = NutsUtilStrings.trim((String)entry.getValue());
                return this.valPattern.matcher(sv).matches();
            }
            return false;
        }
    }

    private static class PredicateStaticKey
    extends NutsPredicates.BasePredicate<Map<String, String>> {
        private final String key;
        private final String val;
        private Pattern valPattern;

        public PredicateStaticKey(String key, String val) {
            this.key = key;
            this.val = val;
            this.valPattern = GlobUtils.ofExact(val);
        }

        public boolean test(Map<String, String> x) {
            String sv = NutsUtilStrings.trim((String)x.get(this.key));
            return this.valPattern.matcher(sv).matches();
        }
    }
}

