/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.filters;

import net.thevpc.nuts.NutsDependencyFilterManager;
import net.thevpc.nuts.NutsDescriptorFilterManager;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterManager;
import net.thevpc.nuts.NutsIdFilterManager;
import net.thevpc.nuts.NutsInstallStatusFilterManager;
import net.thevpc.nuts.NutsRepositoryFilterManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersionFilterManager;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsFilterModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsFilterManager
implements NutsFilterManager {
    public DefaultNutsFilterModel model;
    public NutsSession session;

    public DefaultNutsFilterManager(DefaultNutsFilterModel model) {
        this.model = model;
    }

    public DefaultNutsFilterModel getModel() {
        return this.model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsFilterManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public <T extends NutsFilter> T nonnull(Class<T> type, NutsFilter filter) {
        this.checkSession();
        return this.model.nonnull(type, filter, this.session);
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public <T extends NutsFilter> T always(Class<T> type) {
        this.checkSession();
        return this.model.always(type, this.session);
    }

    public <T extends NutsFilter> T never(Class<T> type) {
        this.checkSession();
        return this.model.never(type, this.session);
    }

    public <T extends NutsFilter> T all(Class<T> type, NutsFilter ... others) {
        this.checkSession();
        return this.model.all(type, others, this.session);
    }

    public <T extends NutsFilter> T all(NutsFilter ... others) {
        this.checkSession();
        return this.model.all(others, this.session);
    }

    public <T extends NutsFilter> T any(Class<T> type, NutsFilter ... others) {
        this.checkSession();
        return this.model.any(type, others, this.session);
    }

    public <T extends NutsFilter> T not(NutsFilter other) {
        this.checkSession();
        return this.model.not(other, this.session);
    }

    public <T extends NutsFilter> T not(Class<T> type, NutsFilter other) {
        this.checkSession();
        return this.model.not(type, other, this.session);
    }

    public <T extends NutsFilter> T any(NutsFilter ... others) {
        this.checkSession();
        return this.model.any(others, this.session);
    }

    public <T extends NutsFilter> T none(Class<T> type, NutsFilter ... others) {
        this.checkSession();
        return this.model.none(type, others, this.session);
    }

    public <T extends NutsFilter> T none(NutsFilter ... others) {
        this.checkSession();
        return this.model.none(others, this.session);
    }

    public <T extends NutsFilter> T to(Class<T> toFilterInterface, NutsFilter filter) {
        this.checkSession();
        return this.model.to(toFilterInterface, filter, this.session);
    }

    public <T extends NutsFilter> T as(Class<T> toFilterInterface, NutsFilter filter) {
        this.checkSession();
        return this.model.as(toFilterInterface, filter, this.session);
    }

    public Class<? extends NutsFilter> detectType(NutsFilter nutsFilter) {
        this.checkSession();
        return this.model.detectType(nutsFilter, this.session);
    }

    public NutsIdFilterManager id() {
        return this.model.id().setSession(this.session);
    }

    public NutsDependencyFilterManager dependency() {
        return this.model.dependency().setSession(this.session);
    }

    public NutsRepositoryFilterManager repository() {
        return this.model.repository().setSession(this.session);
    }

    public NutsVersionFilterManager version() {
        return this.model.version().setSession(this.session);
    }

    public NutsDescriptorFilterManager descriptor() {
        return this.model.descriptor().setSession(this.session);
    }

    public NutsInstallStatusFilterManager installStatus() {
        return this.model.installStatus().setSession(this.session);
    }
}

