/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsCommandLineManager;
import net.thevpc.nuts.NutsConstants;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.runtime.core.app.DefaultNonOption;

public class PermissionNonOption
extends DefaultNonOption {
    private final boolean existing;
    private final String user;

    public PermissionNonOption(String name, String user, boolean existing) {
        super(name);
        this.existing = existing;
        this.user = user;
    }

    @Override
    public List<NutsArgumentCandidate> getCandidates(NutsCommandAutoComplete context) {
        ArrayList<NutsArgumentCandidate> all = new ArrayList<NutsArgumentCandidate>();
        NutsCommandLineManager c = context.getWorkspace().commandLine();
        for (String r : NutsConstants.Permissions.ALL) {
            all.add(c.createCandidate(r).build());
        }
        Iterator i = all.iterator();
        NutsRepository repository = (NutsRepository)context.get(NutsRepository.class);
        NutsUser info = repository != null ? repository.security().setSession(context.getSession()).getEffectiveUser(this.user) : context.getWorkspace().security().setSession(context.getSession()).findUser(this.user);
        HashSet rights = new HashSet(info == null ? Collections.emptyList() : Arrays.asList(info.getPermissions()));
        while (i.hasNext()) {
            NutsArgumentCandidate right = (NutsArgumentCandidate)i.next();
            if (this.existing) {
                if (rights.contains(right.getValue())) continue;
                i.remove();
                continue;
            }
            if (!rights.contains(right.getValue())) continue;
            i.remove();
        }
        return all;
    }
}

