/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.nio.file.Paths;
import java.util.Map;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsWorkspaceLocationModel {
    private NutsWorkspace ws;
    private String workspaceLocation;
    private NutsWorkspaceInitInformation info;

    public DefaultNutsWorkspaceLocationModel(NutsWorkspace ws, NutsWorkspaceInitInformation info, String workspaceLocation) {
        this.ws = ws;
        this.info = info;
        this.workspaceLocation = workspaceLocation;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    private DefaultNutsWorkspaceConfigModel cfg() {
        return ((DefaultNutsWorkspace)this.ws).getConfigModel();
    }

    public void setHomeLocation(NutsOsFamily layout, NutsStoreLocation folder, String location, NutsSession session) {
        if (folder == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid store root folder null", (Object[])new Object[0]));
        }
        this.cfg().onPreUpdateConfig("home-location", session);
        this.cfg().getStoreModelBoot().setHomeLocations(new NutsHomeLocationsMap(this.cfg().getStoreModelBoot().getHomeLocations()).set(layout, folder, location).toMapOrNull());
        this.cfg().onPostUpdateConfig("home-location", session);
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public String getHomeLocation(NutsStoreLocation folderType, NutsSession session) {
        return this.cfg().current().getHomeLocation(folderType);
    }

    public String getStoreLocation(NutsStoreLocation folderType, NutsSession session) {
        try {
            return this.cfg().current().getStoreLocation(folderType);
        }
        catch (IllegalStateException stillInitializing) {
            return this.info.getStoreLocation(folderType);
        }
    }

    public void setStoreLocation(NutsStoreLocation folderType, String location, NutsSession session) {
        if (folderType == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid store root folder null", (Object[])new Object[0]));
        }
        this.cfg().onPreUpdateConfig("store-location", session);
        this.cfg().getStoreModelBoot().setStoreLocations(new NutsStoreLocationsMap(this.cfg().getStoreModelBoot().getStoreLocations()).set(folderType, location).toMapOrNull());
        this.cfg().onPostUpdateConfig("store-location", session);
    }

    public void setStoreLocationStrategy(NutsStoreLocationStrategy strategy, NutsSession session) {
        if (strategy == null) {
            strategy = NutsStoreLocationStrategy.EXPLODED;
        }
        this.cfg().onPreUpdateConfig("store-location-strategy", session);
        this.cfg().getStoreModelBoot().setStoreLocationStrategy(strategy);
        this.cfg().onPostUpdateConfig("store-location-strategy", session);
    }

    public void setStoreLocationLayout(NutsOsFamily layout, NutsSession session) {
        this.cfg().onPreUpdateConfig("store-location-layout", session);
        this.cfg().getStoreModelBoot().setStoreLocationLayout(layout);
        this.cfg().onPostUpdateConfig("store-location-layout", session);
    }

    public String getStoreLocation(NutsStoreLocation folderType, String repositoryIdOrName, NutsSession session) {
        if (repositoryIdOrName == null) {
            return this.getStoreLocation(folderType, session);
        }
        NutsRepository repositoryById = this.ws.repos().setSession(session).getRepository(repositoryIdOrName);
        NutsRepositorySPI nutsRepositorySPI = NutsWorkspaceUtils.of(session).repoSPI(repositoryById);
        return nutsRepositorySPI.config().getStoreLocation(folderType);
    }

    public String getStoreLocation(NutsId id, NutsStoreLocation folderType, String repositoryIdOrName, NutsSession session) {
        if (repositoryIdOrName == null) {
            return this.getStoreLocation(id, folderType, session);
        }
        String storeLocation = this.getStoreLocation(folderType, repositoryIdOrName, session);
        return Paths.get(storeLocation, new String[0]).resolve("id").resolve(this.getDefaultIdBasedir(id, session)).toString();
    }

    public String getStoreLocation(NutsId id, NutsStoreLocation folderType, NutsSession session) {
        String storeLocation = this.getStoreLocation(folderType, session);
        if (storeLocation == null) {
            return null;
        }
        return Paths.get(storeLocation, new String[0]).resolve("id").resolve(this.getDefaultIdBasedir(id, session)).toString();
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy(NutsSession session) {
        return this.cfg().current().getStoreLocationStrategy();
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy(NutsSession session) {
        return this.cfg().current().getRepositoryStoreLocationStrategy();
    }

    public NutsOsFamily getStoreLocationLayout(NutsSession session) {
        return this.cfg().current().getStoreLocationLayout();
    }

    public Map<String, String> getStoreLocations(NutsSession session) {
        return this.cfg().current().getStoreLocations();
    }

    public Map<String, String> getHomeLocations(NutsSession session) {
        return this.cfg().current().getHomeLocations();
    }

    public String getHomeLocation(NutsOsFamily layout, NutsStoreLocation location, NutsSession session) {
        return this.cfg().current().getHomeLocation(layout, location);
    }

    public String getDefaultIdBasedir(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkSimpleNameNutsId(id);
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String plainIdPath = groupId.replace('.', '/') + "/" + artifactId;
        if (id.getVersion().isBlank()) {
            return plainIdPath;
        }
        String version = id.getVersion().getValue();
        String x = plainIdPath + "/" + version;
        return x;
    }

    public String getDefaultIdFilename(NutsId id, NutsSession session) {
        String c;
        String classifier = "";
        String ext = this.getDefaultIdExtension(id, session);
        if (!(ext.equals(".nuts") || ext.equals(".pom") || NutsUtilStrings.isBlank((CharSequence)(c = id.getClassifier())))) {
            classifier = "-" + c;
        }
        return id.getArtifactId() + "-" + id.getVersion().getValue() + classifier + ext;
    }

    public String getDefaultIdContentExtension(String packaging, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)packaging)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported empty packaging", (Object[])new Object[0]));
        }
        switch (packaging) {
            case "jar": 
            case "bundle": 
            case "nuts-extension": 
            case "maven-archetype": 
            case "maven-plugin": 
            case "ejb-client": 
            case "test-jar": 
            case "ejb": 
            case "java-source": 
            case "javadoc": 
            case "eclipse-plugin": {
                return ".jar";
            }
            case "dll": 
            case "so": 
            case "jnilib": {
                return "-natives.jar";
            }
            case "war": {
                return ".war";
            }
            case "ear": {
                return ".ear";
            }
            case "pom": {
                return ".pom";
            }
            case "nuts": {
                return ".nuts";
            }
            case "rar": {
                return ".rar";
            }
            case "zip": 
            case "nbm-application": {
                return ".zip";
            }
        }
        return "." + packaging;
    }

    public String getDefaultIdExtension(NutsId id, NutsSession session) {
        String f;
        Map q = id.getProperties();
        switch (f = NutsUtilStrings.trim((String)((String)q.get("face")))) {
            case "descriptor": {
                return ".nuts";
            }
            case "descriptor-hash": {
                return ".nuts.sha1";
            }
            case "catalog": {
                return ".catalog";
            }
            case "content-hash": {
                return this.getDefaultIdExtension(id.builder().setFaceContent().build(), session) + ".sha1";
            }
            case "content": {
                return this.getDefaultIdContentExtension((String)q.get("packaging"), session);
            }
        }
        if (f.equals("cache") || f.endsWith(".cache")) {
            return "." + f;
        }
        if (NutsUtilStrings.isBlank((CharSequence)f)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing face in %s", (Object[])new Object[]{id}));
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported face %s in %s", (Object[])new Object[]{f, id}));
    }
}

