/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsArgumentType;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsCommandLineFormat;
import net.thevpc.nuts.NutsCommandLineProcessor;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.parsers.StringTokenizerUtils;
import net.thevpc.nuts.runtime.core.app.DefaultNutsCommandLineManager;

public class DefaultNutsCommandLine
implements NutsCommandLine {
    protected LinkedList<String> args = new LinkedList();
    protected List<NutsArgument> lookahead = new ArrayList<NutsArgument>();
    protected boolean expandSimpleOptions = true;
    protected Set<String> specialSimpleOptions = new HashSet<String>();
    protected String commandName;
    protected NutsSession session;
    private int wordIndex = 0;
    private NutsCommandAutoComplete autoComplete;
    private char eq = (char)61;

    public DefaultNutsCommandLine(NutsSession session) {
        this.session = session;
    }

    public DefaultNutsCommandLine(NutsApplicationContext context) {
        this.session = context.getSession();
        this.setArguments(context.getArguments());
        this.setAutoComplete(context.getAutoComplete());
    }

    public DefaultNutsCommandLine(NutsSession session, String[] args, NutsCommandAutoComplete autoComplete) {
        this.session = session;
        this.setArguments(args);
        this.setAutoComplete(autoComplete);
    }

    public DefaultNutsCommandLine(NutsSession session, String[] args) {
        this.session = session;
        this.setArguments(args);
    }

    public DefaultNutsCommandLine(NutsSession session, List<String> args, NutsCommandAutoComplete autoComplete) {
        this.session = session;
        this.setArguments(args);
        this.setAutoComplete(autoComplete);
    }

    public DefaultNutsCommandLine(List<String> args) {
        this.setArguments(args);
    }

    public NutsWorkspace getWorkspace() {
        return this.session.getWorkspace();
    }

    public NutsCommandLine setAutoComplete(NutsCommandAutoComplete autoComplete) {
        this.autoComplete = autoComplete;
        return this;
    }

    public NutsCommandAutoComplete getAutoComplete() {
        return this.autoComplete;
    }

    public NutsCommandLine unregisterSpecialSimpleOption(String option) {
        this.specialSimpleOptions.remove(option);
        return this;
    }

    public String[] getSpecialSimpleOptions() {
        return this.specialSimpleOptions.toArray(new String[0]);
    }

    public NutsCommandLine registerSpecialSimpleOption(String option) {
        int len = option.length();
        switch (len) {
            case 0: {
                break;
            }
            case 1: {
                if (!option.equals("-") && !option.equals("+")) break;
                this.specialSimpleOptions.add(option);
                return this;
            }
            default: {
                if ((option.charAt(0) != '-' || option.charAt(1) == '-') && (option.charAt(0) != '+' || option.charAt(1) == '+')) break;
                this.specialSimpleOptions.add(option);
                return this;
            }
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"invalid special option %s", (Object[])new Object[]{option}));
    }

    public boolean isSpecialSimpleOption(String option) {
        for (String x : this.specialSimpleOptions) {
            if (option.equals(x) || option.startsWith(x + this.eq)) {
                return true;
            }
            if (option.startsWith("-//" + x.substring(1))) {
                return true;
            }
            if (option.startsWith("-!" + x.substring(1))) {
                return true;
            }
            if (!option.startsWith("-~" + x.substring(1))) continue;
            return true;
        }
        return false;
    }

    public int getWordIndex() {
        return this.wordIndex;
    }

    public boolean isExecMode() {
        return this.autoComplete == null;
    }

    public boolean isAutoCompleteMode() {
        return this.autoComplete != null;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public NutsCommandLine setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    public boolean isExpandSimpleOptions() {
        return this.expandSimpleOptions;
    }

    public NutsCommandLine setExpandSimpleOptions(boolean expand) {
        this.expandSimpleOptions = expand;
        return this;
    }

    public NutsCommandLine requireNonOption() {
        if (!this.hasNext() || !this.peek().isNonOption()) {
            this.throwError(NutsMessage.cstyle((String)"expected value", (Object[])new Object[0]));
        }
        return this;
    }

    public NutsCommandLine unexpectedArgument(NutsString errorMessage) {
        if (!this.isEmpty()) {
            if (this.autoComplete != null) {
                this.skipAll();
                return this;
            }
            NutsTextBuilder m = this.getWorkspace().text().builder();
            m.append((Object)"unexpected argument ").append((Object)this.highlightText(String.valueOf(this.peek())));
            if (errorMessage != null && errorMessage.textLength() > 0) {
                m.append((Object)" , ").append((Object)errorMessage);
            }
            this.throwError((NutsString)m.build());
        }
        return this;
    }

    public NutsCommandLine unexpectedArgument(NutsMessage errorMessage) {
        return this.unexpectedArgument((NutsString)(errorMessage == null ? null : this.getWorkspace().text().toText((Object)errorMessage)));
    }

    public NutsCommandLine unexpectedArgument() {
        return this.unexpectedArgument((NutsMessage)null);
    }

    public NutsCommandLine required() {
        return this.required((NutsMessage)null);
    }

    public NutsCommandLine required(NutsString errorMessage) {
        if (this.isEmpty()) {
            if (this.autoComplete != null) {
                this.skipAll();
                return this;
            }
            this.throwError((NutsString)(errorMessage == null || errorMessage.isEmpty() ? this.getWorkspace().text().toText((Object)"missing arguments") : errorMessage));
        }
        return this;
    }

    public NutsCommandLine required(NutsMessage errorMessage) {
        return this.required((NutsString)(errorMessage == null ? null : this.getWorkspace().text().toText((Object)errorMessage)));
    }

    public NutsCommandLine pushBack(NutsArgument arg) {
        if (arg == null) {
            this.throwError(NutsMessage.cstyle((String)"null argument", (Object[])new Object[0]));
        }
        this.lookahead.add(0, arg);
        return this;
    }

    public NutsArgument next() {
        return this.next(false, this.expandSimpleOptions);
    }

    public NutsArgument next(NutsArgumentName name) {
        return this.next(name, false, false);
    }

    public NutsArgument peek() {
        return this.get(0);
    }

    public boolean hasNext() {
        return !this.lookahead.isEmpty() || !this.args.isEmpty();
    }

    public NutsArgument nextBoolean(String ... names) {
        return this.next(NutsArgumentType.BOOLEAN, names);
    }

    public NutsArgument nextString(String ... names) {
        return this.next(NutsArgumentType.STRING, names);
    }

    public NutsArgument next(String ... names) {
        return this.next(NutsArgumentType.ANY, names);
    }

    public NutsArgument next(NutsArgumentType expectValue, String ... names) {
        if (expectValue == null) {
            expectValue = NutsArgumentType.ANY;
        }
        if (names.length == 0) {
            if (this.hasNext()) {
                NutsArgument peeked = this.peek();
                names = new String[]{peeked.getStringKey()};
            }
        } else if (this.isAutoCompleteMode()) {
            NutsArgumentCandidate[] candidates;
            NutsArgumentCandidate[] nutsArgumentCandidateArray = candidates = this.resolveRecommendations(expectValue, names, this.autoComplete.getCurrentWordIndex());
            int n = nutsArgumentCandidateArray.length;
            for (int i = 0; i < n; ++i) {
                NutsArgumentCandidate c = nutsArgumentCandidateArray[i];
                this.autoComplete.addCandidate(c);
            }
        }
        for (String nameSeq : names) {
            String[] nameSeqArray = StringTokenizerUtils.split(nameSeq, " ").toArray(new String[0]);
            if (nameSeqArray.length == 0 || !this.isPrefixed(nameSeqArray)) continue;
            String name = nameSeqArray[nameSeqArray.length - 1];
            NutsArgument p = this.get(nameSeqArray.length - 1);
            if (p == null || !p.getStringKey().equals(name)) continue;
            switch (expectValue) {
                case ANY: {
                    this.skip(nameSeqArray.length);
                    return p;
                }
                case STRING: {
                    this.skip(nameSeqArray.length);
                    if (p.isKeyValue()) {
                        return p;
                    }
                    NutsArgument r2 = this.peek();
                    if (r2 != null && !r2.isOption()) {
                        this.skip();
                        return this.createArgument(p.getString() + this.eq + r2.getString());
                    }
                    return p;
                }
                case BOOLEAN: {
                    this.skip(nameSeqArray.length);
                    if (p.isNegated()) {
                        if (p.isKeyValue()) {
                            boolean x = p.getBoolean();
                            return this.createArgument(p.getStringKey() + this.eq + !x);
                        }
                        return this.createArgument(p.getStringKey() + this.eq + false);
                    }
                    if (p.isKeyValue()) {
                        return p;
                    }
                    return this.createArgument(p.getStringKey() + this.eq + true);
                }
            }
            this.throwError((NutsString)this.getWorkspace().text().builder().append((Object)"unsupported ").append((Object)this.highlightText(String.valueOf(expectValue))).build());
        }
        return null;
    }

    public NutsArgument nextRequiredNonOption(NutsArgumentName name) {
        return this.next(name, true, true);
    }

    public NutsArgument nextNonOption() {
        if (this.hasNext() && !this.peek().isOption()) {
            return this.next();
        }
        return null;
    }

    public NutsArgument nextNonOption(NutsArgumentName name) {
        return this.next(name, true, false);
    }

    public int skipAll() {
        int count = 0;
        while (this.hasNext()) {
            count += this.skip(1);
        }
        return count;
    }

    public int skip() {
        return this.skip(1);
    }

    public int skip(int count) {
        if (count < 0) {
            count = 0;
        }
        for (int initialCount = count; initialCount > 0 && this.hasNext() && this.next() != null; --initialCount) {
            ++this.wordIndex;
        }
        return count;
    }

    public boolean accept(String ... values) {
        return this.accept(0, values);
    }

    public boolean accept(int index, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            NutsArgument argument = this.get(index + i);
            if (argument == null) {
                return false;
            }
            if (argument.getStringKey().equals(values[i])) continue;
            return false;
        }
        return true;
    }

    public NutsArgument find(String name) {
        int index = this.indexOf(name);
        if (index >= 0) {
            return this.get(index);
        }
        return null;
    }

    public NutsArgument get(int index) {
        if (index < 0) {
            return null;
        }
        if (index < this.lookahead.size()) {
            return this.lookahead.get(index);
        }
        while (!this.args.isEmpty() && index >= this.lookahead.size() && this.ensureNext(this.isExpandSimpleOptions(), true)) {
        }
        if (index < this.lookahead.size()) {
            return this.lookahead.get(index);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public int indexOf(String name) {
        for (int i = 0; i < this.length(); ++i) {
            if (!this.get(i).getStringKey().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int length() {
        return this.lookahead.size() + this.args.size();
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public String[] toStringArray() {
        ArrayList<String> all = new ArrayList<String>(this.length());
        for (NutsArgument nutsArgument : this.lookahead) {
            all.add(nutsArgument.getString());
        }
        all.addAll(this.args);
        return all.toArray(new String[0]);
    }

    public NutsArgument[] toArgumentArray() {
        ArrayList<NutsArgument> aa = new ArrayList<NutsArgument>();
        while (this.hasNext()) {
            aa.add(this.next());
        }
        this.lookahead.addAll(aa);
        return aa.toArray(new NutsArgument[0]);
    }

    public boolean isOption(int index) {
        NutsArgument x = this.get(index);
        return x != null && x.isOption();
    }

    public boolean isNonOption(int index) {
        NutsArgument x = this.get(index);
        return x != null && x.isNonOption();
    }

    public NutsCommandLine parseLine(String commandLine) {
        this.setArguments(this.session.getWorkspace().commandLine().parse(commandLine).toStringArray());
        return this;
    }

    public NutsCommandLine setArguments(List<String> arguments) {
        if (arguments == null) {
            return this.setArguments(new String[0]);
        }
        return this.setArguments(arguments.toArray(new String[0]));
    }

    public NutsCommandLine setArguments(String[] arguments) {
        this.lookahead.clear();
        this.args.clear();
        if (arguments != null) {
            Collections.addAll(this.args, arguments);
        }
        return this;
    }

    public void throwError(NutsMessage message) {
        if (NutsUtilStrings.isBlank((CharSequence)this.commandName)) {
            throw new NutsIllegalArgumentException(this.session, message);
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"%s : %s", (Object[])new Object[]{this.commandName, message}));
    }

    public void process(NutsCommandLineConfigurable defaultConfigurable, NutsCommandLineProcessor commandLineProcessor) {
        commandLineProcessor.onInit((NutsCommandLine)this);
        while (this.hasNext()) {
            NutsArgument a = this.peek();
            boolean consumed = a.isOption() ? commandLineProcessor.onNextOption(a, (NutsCommandLine)this) : commandLineProcessor.onNextNonOption(a, (NutsCommandLine)this);
            if (consumed) {
                NutsArgument next = this.peek();
                if (next != a) continue;
                throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"%s must consume the option: %s", (Object[])new Object[]{a.isOption() ? "nextOption" : "nextNonOption", a}));
            }
            if (this._configureLast(this, defaultConfigurable)) continue;
            this.unexpectedArgument();
        }
        commandLineProcessor.onPrepare((NutsCommandLine)this);
        if (this.isExecMode()) {
            commandLineProcessor.onExec();
        } else if (this.getAutoComplete() != null) {
            commandLineProcessor.onAutoComplete(this.getAutoComplete());
        }
    }

    public void throwError(NutsString message) {
        NutsTextBuilder m = this.getWorkspace().text().builder();
        if (!NutsUtilStrings.isBlank((CharSequence)this.commandName)) {
            m.append((Object)this.commandName).append((Object)" : ");
        }
        m.append((Object)message);
        throw new NutsIllegalArgumentException(this.session, NutsMessage.formatted((String)m.build().toString()));
    }

    public NutsCommandLineFormat formatter() {
        return this.session.getWorkspace().commandLine().formatter().setValue((NutsCommandLine)this);
    }

    private NutsArgumentCandidate[] resolveRecommendations(NutsArgumentType expectValue, String[] names, int autoCompletecurrentWordIndex) {
        ArrayList<NutsArgumentCandidate> candidates = new ArrayList<NutsArgumentCandidate>();
        for (String nameSeq : names) {
            String[] nameSeqArray = StringTokenizerUtils.split(nameSeq, " ").toArray(new String[0]);
            if (nameSeqArray.length <= 0) continue;
            int i = autoCompletecurrentWordIndex < nameSeqArray.length ? autoCompletecurrentWordIndex : nameSeqArray.length - 1;
            boolean skipToNext = false;
            for (int j = 0; j < i; ++j) {
                String xs;
                String a = nameSeqArray[j];
                NutsArgument x = this.get(j);
                if (x == null || (xs = x.getString()).length() <= 0 || xs.equals(a)) continue;
                skipToNext = true;
                break;
            }
            if (skipToNext) continue;
            skipToNext = false;
            if (i < nameSeqArray.length - 1) {
                String a = nameSeqArray[i];
                NutsArgument x = this.get(i);
                if (x != null) {
                    String xs = x.getString();
                    if (xs.length() > 0 && xs.equals(a)) {
                        skipToNext = true;
                    } else if (xs.length() > 0 && a.startsWith(xs) && !xs.equals(a)) {
                        candidates.add(this.createCandidate(a));
                        skipToNext = true;
                    } else {
                        skipToNext = true;
                    }
                }
            }
            if (skipToNext || this.getWordIndex() + nameSeqArray.length - 1 != autoCompletecurrentWordIndex) continue;
            String name = nameSeqArray[nameSeqArray.length - 1];
            NutsArgument p = this.get(nameSeqArray.length - 1);
            if (p != null) {
                if (!name.startsWith(p.getStringKey())) continue;
                candidates.add(this.createCandidate(name));
                continue;
            }
            candidates.add(this.createCandidate(name));
        }
        return candidates.toArray(new NutsArgumentCandidate[0]);
    }

    private boolean isPrefixed(String[] nameSeqArray) {
        for (int i = 0; i < nameSeqArray.length - 1; ++i) {
            NutsArgument x = this.get(i);
            if (x != null && x.getString().equals(nameSeqArray[i])) continue;
            return false;
        }
        return true;
    }

    private NutsArgumentCandidate createCandidate(String s) {
        return this.getWorkspace().commandLine().createCandidate(s).build();
    }

    public NutsArgument next(NutsArgumentName name, boolean forceNonOption, boolean error) {
        if (!(!this.hasNext() || forceNonOption && this.peek().isOption())) {
            if (this.isAutoComplete()) {
                List values;
                List list = values = name == null ? null : name.getCandidates(this.getAutoComplete());
                if (values == null || values.isEmpty()) {
                    this.autoComplete.addCandidate(this.createCandidate(name == null ? "<value>" : name.getName()));
                } else {
                    for (NutsArgumentCandidate value : values) {
                        this.autoComplete.addCandidate(value);
                    }
                }
            }
            NutsArgument r = this.peek();
            this.skip();
            return r;
        }
        if (this.autoComplete != null) {
            if (this.isAutoComplete()) {
                List values;
                List list = values = name == null ? null : name.getCandidates(this.getAutoComplete());
                if (values == null || values.isEmpty()) {
                    this.autoComplete.addCandidate(this.createCandidate(name == null ? "<value>" : name.getName()));
                } else {
                    for (NutsArgumentCandidate value : values) {
                        this.autoComplete.addCandidate(value);
                    }
                }
            }
            return this.createArgument("");
        }
        if (!error) {
            return null;
        }
        if (!(!this.hasNext() || forceNonOption && this.peek().isOption())) {
            this.throwError((NutsString)this.getWorkspace().text().builder().append((Object)"unexpected option ").append((Object)this.highlightText(String.valueOf(this.peek()))).build());
        }
        this.throwError((NutsString)this.getWorkspace().text().builder().append((Object)"missing argument ").append((Object)this.highlightText(name == null ? "value" : name.getName())).build());
        return null;
    }

    public NutsArgument next(boolean required, boolean expandSimpleOptions) {
        if (this.ensureNext(expandSimpleOptions, false)) {
            if (!this.lookahead.isEmpty()) {
                return this.lookahead.remove(0);
            }
            String v = this.args.removeFirst();
            return this.createArgument(v);
        }
        if (required) {
            this.throwError(NutsMessage.cstyle((String)"missing argument", (Object[])new Object[0]));
        }
        return null;
    }

    public String toString() {
        return this.formatter().format().filteredText();
    }

    private boolean isExpandableOption(String v, boolean expandSimpleOptions) {
        if (!expandSimpleOptions || v.length() <= 2) {
            return false;
        }
        if (this.isSpecialSimpleOption(v)) {
            return false;
        }
        if (v.charAt(0) == '-') {
            return v.charAt(1) != '-';
        }
        if (v.charAt(0) == '+') {
            return v.charAt(1) != '+';
        }
        return false;
    }

    private String createExpandedSimpleOption(char start, boolean negate, char val) {
        char[] cArray;
        if (negate) {
            char[] cArray2 = new char[3];
            cArray2[0] = start;
            cArray2[1] = 33;
            cArray = cArray2;
            cArray2[2] = val;
        } else {
            char[] cArray3 = new char[2];
            cArray3[0] = start;
            cArray = cArray3;
            cArray3[1] = val;
        }
        return new String(cArray);
    }

    private String createExpandedSimpleOption(char start, boolean negate, String val) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        if (negate) {
            sb.append('!');
        }
        sb.append(val);
        return sb.toString();
    }

    private boolean ensureNext(boolean expandSimpleOptions, boolean ignoreExistingExpanded) {
        if (!ignoreExistingExpanded && !this.lookahead.isEmpty()) {
            return true;
        }
        if (!this.args.isEmpty()) {
            String v = this.args.removeFirst();
            if (this.isExpandableOption(v, expandSimpleOptions)) {
                char[] chars = v.toCharArray();
                boolean negate = false;
                Character last = null;
                char start = v.charAt(0);
                for (int i = 1; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c == '!' || c == '~') {
                        if (last != null) {
                            this.lookahead.add(this.createArgument(this.createExpandedSimpleOption(start, negate, last.charValue())));
                            last = null;
                        }
                        negate = true;
                        continue;
                    }
                    if (chars[i] == this.eq) {
                        String nextArg = new String(chars, i, chars.length - i);
                        if (last != null) {
                            nextArg = last + nextArg;
                            last = null;
                        }
                        this.lookahead.add(this.createArgument(this.createExpandedSimpleOption(start, negate, nextArg)));
                        i = chars.length;
                        continue;
                    }
                    if (this.isPunctuation(chars[i])) {
                        StringBuilder sb = new StringBuilder();
                        if (last != null) {
                            sb.append(last);
                        }
                        sb.append(chars[i]);
                        while (i + 1 < chars.length) {
                            sb.append(chars[++i]);
                        }
                        this.lookahead.add(this.createArgument(this.createExpandedSimpleOption(start, negate, sb.toString())));
                        last = null;
                        continue;
                    }
                    if (last != null) {
                        this.lookahead.add(this.createArgument(this.createExpandedSimpleOption(start, negate, last.charValue())));
                    }
                    last = Character.valueOf(chars[i]);
                }
                if (last != null) {
                    this.lookahead.add(this.createArgument(this.createExpandedSimpleOption(start, negate, last.charValue())));
                }
            } else {
                this.lookahead.add(this.createArgument(v));
            }
            return true;
        }
        return false;
    }

    private NutsArgument createArgument(String v) {
        return DefaultNutsCommandLineManager.Factory.createArgument0(this.getWorkspace(), v, this.eq);
    }

    private boolean isAutoComplete() {
        return this.autoComplete != null && this.getWordIndex() == this.autoComplete.getCurrentWordIndex();
    }

    public NutsCommandLine copy() {
        DefaultNutsCommandLine c = new DefaultNutsCommandLine(this.session, this.toStringArray(), this.autoComplete);
        c.eq = this.eq;
        c.commandName = this.commandName;
        return c;
    }

    private NutsString highlightText(String text) {
        return this.getWorkspace().text().forStyled(text, NutsTextStyle.primary3());
    }

    private boolean _configureLast(NutsCommandLine commandLine, NutsCommandLineConfigurable configurable) {
        if (configurable == null) {
            commandLine.unexpectedArgument();
            return false;
        }
        if (!configurable.configureFirst(commandLine)) {
            commandLine.unexpectedArgument();
            return false;
        }
        return true;
    }

    private boolean isPunctuation(char c) {
        int t = Character.getType(c);
        return t != 2 && t != 1 && t != 3;
    }

    public Iterator<NutsArgument> iterator() {
        return Arrays.asList(this.toArgumentArray()).iterator();
    }
}

