/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.util.ArrayList;
import net.thevpc.nuts.NutsCommandLineFormatStrategy;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.core.app.NutsCommandLineBashFamilySupport;

public class DefaultCommandLineBash
implements NutsCommandLineBashFamilySupport {
    protected String[] parseCommandLineArrBash(String commandLineString, NutsSession session) {
        if (commandLineString == null) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block30: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case ' ': {
                            continue block30;
                        }
                        case '\'': {
                            status = 2;
                            continue block30;
                        }
                        case '\"': {
                            status = 3;
                            continue block30;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block30;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\'': {
                            throw new NutsParseException(session, NutsMessage.cstyle((String)"illegal char %s", (Object[])new Object[]{Character.valueOf(c)}));
                        }
                        case '\"': {
                            throw new NutsParseException(session, NutsMessage.cstyle((String)"illegal char %s", (Object[])new Object[]{Character.valueOf(c)}));
                        }
                        case '\\': {
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\\': {
                            i = this.readEscapedBash(charArray, i + 1, sb);
                            continue block30;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                throw new NutsParseException(session, NutsMessage.cstyle((String)"expected '", (Object[])new Object[0]));
            }
        }
        return args.toArray(new String[0]);
    }

    public int readEscapedBash(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case ' ': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case ';': 
            case '<': 
            case '>': 
            case '\\': 
            case '|': 
            case '~': {
                sb.append(c);
                break;
            }
            default: {
                sb.append('\\').append(c);
            }
        }
        return i;
    }

    @Override
    public String escapeArgument(String arg, NutsCommandLineFormatStrategy s, NutsSession session) {
        if (arg == null || arg.isEmpty()) {
            return "''";
        }
        if (s == null || s == NutsCommandLineFormatStrategy.DEFAULT) {
            s = NutsCommandLineFormatStrategy.SUPPORT_QUOTES;
        }
        switch (s) {
            case NO_QUOTES: {
                StringBuilder sb = new StringBuilder();
                block17: for (char c : arg.toCharArray()) {
                    switch (c) {
                        case '\t': 
                        case ' ': 
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '\\': 
                        case '|': 
                        case '~': {
                            sb.append("\\").append(c);
                            continue block17;
                        }
                        case '\n': 
                        case '\r': {
                            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unsupported new line in arguments"));
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            case SUPPORT_QUOTES: {
                StringBuilder sb = new StringBuilder();
                for (char c : arg.toCharArray()) {
                    switch (c) {
                        case '\t': 
                        case ' ': 
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '\\': 
                        case '|': 
                        case '~': {
                            return this.escapeArgument(arg, NutsCommandLineFormatStrategy.REQUIRE_QUOTES, session);
                        }
                        case '\n': 
                        case '\r': {
                            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unsupported new line in arguments"));
                        }
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            case REQUIRE_QUOTES: {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                block19: for (char c : arg.toCharArray()) {
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            sb.append("\\").append(c);
                            continue block19;
                        }
                        case '\n': 
                        case '\r': {
                            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unsupported new line in arguments"));
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                sb.append("'");
                return sb.toString();
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)s);
    }
}

