/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.app;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBootException;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.runtime.core.app.DefaultNutsCommandLine;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;

public final class CoreNutsArgumentsParser {
    private CoreNutsArgumentsParser() {
    }

    public static void parseNutsArguments(NutsSession session, String[] bootArguments, NutsWorkspaceOptionsBuilder options) {
        ArrayList<NutsMessage> showError = new ArrayList<NutsMessage>();
        HashSet<String> excludedExtensions = new HashSet<String>();
        HashSet<String> repositories = new HashSet<String>();
        LinkedHashSet<String> tempProps = new LinkedHashSet<String>();
        ArrayList<String> executorOptions = new ArrayList<String>();
        NutsLogConfig logConfig = null;
        ArrayList<String> applicationArguments = new ArrayList<String>();
        NutsCommandLine cmdLine = new DefaultNutsCommandLine(session, bootArguments).setCommandName("nuts").setExpandSimpleOptions(true).registerSpecialSimpleOption("-version");
        boolean explicitConfirm = false;
        block345: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            if (a.isOption()) {
                String k;
                boolean enabled = a.isEnabled();
                block238 : switch (k = a.getStringKey()) {
                    case "-w": 
                    case "--workspace": {
                        a = cmdLine.nextString(new String[0]);
                        String file = a.getStringValue("");
                        if (!enabled) continue block345;
                        options.setWorkspace(file);
                        break;
                    }
                    case "--user": 
                    case "-u": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue("");
                        if (!enabled) continue block345;
                        options.setUsername(v);
                        break;
                    }
                    case "--password": 
                    case "-p": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue("");
                        if (!enabled) continue block345;
                        options.setCredentials(v.toCharArray());
                        break;
                    }
                    case "-V": 
                    case "--boot-version": 
                    case "--boot-api-version": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setApiVersion(v);
                        break;
                    }
                    case "--boot-runtime": {
                        a = cmdLine.nextString(new String[0]);
                        String br = a.getStringValue("");
                        if (!enabled) continue block345;
                        if (br.indexOf("#") <= 0) {
                            br = "net.thevpc.nuts:nuts-runtime#" + br;
                        }
                        options.setRuntimeId(br);
                        break;
                    }
                    case "--java": 
                    case "--boot-java": 
                    case "-j": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue("");
                        if (!enabled) continue block345;
                        options.setJavaCommand(v);
                        break;
                    }
                    case "--java-home": 
                    case "--boot-java-home": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setJavaCommand(NutsJavaSdkUtils.of(session).resolveJavaCommandByHome(v, session));
                        break;
                    }
                    case "--java-options": 
                    case "--boot-java-options": 
                    case "-J": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue("");
                        if (!enabled) continue block345;
                        options.setJavaOptions(v);
                        break;
                    }
                    case "--name": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setName(v);
                        break;
                    }
                    case "--archetype": 
                    case "-A": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setArchetype(v);
                        break;
                    }
                    case "--store-strategy": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue("");
                        if (!enabled) continue block345;
                        options.setStoreLocationStrategy(CoreNutsArgumentsParser.parseNutsStoreLocationStrategy(v, session));
                        break;
                    }
                    case "-S": 
                    case "--standalone": 
                    case "--standalone-workspace": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationStrategy(NutsStoreLocationStrategy.STANDALONE);
                        break;
                    }
                    case "-E": 
                    case "--exploded": 
                    case "--exploded-workspace": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationStrategy(NutsStoreLocationStrategy.EXPLODED);
                        break;
                    }
                    case "--repo-store-strategy": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setRepositoryStoreLocationStrategy(CoreNutsArgumentsParser.parseNutsStoreLocationStrategy(v, session));
                        break;
                    }
                    case "--exploded-repositories": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy.EXPLODED);
                        break;
                    }
                    case "--standalone-repositories": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy.STANDALONE);
                        break;
                    }
                    case "--store-layout": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setStoreLocationLayout(CoreNutsArgumentsParser.parseNutsStoreLocationLayout(v, session));
                        break;
                    }
                    case "--system-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(null);
                        break;
                    }
                    case "--windows-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.WINDOWS);
                        break;
                    }
                    case "--macos-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.MACOS);
                        break;
                    }
                    case "--linux-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.LINUX);
                        break;
                    }
                    case "--unix-layout": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setStoreLocationLayout(NutsOsFamily.UNIX);
                        break;
                    }
                    case "--apps-location": 
                    case "--config-location": 
                    case "--var-location": 
                    case "--log-location": 
                    case "--temp-location": 
                    case "--cache-location": 
                    case "--lib-location": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        NutsStoreLocation m = NutsStoreLocation.valueOf((String)k.substring(2, k.indexOf(45)).toUpperCase());
                        options.setStoreLocation(m, v);
                        break;
                    }
                    case "--system-apps-home": 
                    case "--system-config-home": 
                    case "--system-var-home": 
                    case "--system-log-home": 
                    case "--system-temp-home": 
                    case "--system-cache-home": 
                    case "--system-lib-home": 
                    case "--system-run-home": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        NutsStoreLocation folder = NutsStoreLocation.valueOf((String)k.substring(3 + "system".length(), k.indexOf(45, 3 + "system".length())).toUpperCase());
                        if (!enabled) continue block345;
                        options.setHomeLocation(null, folder, v);
                        break;
                    }
                    case "--windows-apps-home": 
                    case "--windows-config-home": 
                    case "--windows-var-home": 
                    case "--windows-log-home": 
                    case "--windows-temp-home": 
                    case "--windows-cache-home": 
                    case "--windows-lib-home": 
                    case "--windows-run-home": 
                    case "--macos-apps-home": 
                    case "--macos-config-home": 
                    case "--macos-var-home": 
                    case "--macos-log-home": 
                    case "--macos-temp-home": 
                    case "--macos-cache-home": 
                    case "--macos-lib-home": 
                    case "--macos-run-home": 
                    case "--linux-apps-home": 
                    case "--linux-config-home": 
                    case "--linux-var-home": 
                    case "--linux-log-home": 
                    case "--linux-temp-home": 
                    case "--linux-cache-home": 
                    case "--linux-lib-home": 
                    case "--linux-run-home": 
                    case "--unix-apps-home": 
                    case "--unix-config-home": 
                    case "--unix-var-home": 
                    case "--unix-log-home": 
                    case "--unix-temp-home": 
                    case "--unix-cache-home": 
                    case "--unix-lib-home": 
                    case "--unix-run-home": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        NutsOsFamily layout = NutsOsFamily.valueOf((String)k.substring(2, k.indexOf(45, 2)).toUpperCase());
                        NutsStoreLocation folder = NutsStoreLocation.valueOf((String)k.substring(3 + layout.toString().length(), k.indexOf(45, 3 + layout.toString().length())).toUpperCase());
                        if (!enabled) continue block345;
                        options.setHomeLocation(layout, folder, v);
                        break;
                    }
                    case "--skip-companions": 
                    case "-k": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setSkipCompanions(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--skip-welcome": 
                    case "-K": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setSkipWelcome(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--skip-boot": 
                    case "-Q": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setSkipBoot(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--switch": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setSwitchWorkspace(a.getBooleanValue(Boolean.valueOf(true)));
                        break;
                    }
                    case "--no-switch": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setSwitchWorkspace(Boolean.valueOf(a.getBooleanValue(Boolean.valueOf(true)) == false));
                        break;
                    }
                    case "-g": 
                    case "--global": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setGlobal(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--gui": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setGui(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--color": 
                    case "-c": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        String v = a.getStringValue("");
                        if (v.isEmpty()) {
                            options.setTerminalMode(NutsTerminalMode.FORMATTED);
                            break;
                        }
                        Boolean b = NutsUtilStrings.parseBoolean((String)v, null, null);
                        if (b != null) {
                            if (b.booleanValue()) {
                                options.setTerminalMode(NutsTerminalMode.FORMATTED);
                                break;
                            }
                            options.setTerminalMode(NutsTerminalMode.FILTERED);
                            break;
                        }
                        switch (v.toLowerCase()) {
                            case "formatted": {
                                options.setTerminalMode(NutsTerminalMode.FORMATTED);
                                break block238;
                            }
                            case "filtered": {
                                options.setTerminalMode(NutsTerminalMode.FILTERED);
                                break block238;
                            }
                            case "h": 
                            case "inherited": {
                                options.setTerminalMode(NutsTerminalMode.INHERITED);
                                break block238;
                            }
                            case "s": 
                            case "auto": 
                            case "system": {
                                options.setTerminalMode(null);
                                break block238;
                            }
                        }
                        cmdLine.pushBack(a);
                        cmdLine.unexpectedArgument();
                        break;
                    }
                    case "-C": 
                    case "--no-color": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setTerminalMode(NutsTerminalMode.FILTERED);
                        break;
                    }
                    case "-B": 
                    case "--bot": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setBot(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-R": 
                    case "--read-only": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setReadOnly(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-t": 
                    case "--trace": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setTrace(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-P": 
                    case "--progress": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setProgressOptions(a.getStringValue());
                        break;
                    }
                    case "--no-progress": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setProgressOptions("none");
                        break;
                    }
                    case "--dry": 
                    case "-D": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setDry(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--debug": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setDebug(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--verbose": 
                    case "--log-verbose": 
                    case "--log-finest": 
                    case "--log-finer": 
                    case "--log-fine": 
                    case "--log-info": 
                    case "--log-warning": 
                    case "--log-severe": 
                    case "--log-config": 
                    case "--log-all": 
                    case "--log-off": 
                    case "--log-term-verbose": 
                    case "--log-term-finest": 
                    case "--log-term-finer": 
                    case "--log-term-fine": 
                    case "--log-term-info": 
                    case "--log-term-warning": 
                    case "--log-term-severe": 
                    case "--log-term-config": 
                    case "--log-term-all": 
                    case "--log-term-off": 
                    case "--log-file-verbose": 
                    case "--log-file-finest": 
                    case "--log-file-finer": 
                    case "--log-file-fine": 
                    case "--log-file-info": 
                    case "--log-file-warning": 
                    case "--log-file-severe": 
                    case "--log-file-config": 
                    case "--log-file-all": 
                    case "--log-file-off": 
                    case "--log-file-size": 
                    case "--log-file-name": 
                    case "--log-file-base": 
                    case "--log-file-count": 
                    case "--log-inherited": {
                        if (enabled && logConfig == null) {
                            logConfig = new NutsLogConfig();
                        }
                        CoreNutsArgumentsParser.parseLogLevel(logConfig, cmdLine, enabled, session);
                        break;
                    }
                    case "-X": 
                    case "--exclude-extension": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        excludedExtensions.add(v);
                        break;
                    }
                    case "--repository": 
                    case "--repositories": 
                    case "--repo": 
                    case "--repos": 
                    case "-r": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        repositories.add(v);
                        break;
                    }
                    case "--output-format-option": 
                    case "-T": {
                        if (enabled) {
                            options.addOutputFormatOptions(new String[]{cmdLine.nextString(new String[0]).getStringValue()});
                            break;
                        }
                        cmdLine.skip();
                        break;
                    }
                    case "-O": 
                    case "--output-format": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        String t = a.getStringValue("");
                        int i = CoreStringUtils.firstIndexOf(t, new char[]{' ', ';', ':', '='});
                        if (i > 0) {
                            options.setOutputFormat(NutsContentType.valueOf((String)t.substring(0, i).toUpperCase()));
                            options.addOutputFormatOptions(new String[]{t.substring(i + 1).toUpperCase()});
                            break;
                        }
                        options.setOutputFormat(NutsContentType.valueOf((String)t.toUpperCase()));
                        options.addOutputFormatOptions(new String[]{""});
                        break;
                    }
                    case "--tson": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.TSON);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--yaml": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.YAML);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--json": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.JSON);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--plain": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.PLAIN);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--xml": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.XML);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--table": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.TABLE);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--tree": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.TREE);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--props": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        options.setOutputFormat(NutsContentType.PROPS);
                        options.addOutputFormatOptions(new String[]{a.getStringValue("")});
                        break;
                    }
                    case "--yes": 
                    case "-y": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.YES);
                        break;
                    }
                    case "--no": 
                    case "-n": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.NO);
                        break;
                    }
                    case "--error": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.ERROR);
                        break;
                    }
                    case "--ask": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        explicitConfirm = true;
                        options.setConfirm(NutsConfirmationMode.ASK);
                        break;
                    }
                    case "--cached": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setCached(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--indexed": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setIndexed(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--transitive": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setTransitive(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-f": 
                    case "--fetch": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.valueOf((String)a.getStringValue().toUpperCase().replace("-", "_")));
                        break;
                    }
                    case "-a": 
                    case "--anywhere": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.ANYWHERE);
                        break;
                    }
                    case "-F": 
                    case "--offline": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.OFFLINE);
                        break;
                    }
                    case "--online": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.ONLINE);
                        break;
                    }
                    case "--remote": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setFetchStrategy(NutsFetchStrategy.REMOTE);
                        break;
                    }
                    case "--embedded": 
                    case "-b": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.EMBEDDED);
                        break;
                    }
                    case "--external": 
                    case "--spawn": 
                    case "-x": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.SPAWN);
                        break;
                    }
                    case "--user-cmd": 
                    case "--system": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setExecutionType(NutsExecutionType.SYSTEM);
                        break;
                    }
                    case "--root-cmd": 
                    case "--as-root": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setRunAs(NutsRunAs.root());
                        break;
                    }
                    case "--current-user": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setRunAs(NutsRunAs.currentUser());
                        break;
                    }
                    case "--run-as": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        if (NutsUtilStrings.isBlank((CharSequence)a.getStringValue())) {
                            throw new NutsBootException(NutsMessage.cstyle((String)"missing user name", (Object[])new Object[0]));
                        }
                        options.setRunAs(NutsRunAs.user((String)a.getStringValue()));
                        break;
                    }
                    case "-o": 
                    case "--open-mode": {
                        a = cmdLine.nextString(new String[0]);
                        String v = a.getStringValue();
                        if (!enabled) continue block345;
                        options.setOpenMode(CoreNutsArgumentsParser.parseNutsWorkspaceOpenMode(v, session));
                        break;
                    }
                    case "--open-or-error": 
                    case "--open": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.OPEN_OR_ERROR);
                        break;
                    }
                    case "--create-or-error": 
                    case "--create": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.CREATE_OR_ERROR);
                        break;
                    }
                    case "--open-or-create": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.OPEN_OR_CREATE);
                        break;
                    }
                    case "--open-or-null": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setOpenMode(NutsOpenMode.OPEN_OR_NULL);
                        break;
                    }
                    case "-": {
                        cmdLine.skip();
                        if (enabled) {
                            if (!a.getArgumentValue().isNull()) {
                                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid argument for workspace: %s", (Object[])new Object[]{a.getString()}));
                            }
                            applicationArguments.add("net.thevpc.nuts.toolbox:nsh");
                            if (!cmdLine.isEmpty()) {
                                applicationArguments.add("-c");
                                applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
                            }
                            cmdLine.skipAll();
                            break;
                        }
                        applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
                        cmdLine.skipAll();
                        break;
                    }
                    case "-version": 
                    case "-v": 
                    case "--version": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setCommandVersion(Boolean.valueOf(a.isEnabled()));
                        break;
                    }
                    case "-Z": 
                    case "--reset": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (enabled) {
                            if (!a.getBooleanValue()) continue block345;
                            options.setReset(Boolean.valueOf(true));
                            options.setRecover(Boolean.valueOf(false));
                            break;
                        }
                        cmdLine.skipAll();
                        break;
                    }
                    case "-z": 
                    case "--recover": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setReset(Boolean.valueOf(false));
                        options.setRecover(Boolean.valueOf(true));
                        break;
                    }
                    case "-N": 
                    case "--expire": {
                        a = cmdLine.next();
                        if (!enabled) continue block345;
                        if (!NutsUtilStrings.isBlank((CharSequence)a.getStringValue())) {
                            options.setExpireTime(Instant.parse(a.getStringValue()));
                            break;
                        }
                        options.setExpireTime(Instant.now());
                        break;
                    }
                    case "--out-line-prefix": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setOutLinePrefix(a.getStringValue());
                        break;
                    }
                    case "--err-line-prefix": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setErrLinePrefix(a.getStringValue());
                        break;
                    }
                    case "--line-prefix": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setOutLinePrefix(a.getStringValue());
                        options.setErrLinePrefix(a.getStringValue());
                        break;
                    }
                    case "-e": 
                    case "--exec": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (enabled && a.getBooleanValue()) {
                            while ((a = cmdLine.next()) != null) {
                                if (a.isOption()) {
                                    executorOptions.add(a.getString());
                                    continue;
                                }
                                applicationArguments.add(a.getString());
                                applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
                                cmdLine.skipAll();
                            }
                            continue block345;
                        }
                        cmdLine.skipAll();
                        break;
                    }
                    case "-?": 
                    case "--help": 
                    case "-h": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled || !a.getBooleanValue()) continue block345;
                        options.setCommandHelp(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "--skip-errors": {
                        a = cmdLine.nextBoolean(new String[0]);
                        if (!enabled) continue block345;
                        options.setSkipErrors(Boolean.valueOf(a.getBooleanValue()));
                        break;
                    }
                    case "-L": 
                    case "--locale": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setLocale(a.getStringValue());
                        break;
                    }
                    case "--theme": {
                        a = cmdLine.nextString(new String[0]);
                        if (!enabled) continue block345;
                        options.setTheme(a.getStringValue());
                        break;
                    }
                    default: {
                        if (k.startsWith("---") && k.length() > 3 && k.charAt(3) != '-') {
                            a = cmdLine.next();
                            tempProps.add(a.toString().substring(3));
                            break;
                        }
                        cmdLine.skip();
                        showError.add(NutsMessage.cstyle((String)"nuts: invalid option %s", (Object[])new Object[]{a.getString()}));
                    }
                }
                continue;
            }
            applicationArguments.addAll(Arrays.asList(cmdLine.toStringArray()));
            cmdLine.skipAll();
        }
        options.setProperties(tempProps.toArray(new String[0]));
        options.setLogConfig(logConfig);
        options.setExcludedExtensions(excludedExtensions.toArray(new String[0]));
        options.setRepositories(repositories.toArray(new String[0]));
        options.setApplicationArguments(applicationArguments.toArray(new String[0]));
        options.setExecutorOptions(executorOptions.toArray(new String[0]));
        options.setErrors(showError.toArray(new NutsMessage[0]));
        if (!(applicationArguments.size() > 0 && (((String)applicationArguments.get(0)).equals("help") || options.isCommandHelp() || ((String)applicationArguments.get(0)).equals("version") || options.isCommandVersion()) || showError.isEmpty())) {
            NutsTextBuilder errorMessage = session.getWorkspace().text().builder();
            for (NutsMessage s : showError) {
                errorMessage.append((Object)s).append((Object)"\n");
            }
            errorMessage.append((Object)"Try 'nuts --help' for more information.");
            if (!options.isSkipErrors()) {
                throw new NutsIllegalArgumentException(session, NutsMessage.formatted((String)errorMessage.toString()));
            }
            session.err().println(errorMessage.toString());
        }
    }

    private static void parseLogLevel(NutsLogConfig logConfig, NutsCommandLine cmdLine, boolean enabled, NutsSession session) {
        NutsArgument a = cmdLine.peek();
        switch (a.getStringKey()) {
            case "--log-file-size": {
                a = cmdLine.nextString(new String[0]);
                String v = a.getStringValue();
                if (!enabled) break;
                logConfig.setLogFileSize(Integer.parseInt(v));
                break;
            }
            case "--log-file-count": {
                a = cmdLine.nextString(new String[0]);
                if (!enabled) break;
                logConfig.setLogFileCount(a.getArgumentValue().getInt());
                break;
            }
            case "--log-file-name": {
                a = cmdLine.nextString(new String[0]);
                String v = a.getStringValue();
                if (!enabled) break;
                logConfig.setLogFileName(v);
                break;
            }
            case "--log-file-base": {
                a = cmdLine.nextString(new String[0]);
                String v = a.getStringValue();
                if (!enabled) break;
                logConfig.setLogFileBase(v);
                break;
            }
            case "--log-inherited": {
                cmdLine.skip();
                if (!enabled) break;
                logConfig.setLogInherited(true);
                break;
            }
            case "--log-file-verbose": 
            case "--log-file-finest": 
            case "--log-file-finer": 
            case "--log-file-fine": 
            case "--log-file-info": 
            case "--log-file-warning": 
            case "--log-file-config": 
            case "--log-file-severe": 
            case "--log-file-all": 
            case "--log-file-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getStringKey();
                logConfig.setLogFileLevel(CoreNutsArgumentsParser.parseLevel(id.substring("--log-file-".length()), session));
                break;
            }
            case "--log-term-verbose": 
            case "--log-term-finest": 
            case "--log-term-finer": 
            case "--log-term-fine": 
            case "--log-term-info": 
            case "--log-term-warning": 
            case "--log-term-config": 
            case "--log-term-severe": 
            case "--log-term-all": 
            case "--log-term-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getStringKey();
                logConfig.setLogTermLevel(CoreNutsArgumentsParser.parseLevel(id.substring("--log-term-".length()), session));
                break;
            }
            case "--verbose": {
                cmdLine.skip();
                if (!enabled || !a.getArgumentValue().getBoolean(Boolean.valueOf(true)).booleanValue()) break;
                logConfig.setLogTermLevel(Level.FINEST);
                logConfig.setLogFileLevel(Level.FINEST);
                break;
            }
            case "--log-verbose": 
            case "--log-finest": 
            case "--log-finer": 
            case "--log-fine": 
            case "--log-info": 
            case "--log-warning": 
            case "--log-config": 
            case "--log-severe": 
            case "--log-all": 
            case "--log-off": {
                cmdLine.skip();
                if (!enabled) break;
                String id = a.getStringKey();
                Level lvl = CoreNutsArgumentsParser.parseLevel(id.substring("--log-".length()), session);
                logConfig.setLogTermLevel(lvl);
                logConfig.setLogFileLevel(lvl);
            }
        }
    }

    private static NutsStoreLocationStrategy parseNutsStoreLocationStrategy(String s, NutsSession ws) {
        String s0 = s;
        if (s == null || s.isEmpty()) {
            return null;
        }
        switch (s = s.toUpperCase().replace('-', '_')) {
            case "S": 
            case "STANDALONE": {
                return NutsStoreLocationStrategy.STANDALONE;
            }
            case "E": 
            case "EXPLODED": {
                return NutsStoreLocationStrategy.EXPLODED;
            }
        }
        throw new NutsIllegalArgumentException(ws, NutsMessage.cstyle((String)"unable to parse value for NutsStoreLocationStrategy : %s", (Object[])new Object[]{s0}));
    }

    private static NutsOsFamily parseNutsStoreLocationLayout(String s, NutsSession ws) {
        String s0 = s;
        if (s == null || s.isEmpty()) {
            return null;
        }
        switch (s = s.toUpperCase().replace('-', '_')) {
            case "L": 
            case "LINUX": {
                return NutsOsFamily.LINUX;
            }
            case "U": 
            case "UNIX": {
                return NutsOsFamily.UNIX;
            }
            case "X": 
            case "UNKNOWN": {
                return NutsOsFamily.UNKNOWN;
            }
            case "W": 
            case "WINDOWS": {
                return NutsOsFamily.WINDOWS;
            }
            case "M": 
            case "MACOS": {
                return NutsOsFamily.MACOS;
            }
            case "S": 
            case "SYSTEM": {
                return null;
            }
        }
        throw new NutsIllegalArgumentException(ws, NutsMessage.cstyle((String)"unable to parse value for NutsStoreLocationLayout : %s", (Object[])new Object[]{s0}));
    }

    private static NutsTerminalMode parseNutsTerminalMode(String s, NutsSession ws) {
        String s0 = s;
        if (s == null || s.isEmpty()) {
            return null;
        }
        switch (s = s.toUpperCase().replace('-', '_')) {
            case "L": 
            case "FILTERED": {
                return NutsTerminalMode.FILTERED;
            }
            case "F": 
            case "FORMATTED": {
                return NutsTerminalMode.FORMATTED;
            }
            case "H": 
            case "INHERITED": {
                return NutsTerminalMode.INHERITED;
            }
        }
        throw new NutsIllegalArgumentException(ws, NutsMessage.cstyle((String)"unable to parse value for NutsTerminalMode : %s", (Object[])new Object[]{s0}));
    }

    private static NutsOpenMode parseNutsWorkspaceOpenMode(String s, NutsSession ws) {
        String s0 = s;
        if (s == null || s.isEmpty()) {
            return null;
        }
        switch (s = s.toUpperCase().replace('-', '_').replace('/', '_')) {
            case "R": 
            case "READ": 
            case "O": 
            case "OE": 
            case "O_E": 
            case "OPEN": 
            case "OPEN_ERROR": 
            case "OPEN_OR_ERROR": {
                return NutsOpenMode.OPEN_OR_ERROR;
            }
            case "W": 
            case "WRITE": 
            case "C": 
            case "CE": 
            case "C_E": 
            case "CREATE": 
            case "CREATE_ERROR": 
            case "CREATE_OR_ERROR": {
                return NutsOpenMode.CREATE_OR_ERROR;
            }
            case "RW": 
            case "R_W": 
            case "READ_WRITE": 
            case "OC": 
            case "O_C": 
            case "OPEN_CREATE": 
            case "OPEN_OR_CREATE": {
                return NutsOpenMode.OPEN_OR_CREATE;
            }
            case "ON": 
            case "O_N": 
            case "OPEN_NULL": 
            case "OPEN_OR_NULL": {
                return NutsOpenMode.OPEN_OR_NULL;
            }
        }
        throw new NutsIllegalArgumentException(ws, NutsMessage.cstyle((String)"unable to parse value for NutsOpenMode : %s", (Object[])new Object[]{s0}));
    }

    private static Level parseLevel(String s, NutsSession ws) {
        switch (s.trim().toLowerCase()) {
            case "off": {
                return Level.OFF;
            }
            case "verbose": 
            case "finest": {
                return Level.FINEST;
            }
            case "finer": {
                return Level.FINER;
            }
            case "fine": {
                return Level.FINE;
            }
            case "info": {
                return Level.INFO;
            }
            case "all": {
                return Level.ALL;
            }
            case "warning": {
                return Level.WARNING;
            }
            case "severe": {
                return Level.SEVERE;
            }
            case "config": {
                return Level.CONFIG;
            }
        }
        return Level.INFO;
    }
}

