/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Level;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallListener;
import net.thevpc.nuts.NutsIterableFormat;
import net.thevpc.nuts.NutsListener;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMapListener;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.core.format.elem.DefaultNutsArrayElementBuilder;
import net.thevpc.nuts.runtime.core.sessionaware.NutsWorkspaceSessionAwareImpl;
import net.thevpc.nuts.runtime.core.terminals.AbstractNutsSessionTerminal;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsPropertiesHolder;

public class DefaultNutsSession
implements Cloneable,
NutsSession {
    protected NutsWorkspace ws = null;
    protected List<String> outputFormatOptions = new ArrayList<String>();
    private NutsSessionTerminal terminal;
    private NutsPropertiesHolder properties = new NutsPropertiesHolder();
    private Map<Class, LinkedHashSet<NutsListener>> listeners = new HashMap<Class, LinkedHashSet<NutsListener>>();
    private Boolean trace;
    private Boolean bot;
    private Boolean debug;
    private NutsRunAs runAs;
    private NutsExecutionType executionType;
    private Boolean dry;
    private Level logTermLevel;
    private Filter logTermFilter;
    private Level logFileLevel;
    private Filter logFileFilter;
    private NutsConfirmationMode confirm = null;
    private NutsContentType outputFormat;
    private NutsArrayElementBuilder eout;
    private NutsFetchStrategy fetchStrategy = null;
    private Boolean cached;
    private Boolean indexed;
    private Boolean transitive;
    private Boolean gui;
    private String progressOptions;
    private String errLinePrefix;
    private String outLinePrefix;
    private Instant expireTime;
    private NutsId appId;
    private String locale;
    private boolean iterableOut;

    public DefaultNutsSession(NutsWorkspace ws) {
        this.ws = new NutsWorkspaceSessionAwareImpl(this, ws);
        this.copyFrom(this.ws.env().getBootOptions());
    }

    public DefaultNutsSession(NutsWorkspace ws, NutsWorkspaceOptions options) {
        this.ws = new NutsWorkspaceSessionAwareImpl(this, ws);
        this.copyFrom(options);
    }

    public Object configure(boolean skipUnsupported, String ... args) {
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this, skipUnsupported, args, "nuts-session");
    }

    public final boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this, skipUnsupported, commandLine);
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a != null) {
            boolean enabled = a.isEnabled();
            switch (a.getStringKey()) {
                case "-T": 
                case "--output-format-option": {
                    a = cmdLine.nextString(new String[0]);
                    if (enabled) {
                        this.addOutputFormatOptions(a.getStringValue(""));
                    }
                    return true;
                }
                case "-O": 
                case "--output-format": {
                    a = cmdLine.nextString(new String[0]);
                    if (!enabled) break;
                    String t = a.getStringValue("");
                    int i = CoreStringUtils.firstIndexOf(t, new char[]{' ', ';', ':', '='});
                    if (i > 0) {
                        this.setOutputFormat(NutsContentType.valueOf((String)t.substring(0, i).toUpperCase()));
                        this.addOutputFormatOptions(t.substring(i + 1).toUpperCase());
                        break;
                    }
                    this.setOutputFormat(NutsContentType.valueOf((String)t.toUpperCase()));
                    break;
                }
                case "--tson": {
                    a = cmdLine.next();
                    if (!enabled) break;
                    this.setOutputFormat(NutsContentType.TSON);
                    if (a.getStringValue() == null) break;
                    this.addOutputFormatOptions(a.getStringValue());
                    break;
                }
                case "--yaml": {
                    a = cmdLine.next();
                    if (!enabled) break;
                    this.setOutputFormat(NutsContentType.YAML);
                    if (a.getStringValue() == null) break;
                    this.addOutputFormatOptions(a.getStringValue());
                    break;
                }
                case "--json": {
                    a = cmdLine.next();
                    if (enabled) {
                        this.setOutputFormat(NutsContentType.JSON);
                        if (a.getStringValue() != null) {
                            this.addOutputFormatOptions(a.getStringValue());
                        }
                    }
                    return true;
                }
                case "--props": {
                    a = cmdLine.next();
                    if (enabled) {
                        this.setOutputFormat(NutsContentType.PROPS);
                        if (a.getStringValue() != null) {
                            this.addOutputFormatOptions(a.getStringValue());
                        }
                    }
                    return true;
                }
                case "--plain": {
                    a = cmdLine.next();
                    if (enabled) {
                        this.setOutputFormat(NutsContentType.PLAIN);
                        if (a.getStringValue() != null) {
                            this.addOutputFormatOptions(a.getStringValue());
                        }
                    }
                    return true;
                }
                case "--table": {
                    a = cmdLine.next();
                    if (enabled) {
                        this.setOutputFormat(NutsContentType.TABLE);
                        if (a.getStringValue() != null) {
                            this.addOutputFormatOptions(a.getStringValue());
                        }
                    }
                    return true;
                }
                case "--tree": {
                    a = cmdLine.next();
                    if (enabled) {
                        this.setOutputFormat(NutsContentType.TREE);
                        if (a.getStringValue() != null) {
                            this.addOutputFormatOptions(a.getStringValue());
                        }
                    }
                    return true;
                }
                case "--xml": {
                    a = cmdLine.next();
                    if (enabled) {
                        this.setOutputFormat(NutsContentType.XML);
                        if (a.getStringValue() != null) {
                            this.addOutputFormatOptions(a.getStringValue());
                        }
                    }
                    return true;
                }
                case "-y": 
                case "--yes": {
                    if (enabled) {
                        this.setConfirm(NutsConfirmationMode.YES);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "--ask": {
                    if (enabled) {
                        this.setConfirm(NutsConfirmationMode.ASK);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "-n": 
                case "--no": {
                    if (enabled) {
                        this.setConfirm(NutsConfirmationMode.NO);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "--error": {
                    if (enabled) {
                        this.setConfirm(NutsConfirmationMode.ERROR);
                    }
                    cmdLine.skip();
                    return true;
                }
                case "--trace": {
                    NutsArgument v = cmdLine.nextBoolean(new String[0]);
                    if (enabled) {
                        this.setTrace(v.getBooleanValue());
                    }
                    return true;
                }
                case "--progress": {
                    NutsArgument v = cmdLine.nextString(new String[0]);
                    if (enabled) {
                        this.setProgressOptions(v.getStringValue());
                    }
                    return true;
                }
                case "--no-progress": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled && a.getBooleanValue()) {
                        this.setProgressOptions("none");
                    }
                    return true;
                }
                case "-f": 
                case "--fetch": {
                    a = cmdLine.nextString(new String[0]);
                    if (enabled) {
                        this.setFetchStrategy(NutsFetchStrategy.valueOf((String)a.getStringValue("").toUpperCase().replace("-", "_")));
                    }
                    return true;
                }
                case "-a": 
                case "--anywhere": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled && a.getBooleanValue()) {
                        this.setFetchStrategy(NutsFetchStrategy.ANYWHERE);
                    }
                    return true;
                }
                case "-F": 
                case "--offline": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled && a.getBooleanValue()) {
                        this.setFetchStrategy(NutsFetchStrategy.OFFLINE);
                    }
                    return true;
                }
                case "--online": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled && a.getBooleanValue()) {
                        this.setFetchStrategy(NutsFetchStrategy.ONLINE);
                    }
                    return true;
                }
                case "--remote": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled && a.getBooleanValue()) {
                        this.setFetchStrategy(NutsFetchStrategy.REMOTE);
                    }
                    return true;
                }
                case "-c": 
                case "--color": {
                    a = cmdLine.next();
                    if (enabled) {
                        String v = a.getStringValue("");
                        if (v.isEmpty()) {
                            this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FORMATTED));
                            this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FORMATTED));
                        } else {
                            NutsArgument bb = this.ws.commandLine().createArgument(v);
                            Boolean b = bb.getBoolean(null);
                            if (b != null) {
                                if (b.booleanValue()) {
                                    this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FORMATTED));
                                    this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FORMATTED));
                                } else {
                                    this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FILTERED));
                                    this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FILTERED));
                                }
                            } else {
                                switch (v.toLowerCase()) {
                                    case "formatted": {
                                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FORMATTED));
                                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FORMATTED));
                                        break;
                                    }
                                    case "filtered": {
                                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FILTERED));
                                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FILTERED));
                                        break;
                                    }
                                    case "h": 
                                    case "inherited": {
                                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.INHERITED));
                                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.INHERITED));
                                        break;
                                    }
                                    case "s": 
                                    case "auto": 
                                    case "system": {
                                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.INHERITED));
                                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.INHERITED));
                                        break;
                                    }
                                    default: {
                                        cmdLine.pushBack(a);
                                        cmdLine.unexpectedArgument();
                                    }
                                }
                            }
                        }
                    }
                    return true;
                }
                case "-C": 
                case "--no-color": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled) {
                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FILTERED));
                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FILTERED));
                    }
                    return true;
                }
                case "-B": 
                case "--bot": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled && a.getBooleanValue()) {
                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FILTERED));
                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FILTERED));
                        this.setProgressOptions("none");
                        this.setConfirm(NutsConfirmationMode.ERROR);
                        this.setTrace(false);
                        this.setGui(false);
                    }
                    return true;
                }
                case "--dry": 
                case "-D": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (enabled) {
                        this.setDry(a.getBooleanValue());
                    }
                    return true;
                }
                case "--out-line-prefix": {
                    a = cmdLine.nextString(new String[0]);
                    if (enabled) {
                        this.setOutLinePrefix(a.getStringValue());
                    }
                    return true;
                }
                case "--err-line-prefix": {
                    a = cmdLine.nextString(new String[0]);
                    if (enabled) {
                        this.setErrLinePrefix(a.getStringValue());
                    }
                    return true;
                }
                case "--line-prefix": {
                    a = cmdLine.nextString(new String[0]);
                    if (enabled) {
                        this.setOutLinePrefix(a.getStringValue());
                        this.setErrLinePrefix(a.getStringValue());
                    }
                    return true;
                }
                case "--embedded": 
                case "-b": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (!enabled || !a.getBooleanValue()) break;
                    this.setExecutionType(NutsExecutionType.EMBEDDED);
                    break;
                }
                case "--external": 
                case "--spawn": 
                case "-x": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (!enabled || !a.getBooleanValue()) break;
                    this.setExecutionType(NutsExecutionType.SPAWN);
                    break;
                }
                case "--system": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (!enabled || !a.getBooleanValue()) break;
                    this.setExecutionType(NutsExecutionType.SYSTEM);
                    break;
                }
                case "--current-user": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (!enabled || !a.getBooleanValue()) break;
                    this.setRunAs(NutsRunAs.currentUser());
                    break;
                }
                case "--as-root": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (!enabled || !a.getBooleanValue()) break;
                    this.setRunAs(NutsRunAs.root());
                    break;
                }
                case "--sudo": {
                    a = cmdLine.nextBoolean(new String[0]);
                    if (!enabled || !a.getBooleanValue()) break;
                    this.setRunAs(NutsRunAs.sudo());
                    break;
                }
                case "--as-user": {
                    a = cmdLine.nextString(new String[0]);
                    if (!enabled) break;
                    this.setRunAs(NutsRunAs.user((String)a.getStringValue()));
                }
            }
        }
        return false;
    }

    public NutsContentType getPreferredOutputFormat() {
        return this.outputFormat;
    }

    public boolean isTrace() {
        boolean b = this.isBot();
        if (b) {
            return false;
        }
        return this.trace != null ? this.trace.booleanValue() : this.ws.env().getBootOptions().isTrace();
    }

    public NutsSession setTrace(Boolean trace) {
        this.trace = trace;
        return this;
    }

    public boolean isPlainTrace() {
        return this.isTrace() && !this.isIterableOut() && this.getOutputFormat() == NutsContentType.PLAIN;
    }

    public boolean isIterableTrace() {
        return this.isTrace() && this.isIterableOut();
    }

    public boolean isStructuredTrace() {
        return this.isTrace() && !this.isIterableOut() && (this.isBot() || this.getOutputFormat() != NutsContentType.PLAIN);
    }

    public boolean isIterableOut() {
        return this.iterableOut;
    }

    public NutsSession setIterableOut(boolean iterableOut) {
        this.iterableOut = iterableOut;
        return this;
    }

    public boolean isStructuredOut() {
        return !this.isIterableOut() && (this.isBot() || this.getOutputFormat() != NutsContentType.PLAIN);
    }

    public NutsArrayElementBuilder getElemOut() {
        return this.eout;
    }

    public NutsSession setElemOut(NutsArrayElementBuilder eout) {
        this.eout = eout;
        return this;
    }

    public boolean isPlainOut() {
        return !this.isBot() && this.getOutputFormat() == NutsContentType.PLAIN;
    }

    public boolean isBot() {
        if (this.bot != null) {
            return this.bot;
        }
        return this.ws.env().getBootOptions().isBot();
    }

    public Boolean getBot() {
        return this.bot;
    }

    public NutsSession setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    public boolean isYes() {
        return this.getConfirm() == NutsConfirmationMode.YES;
    }

    public boolean isNo() {
        return this.getConfirm() == NutsConfirmationMode.NO;
    }

    public boolean isAsk() {
        return this.getConfirm() == NutsConfirmationMode.ASK;
    }

    public NutsContentType getOutputFormat(NutsContentType defaultValue) {
        if (this.outputFormat != null) {
            return this.outputFormat;
        }
        NutsContentType o = this.ws.env().getBootOptions().getOutputFormat();
        if (o != null) {
            return o;
        }
        return defaultValue;
    }

    public NutsContentType getOutputFormat() {
        return this.getOutputFormat(NutsContentType.PLAIN);
    }

    public NutsSession setOutputFormat(NutsContentType outputFormat) {
        if (outputFormat == null) {
            outputFormat = NutsContentType.PLAIN;
        }
        this.outputFormat = outputFormat;
        return this;
    }

    public NutsSession json() {
        return this.setOutputFormat(NutsContentType.JSON);
    }

    public NutsSession plain() {
        return this.setOutputFormat(NutsContentType.PLAIN);
    }

    public NutsSession props() {
        return this.setOutputFormat(NutsContentType.PROPS);
    }

    public NutsSession tree() {
        return this.setOutputFormat(NutsContentType.TREE);
    }

    public NutsSession table() {
        return this.setOutputFormat(NutsContentType.TABLE);
    }

    public NutsSession xml() {
        return this.setOutputFormat(NutsContentType.XML);
    }

    public NutsSession copy() {
        try {
            DefaultNutsSession cloned = (DefaultNutsSession)this.clone();
            cloned.ws = new NutsWorkspaceSessionAwareImpl(cloned, this.ws);
            cloned.terminal = this.terminal == null ? null : cloned.ws.term().createTerminal(this.terminal);
            cloned.properties = this.properties == null ? null : this.properties.copy();
            cloned.outputFormatOptions = this.outputFormatOptions == null ? null : new ArrayList<String>(this.outputFormatOptions);
            cloned.listeners = null;
            if (this.listeners != null) {
                for (NutsListener listener : this.getListeners()) {
                    cloned.addListener(listener);
                }
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new NutsUnsupportedOperationException((NutsSession)this, NutsMessage.cstyle((String)"clone failed for type %s", (Object[])new Object[]{this.getClass().getName()}), (Throwable)e);
        }
    }

    public NutsSession copyFrom(NutsSession other) {
        this.terminal = other.getTerminal();
        Map properties = other.getProperties();
        this.properties.setProperties(properties == null ? null : new LinkedHashMap(properties));
        this.listeners.clear();
        for (NutsListener listener : other.getListeners()) {
            this.addListener(listener);
        }
        this.trace = other.isTrace();
        this.confirm = other.getConfirm();
        this.dry = other.isDry();
        this.gui = other.isGui();
        this.errLinePrefix = other.getErrLinePrefix();
        this.outLinePrefix = other.getOutLinePrefix();
        this.fetchStrategy = other.getFetchStrategy();
        this.fetchStrategy = other.getFetchStrategy();
        this.cached = other.isCached();
        this.indexed = other.isIndexed();
        this.transitive = other.isTransitive();
        this.outputFormat = other instanceof DefaultNutsSession ? ((DefaultNutsSession)other).getPreferredOutputFormat() : other.getOutputFormat();
        this.iterableOut = other.isIterableOut();
        this.outputFormatOptions.clear();
        this.outputFormatOptions.addAll(Arrays.asList(other.getOutputFormatOptions()));
        this.progressOptions = other.getProgressOptions();
        this.logTermLevel = other.getLogTermLevel();
        this.logTermFilter = other.getLogTermFilter();
        this.logFileLevel = other.getLogFileLevel();
        this.logFileFilter = other.getLogFileFilter();
        this.eout = other.eout();
        this.appId = other.getAppId();
        return this;
    }

    public NutsSession copyFrom(NutsWorkspaceOptions options) {
        if (options != null) {
            this.trace = options.isTrace();
            this.debug = options.isDebug();
            this.progressOptions = options.getProgressOptions();
            this.dry = options.isDry();
            this.cached = options.isCached();
            this.indexed = options.isIndexed();
            this.gui = options.isGui();
            this.confirm = options.getConfirm();
            this.errLinePrefix = options.getErrLinePrefix();
            this.outLinePrefix = options.getOutLinePrefix();
            this.fetchStrategy = options.getFetchStrategy();
            this.outputFormat = options.getOutputFormat();
            this.outputFormatOptions.clear();
            this.outputFormatOptions.addAll(Arrays.asList(options.getOutputFormatOptions()));
            this.outputFormatOptions.addAll(Arrays.asList(options.getOutputFormatOptions()));
            NutsLogConfig logConfig = options.getLogConfig();
            if (logConfig != null) {
                this.logTermLevel = logConfig.getLogTermLevel();
                this.logTermFilter = logConfig.getLogTermFilter();
                this.logFileLevel = logConfig.getLogFileLevel();
                this.logFileFilter = logConfig.getLogFileFilter();
            }
        }
        return this;
    }

    public NutsId getAppId() {
        return this.appId;
    }

    public NutsSession setAppId(NutsId appId) {
        this.appId = appId;
        return this;
    }

    public NutsFetchStrategy getFetchStrategy() {
        if (this.fetchStrategy != null) {
            return this.fetchStrategy;
        }
        NutsFetchStrategy wfetchStrategy = this.ws.env().getBootOptions().getFetchStrategy();
        if (wfetchStrategy != null) {
            return wfetchStrategy;
        }
        return NutsFetchStrategy.ONLINE;
    }

    public NutsSession setFetchStrategy(NutsFetchStrategy mode) {
        this.fetchStrategy = mode;
        return this;
    }

    public NutsSession addListener(NutsListener listener) {
        if (listener != null) {
            boolean ok = false;
            for (Class cls : new Class[]{NutsWorkspaceListener.class, NutsRepositoryListener.class, NutsInstallListener.class, NutsMapListener.class}) {
                LinkedHashSet<Object> li;
                if (!cls.isInstance(listener)) continue;
                if (this.listeners == null) {
                    this.listeners = new HashMap<Class, LinkedHashSet<NutsListener>>();
                }
                if ((li = this.listeners.get(cls)) == null) {
                    li = new LinkedHashSet();
                    this.listeners.put(cls, li);
                }
                li.add(listener);
                ok = true;
            }
            if (!ok) {
                throw new NutsIllegalArgumentException((NutsSession)this, NutsMessage.cstyle((String)"unsupported Listener %s : %s", (Object[])new Object[]{listener.getClass().getName(), listener}));
            }
        }
        return this;
    }

    public NutsSession removeListener(NutsListener listener) {
        if (listener != null && this.listeners != null) {
            for (LinkedHashSet<NutsListener> value : this.listeners.values()) {
                value.remove(listener);
            }
        }
        return this;
    }

    public <T extends NutsListener> T[] getListeners(Class<T> type) {
        LinkedHashSet<NutsListener> tt;
        if (this.listeners != null && (tt = this.listeners.get(type)) != null) {
            return tt.toArray((NutsListener[])Array.newInstance(type, 0));
        }
        return (NutsListener[])Array.newInstance(type, 0);
    }

    public NutsListener[] getListeners() {
        if (this.listeners == null) {
            return new NutsListener[0];
        }
        LinkedHashSet<NutsListener> all = new LinkedHashSet<NutsListener>();
        for (LinkedHashSet<NutsListener> value : this.listeners.values()) {
            all.addAll(value);
        }
        return all.toArray(new NutsListener[0]);
    }

    public NutsSession setProperty(String key, Object value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties.getProperties();
    }

    public NutsSession setProperties(Map<String, Object> properties) {
        this.properties.setProperties(properties);
        return this;
    }

    public Object getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public NutsConfirmationMode getConfirm() {
        NutsConfirmationMode cm;
        NutsConfirmationMode nutsConfirmationMode = cm = this.confirm != null ? this.confirm : this.ws.env().getBootOptions().getConfirm();
        if (this.isBot()) {
            if (cm == null) {
                return NutsConfirmationMode.ERROR;
            }
            switch (cm) {
                case ASK: {
                    return NutsConfirmationMode.ERROR;
                }
            }
            return cm;
        }
        return cm == null ? NutsConfirmationMode.ASK : cm;
    }

    public NutsSession setConfirm(NutsConfirmationMode confirm) {
        this.confirm = confirm;
        return this;
    }

    public NutsSession addOutputFormatOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                if (NutsUtilStrings.isBlank((CharSequence)option)) continue;
                this.outputFormatOptions.add(option);
            }
        }
        return this;
    }

    public String[] getOutputFormatOptions() {
        return this.outputFormatOptions.toArray(new String[0]);
    }

    public NutsSession setOutputFormatOptions(String ... options) {
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options);
    }

    public NutsPrintStream out() {
        return this.terminal.out();
    }

    public InputStream in() {
        return this.terminal.in();
    }

    public NutsPrintStream err() {
        return this.terminal.err();
    }

    public NutsIterableFormat getIterableOutput() {
        if (!this.iterableOut) {
            return null;
        }
        return this.getWorkspace().elem().setContentType(this.getOutputFormat()).iter(this.out());
    }

    public NutsSessionTerminal getTerminal() {
        return this.terminal;
    }

    public NutsSession setTerminal(NutsSessionTerminal terminal) {
        AbstractNutsSessionTerminal a;
        this.terminal = terminal;
        if (terminal != null && (a = (AbstractNutsSessionTerminal)terminal).getSession() != this) {
            throw new NutsIllegalArgumentException((NutsSession)this, NutsMessage.cstyle((String)"session mismatch", (Object[])new Object[0]));
        }
        return this;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public boolean isTransitive() {
        if (this.transitive != null) {
            return this.transitive;
        }
        return this.ws.env().getBootOptions().isTransitive();
    }

    public NutsSession setTransitive(Boolean value) {
        this.transitive = value;
        return this;
    }

    public boolean isCached() {
        if (this.cached != null) {
            return this.cached;
        }
        return this.ws.env().getBootOptions().isCached();
    }

    public NutsSession setCached(Boolean value) {
        this.cached = value;
        return this;
    }

    public boolean isIndexed() {
        if (this.indexed != null) {
            return this.indexed;
        }
        return this.ws.env().getBootOptions().isIndexed();
    }

    public NutsSession setIndexed(Boolean value) {
        this.indexed = value;
        return this;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public NutsSession setExpireTime(Instant expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public String getProgressOptions() {
        return this.progressOptions;
    }

    public NutsSession setProgressOptions(String progressOptions) {
        this.progressOptions = progressOptions;
        return this;
    }

    public boolean isGui() {
        if (this.gui != null) {
            return this.gui;
        }
        return this.ws.env().getBootOptions().isGui();
    }

    public NutsSession setGui(Boolean gui) {
        this.gui = gui;
        return this;
    }

    public String getErrLinePrefix() {
        return this.errLinePrefix;
    }

    public NutsSession setErrLinePrefix(String errLinePrefix) {
        this.errLinePrefix = errLinePrefix;
        return this;
    }

    public String getOutLinePrefix() {
        return this.outLinePrefix;
    }

    public NutsSession setOutLinePrefix(String outLinePrefix) {
        this.outLinePrefix = outLinePrefix;
        return this;
    }

    public boolean isDry() {
        if (this.dry == null) {
            return this.ws.env().getBootOptions().isDry();
        }
        return this.dry;
    }

    public NutsSession setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    public Level getLogTermLevel() {
        return this.logTermLevel;
    }

    public NutsSession setLogLevel(Level level) {
        this.logTermLevel = level;
        return this;
    }

    public Filter getLogTermFilter() {
        return this.logTermFilter;
    }

    public NutsSession setLogFilter(Filter filter) {
        this.logTermFilter = filter;
        return this;
    }

    public NutsSession configure(NutsWorkspaceOptions options) {
        if (options != null) {
            if (options.getCached() != null) {
                this.setCached(options.isCached());
            }
            if (options.getConfirm() != null) {
                this.setConfirm(options.getConfirm());
            }
            if (options.getDry() != null) {
                this.setDry(options.getDry());
            }
            if (options.getOutputFormat() != null) {
                this.setOutputFormat(options.getOutputFormat());
            }
            if (options.getOutputFormatOptions() != null) {
                this.setOutputFormatOptions(options.getOutputFormatOptions());
            }
            if (options.getErrLinePrefix() != null) {
                this.setErrLinePrefix(options.getErrLinePrefix());
            }
            if (options.getFetchStrategy() != null) {
                this.setFetchStrategy(options.getFetchStrategy());
            }
            if (options.getExpireTime() != null) {
                this.setExpireTime(options.getExpireTime());
            }
            if (options.getGui() != null) {
                this.setGui(options.getGui());
            }
            if (options.getProgressOptions() != null) {
                this.setProgressOptions(options.getProgressOptions());
            }
            if (options.getIndexed() != null) {
                this.setIndexed(options.getIndexed());
            }
            if (options.getTrace() != null) {
                this.setTrace(options.getTrace());
            }
            if (options.getBot() != null) {
                boolean wasBot = this.isBot();
                this.setBot(options.getBot());
                boolean becomesBot = this.isBot();
                if (!wasBot && becomesBot) {
                    if (this.getTerminal().out().mode() != NutsTerminalMode.FORMATTED) {
                        this.getTerminal().setOut(this.getTerminal().out().convertMode(NutsTerminalMode.FILTERED));
                    }
                    if (this.getTerminal().err().mode() != NutsTerminalMode.FORMATTED) {
                        this.getTerminal().setErr(this.getTerminal().err().convertMode(NutsTerminalMode.FILTERED));
                    }
                }
            }
            if (options.getTransitive() != null) {
                this.setTransitive(options.getTransitive());
            }
            if (options.getTerminalMode() != null) {
                this.getTerminal().setOut(this.getTerminal().getOut().convertMode(options.getTerminalMode()));
            }
            if (options.getExecutionType() != null) {
                this.setExecutionType(options.getExecutionType());
            }
        }
        return this;
    }

    public Level getLogFileLevel() {
        return this.logFileLevel;
    }

    public NutsSession setLogFileLevel(Level logFileLevel) {
        this.logFileLevel = logFileLevel;
        return this;
    }

    public Filter getLogFileFilter() {
        return this.logFileFilter;
    }

    public NutsSession setLogFileFilter(Filter logFileFilter) {
        this.logFileFilter = logFileFilter;
        return this;
    }

    public NutsArrayElementBuilder eout() {
        if (this.eout == null) {
            this.eout = new DefaultNutsArrayElementBuilder(this);
        }
        return this.eout;
    }

    public NutsSession flush() {
        NutsArrayElementBuilder e = this.eout();
        if (e.size() > 0) {
            this.getWorkspace().formats().object((Object)e.build()).println();
            e.clear();
        }
        this.out().flush();
        return this;
    }

    public NutsExecutionType getExecutionType() {
        if (this.executionType != null) {
            return this.executionType;
        }
        return this.ws.env().getBootOptions().getExecutionType();
    }

    public NutsSession setExecutionType(NutsExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public boolean isDebug() {
        if (this.debug == null) {
            return this.ws.env().getBootOptions().isDebug();
        }
        return this.debug;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public NutsSession setDebug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    public String getLocale() {
        if (this.locale == null) {
            return this.ws.env().getBootOptions().getLocale();
        }
        return this.locale;
    }

    public NutsSession setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public NutsRunAs getRunAs() {
        if (this.runAs != null) {
            return this.runAs;
        }
        NutsRunAs r = this.ws.env().getBootOptions().getRunAs();
        if (r != null) {
            return r;
        }
        return NutsRunAs.currentUser();
    }

    public NutsSession setRunAs(NutsRunAs runAs) {
        this.runAs = runAs;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NutsSession(");
        if (this.properties.size() > 0) {
            sb.append("properties=").append(this.properties);
        }
        sb.append(")");
        return sb.toString();
    }
}

