/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.parsers;

public class StringReaderExt {
    String content;
    int pos = 0;

    public StringReaderExt(String content) {
        this.content = content == null ? "" : content;
    }

    public char peekChar() {
        if (this.pos < 0 || this.pos >= this.content.length()) {
            throw new StringIndexOutOfBoundsException(this.pos);
        }
        return this.content.charAt(this.pos);
    }

    public char peekChar(int i) {
        return this.content.charAt(this.pos + i);
    }

    public boolean isAvailable(int count) {
        return this.pos + count < this.content.length();
    }

    public char nextChar() {
        char c = this.content.charAt(this.pos);
        ++this.pos;
        return c;
    }

    public String peekChars(int max) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < max && this.hasNext(i); ++i) {
            sb.append(this.peekChar(i));
        }
        return sb.toString();
    }

    public boolean readString(String s) {
        int max = s.length();
        String n = this.peekChars(max);
        if (n.equals(s)) {
            this.nextChars(max);
            return true;
        }
        return false;
    }

    public String nextChars(int max) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < max && this.hasNext(); ++i) {
            sb.append(this.nextChar());
        }
        return sb.toString();
    }

    public boolean hasNext(int count) {
        return this.content.length() - (this.pos + count) > 0;
    }

    public boolean hasNext() {
        return this.content.length() - this.pos > 0;
    }

    public boolean peekChars(int count, CharPosPredicate filter) {
        if (this.hasNext(count)) {
            for (int i = 0; i < count; ++i) {
                if (filter.test(this.peekChar(i), i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean peekChars(String s) {
        return this.peekChars(s.length()).equals(s);
    }

    public String toString() {
        return this.content.substring(this.pos);
    }

    public static interface CharPosPredicate {
        public boolean test(char var1, int var2);
    }
}

