/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.parsers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class StringMapParser {
    private String eqSeparators;
    private String entrySeparators;

    public StringMapParser(String eqSeparators, String entrySeparators) {
        this.eqSeparators = eqSeparators;
        this.entrySeparators = entrySeparators;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> parseMap(String text) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        StringReader reader = new StringReader(text == null ? "" : text);
        while (true) {
            StringBuilder key = new StringBuilder();
            int r = 0;
            try {
                r = StringMapParser.readToken(reader, this.eqSeparators + this.entrySeparators, key);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String t = key.toString();
            if (r == -1) {
                if (t.isEmpty()) return m;
                m.put(t, null);
                return m;
            }
            char c = (char)r;
            if (this.eqSeparators.indexOf(c) < 0) continue;
            StringBuilder value = new StringBuilder();
            try {
                r = StringMapParser.readToken(reader, this.entrySeparators, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            m.put(t, value.toString());
            if (r == -1) return m;
        }
    }

    private static int readToken(Reader reader, String stopTokens, StringBuilder result) throws IOException {
        int r;
        block5: while ((r = reader.read()) != -1) {
            if (r == 34 || r == 39) {
                char s = (char)r;
                block6: while (true) {
                    if ((r = reader.read()) == -1) {
                        throw new RuntimeException("Expected \"");
                    }
                    if (r == s) continue block5;
                    if (r == 92) {
                        r = reader.read();
                        if (r == -1) {
                            throw new RuntimeException("Expected \"");
                        }
                        switch ((char)r) {
                            case 'n': {
                                result.append('\n');
                                continue block6;
                            }
                            case 'r': {
                                result.append('\r');
                                continue block6;
                            }
                            case 'f': {
                                result.append('\f');
                                continue block6;
                            }
                        }
                        result.append((char)r);
                        continue;
                    }
                    char cr = (char)r;
                    result.append(cr);
                }
            }
            char cr = (char)r;
            if (stopTokens != null && stopTokens.indexOf(cr) >= 0) {
                return cr;
            }
            result.append(cr);
        }
        return -1;
    }
}

