/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.parsers;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Arrays;

public class StreamTokenizerExt {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_DOUBLE = -2;
    public static final int TT_WORD = -3;
    public static final int TT_INTEGER = -4;
    public static final int TT_COMMENTS = -5;
    public static final int TT_SPACES = -6;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int SKIP_LF = 0x7FFFFFFE;
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_COMMENT = 16;
    private static final int TT_NOTHING = -5;
    public int ttype = -5;
    public String sval;
    public String image;
    public double dval;
    public long ival;
    public boolean returnComments = true;
    public boolean returnSpaces = true;
    private Reader reader = null;
    private char[] buf = new char[20];
    private StringBuilder bufImage = new StringBuilder();
    private int peekc = Integer.MAX_VALUE;
    private boolean pushedBack;
    private boolean forceLower;
    private int LINENO = 1;
    private boolean eolIsSignificantP = false;
    private boolean slashSlashCommentsP = false;
    private boolean slashStarCommentsP = false;
    private boolean xmlCommentsP = false;
    private byte[] ctype = new byte[256];

    private StreamTokenizerExt() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.quoteChar(34);
        this.quoteChar(39);
        this.quoteChar(96);
        this.parseNumbers();
    }

    public StreamTokenizerExt(Reader r) {
        this();
        if (r == null) {
            throw new NullPointerException();
        }
        this.reader = r;
    }

    public void resetSyntax() {
        int i = this.ctype.length;
        while (--i >= 0) {
            this.ctype[i] = 0;
        }
    }

    public void wordChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            int n = low++;
            this.ctype[n] = (byte)(this.ctype[n] | 4);
        }
    }

    public void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    public void ordinaryChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 0;
        }
    }

    public void ordinaryChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 0;
        }
    }

    public void commentChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 16;
        }
    }

    public void quoteChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 8;
        }
    }

    public void parseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (byte)(this.ctype[n] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
        this.ctype[45] = (byte)(this.ctype[45] | 2);
    }

    public void doNotParseNumbers() {
        int i = 48;
        while (i <= 57) {
            int n = i++;
            this.ctype[n] = (byte)(this.ctype[n] & 0xFFFFFFFD);
        }
        this.ctype[46] = (byte)(this.ctype[46] & 0xFFFFFFFD);
        this.ctype[45] = (byte)(this.ctype[45] & 0xFFFFFFFD);
    }

    public void eolIsSignificant(boolean flag) {
        this.eolIsSignificantP = flag;
    }

    public void slashStarComments(boolean flag) {
        this.slashStarCommentsP = flag;
    }

    public void slashSlashComments(boolean flag) {
        this.slashSlashCommentsP = flag;
    }

    public StreamTokenizerExt xmlComments(boolean flag) {
        this.xmlCommentsP = flag;
        this.slashSlashComments(false);
        this.slashStarComments(false);
        return this;
    }

    public StreamTokenizerExt javaComments() {
        this.commentChar(47);
        this.slashSlashComments(true);
        this.slashStarComments(true);
        return this;
    }

    public StreamTokenizerExt pythonComments() {
        this.commentChar(35);
        this.slashSlashComments(false);
        this.slashStarComments(false);
        return this;
    }

    public void lowerCaseMode(boolean fl) {
        this.forceLower = fl;
    }

    private int read() {
        try {
            return this.reader.read();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void mark(int count) {
        try {
            this.reader.mark(count);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void reset() {
        try {
            this.reader.reset();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public int nextToken() {
        this.image = null;
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.ttype;
        }
        byte[] ct = this.ctype;
        this.sval = null;
        int c = this.peekc;
        if (c < 0) {
            c = Integer.MAX_VALUE;
        }
        if (c == 0x7FFFFFFE) {
            c = this.read();
            if (c < 0) {
                this.ttype = -1;
                return -1;
            }
            if (c == 10) {
                c = Integer.MAX_VALUE;
            }
        }
        if (c == Integer.MAX_VALUE && (c = this.read()) < 0) {
            this.ttype = -1;
            return -1;
        }
        this.ttype = c;
        this.peekc = Integer.MAX_VALUE;
        int ctype = c < 256 ? ct[c] : 4;
        this.bufImage.setLength(0);
        while ((ctype & 1) != 0) {
            this.bufImage.append((char)c);
            if (c == 13) {
                ++this.LINENO;
                if (this.eolIsSignificantP) {
                    this.peekc = 0x7FFFFFFE;
                    this.ttype = 10;
                    return 10;
                }
                c = this.read();
                if (c == 10) {
                    this.bufImage.append((char)c);
                    c = this.read();
                }
            } else {
                if (c == 10) {
                    ++this.LINENO;
                    if (this.eolIsSignificantP) {
                        this.ttype = 10;
                        return 10;
                    }
                }
                c = this.read();
            }
            if (this.bufImage.length() > 0 && this.returnSpaces) {
                this.peekc = c;
                this.image = this.bufImage.toString();
                this.ttype = -6;
                return -6;
            }
            if (c < 0) {
                this.ttype = -1;
                return -1;
            }
            ctype = c < 256 ? ct[c] : 4;
        }
        if ((ctype & 2) != 0) {
            StringBuilder image = new StringBuilder();
            image.append((char)c);
            boolean neg = false;
            boolean intType = true;
            if (c == 45) {
                c = this.read();
                image.append((char)c);
                if (c != 46 && (c < 48 || c > 57)) {
                    this.peekc = c;
                    this.ttype = 45;
                    return 45;
                }
                neg = true;
            }
            double dv = 0.0;
            long iv = 0L;
            int decexp = 0;
            int seendot = 0;
            boolean loop = true;
            if (c == 46 && seendot == 0) {
                seendot = 1;
                intType = false;
            } else if (48 <= c && c <= 57) {
                dv = dv * 10.0 + (double)(c - 48);
                iv = iv * 10L + (long)(c - 48);
                decexp += seendot;
            } else {
                loop = false;
            }
            if (loop) {
                c = this.read();
                while (true) {
                    if (c == 46 && seendot == 0) {
                        seendot = 1;
                        intType = false;
                        image.append((char)c);
                    } else {
                        if (48 > c || c > 57) break;
                        dv = dv * 10.0 + (double)(c - 48);
                        iv = iv * 10L + (long)(c - 48);
                        decexp += seendot;
                        image.append((char)c);
                    }
                    c = this.read();
                }
            }
            this.peekc = c;
            if (decexp != 0) {
                double denom = 10.0;
                --decexp;
                while (decexp > 0) {
                    denom *= 10.0;
                    --decexp;
                }
                dv /= denom;
            }
            this.dval = neg ? -dv : dv;
            this.image = image.toString();
            if (intType) {
                this.ival = neg ? -iv : iv;
                this.ttype = -4;
                return -4;
            }
            this.ttype = -2;
            return -2;
        }
        if ((ctype & 4) != 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)c;
            } while (((ctype = (c = this.read()) < 0 ? 1 : (c < 256 ? ct[c] : 4)) & 6) != 0);
            this.peekc = c;
            this.image = this.sval = String.copyValueOf(this.buf, 0, i);
            if (this.forceLower) {
                this.sval = this.sval.toLowerCase();
            }
            this.ttype = -3;
            return -3;
        }
        if ((ctype & 8) != 0) {
            this.ttype = c;
            this.bufImage.setLength(0);
            this.bufImage.append((char)c);
            int i = 0;
            int d = this.read();
            while (d >= 0 && d != this.ttype && d != 10 && d != 13) {
                this.bufImage.append((char)d);
                if (d == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        this.bufImage.append((char)d);
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            this.bufImage.append((char)d);
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            this.bufImage.append((char)d);
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                d = this.read();
                            } else {
                                d = c2;
                            }
                        } else {
                            d = c2;
                        }
                    } else {
                        this.bufImage.append((char)d);
                        switch (c) {
                            case 97: {
                                c = 7;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                            }
                        }
                        d = this.read();
                    }
                } else {
                    c = d;
                    d = this.read();
                }
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)c;
            }
            int n = this.peekc = d == this.ttype ? Integer.MAX_VALUE : d;
            if (d == this.ttype) {
                this.bufImage.append((char)d);
            }
            this.sval = String.copyValueOf(this.buf, 0, i);
            this.image = this.bufImage.toString();
            return this.ttype;
        }
        if (c == 47 && (this.slashSlashCommentsP || this.slashStarCommentsP)) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)c);
            c = this.read();
            if (c == 42 && this.slashStarCommentsP) {
                sb.append((char)c);
                int prevc = 0;
                while ((c = this.read()) != 47 || prevc != 42) {
                    if (c == 13) {
                        sb.append((char)c);
                        ++this.LINENO;
                        c = this.read();
                        if (c == 10) {
                            sb.append((char)c);
                            c = this.read();
                        }
                    } else if (c == 10) {
                        ++this.LINENO;
                        sb.append((char)c);
                        c = this.read();
                    }
                    if (c < 0) {
                        this.ttype = -1;
                        return -1;
                    }
                    prevc = c;
                }
                if (this.returnComments) {
                    this.image = sb.toString();
                    this.ttype = -5;
                    return -5;
                }
                return this.nextToken();
            }
            if (c == 47 && this.slashSlashCommentsP) {
                sb.append((char)c);
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                    sb.append((char)c);
                }
                this.peekc = c;
                if (this.returnComments) {
                    this.image = sb.toString();
                    this.ttype = -5;
                    return -5;
                }
                return this.nextToken();
            }
            if ((ct[47] & 0x10) != 0) {
                sb.append((char)c);
                while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                    sb.append((char)c);
                }
                if (this.returnComments) {
                    this.image = sb.toString();
                    this.ttype = -5;
                    return -5;
                }
                this.peekc = c;
                return this.nextToken();
            }
            this.peekc = c;
            this.ttype = 47;
            return 47;
        }
        if (c == 60 && this.xmlCommentsP) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)c);
            this.mark(4);
            int a = this.read();
            if (a == 33) {
                sb.append((char)c);
                a = this.read();
                if (a == 45) {
                    sb.append((char)c);
                    a = this.read();
                    if (a == 45) {
                        sb.append((char)c);
                        while (true) {
                            c = this.read();
                            boolean wasEnd = false;
                            if (c == 45) {
                                sb.append((char)c);
                                a = this.read();
                                if (a == 45 && (a = this.read()) == 62) {
                                    wasEnd = true;
                                }
                                if (wasEnd) break;
                                this.reset();
                                continue;
                            }
                            sb.append((char)c);
                        }
                        sb.append("->");
                        if (this.returnComments) {
                            this.image = sb.toString();
                            this.ttype = -5;
                            return -5;
                        }
                        return this.nextToken();
                    }
                }
            }
            this.reset();
            this.image = "<";
            this.ttype = 60;
            return 60;
        }
        if ((ctype & 0x10) != 0) {
            StringBuilder sb = new StringBuilder();
            while ((c = this.read()) != 10 && c != 13 && c >= 0) {
                sb.append((char)c);
            }
            this.peekc = c;
            return this.nextToken();
        }
        this.image = String.valueOf((char)c);
        this.ttype = c;
        return this.ttype;
    }

    public void pushBack() {
        if (this.ttype != -5) {
            this.pushedBack = true;
        }
    }

    public int lineno() {
        return this.LINENO;
    }

    public String toString() {
        String ret;
        switch (this.ttype) {
            case -1: {
                ret = "EOF";
                break;
            }
            case 10: {
                ret = "EOL";
                break;
            }
            case -3: {
                ret = this.sval;
                break;
            }
            case -2: {
                ret = "d=" + this.dval;
                break;
            }
            case -4: {
                ret = "i=" + this.ival;
                break;
            }
            case -5: {
                ret = "NOTHING";
                break;
            }
            default: {
                if (this.ttype < 256 && (this.ctype[this.ttype] & 8) != 0) {
                    ret = this.sval;
                    break;
                }
                char[] s = new char[3];
                s[2] = 39;
                s[0] = 39;
                s[1] = (char)this.ttype;
                ret = new String(s);
                break;
            }
        }
        return "Token[" + ret + "], line " + this.LINENO;
    }
}

