/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.ntalk;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.thevpc.nuts.runtime.bundles.ntalk.NTalkConstants;
import net.thevpc.nuts.runtime.bundles.ntalk.NTalkUtils;

public class NTalkServer
implements Closeable {
    Socket socket;
    boolean stopped;
    ExecutorService threadPool;
    private long id;
    private String challenge;
    private boolean connected;
    private String host;
    private String service;
    private int port;
    private boolean closed;
    private Action action;
    private DataInputStream inFromBus;
    private DataOutputStream outToBus;
    private String agentVersion;

    public NTalkServer(String service, Action action) {
        this(null, -1, service, action);
    }

    public NTalkServer(int port, String service, Action action) {
        this(null, port, service, action);
    }

    public NTalkServer(String host, int port, String service, Action action) {
        this.host = host == null ? "localhost" : host;
        this.port = port <= 0 ? 1401 : port;
        this.service = service;
        this.action = action;
        if (service == null) {
            throw new NullPointerException("null service");
        }
        if (action == null) {
            throw new NullPointerException("null action");
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public NTalkServer setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public void runAsync() {
        if (this.connected) {
            throw new IllegalArgumentException("Already connected");
        }
        if (this.threadPool == null) {
            this.threadPool = Executors.newCachedThreadPool();
        }
        try {
            this.socket = new Socket(this.host, this.port);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        new Thread(() -> this.runSync()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSync() {
        if (this.connected) {
            throw new IllegalArgumentException("Already connected");
        }
        try {
            if (this.threadPool == null) {
                this.threadPool = Executors.newCachedThreadPool();
            }
            if (this.socket == null) {
                this.socket = new Socket(this.host, this.port);
            }
            this.log("start server");
            this.inFromBus = new DataInputStream(this.socket.getInputStream());
            this.outToBus = new DataOutputStream(this.socket.getOutputStream());
            this.outToBus.writeInt(2);
            this.outToBus.writeUTF(this.service);
            int respoCode = this.inFromBus.readInt();
            if (respoCode != 256) {
                if (respoCode == 258) {
                    this.agentVersion = this.inFromBus.readUTF();
                    int errorCode = this.inFromBus.readInt();
                    byte[] msg = NTalkUtils.readArray(this.inFromBus);
                    throw new IllegalArgumentException("unable to start server " + this.service + ": error " + NTalkConstants.errorCode(errorCode) + " : " + new String(msg));
                }
                throw new IllegalArgumentException("unable to start server " + this.service + ": invalid response code " + respoCode);
            }
            this.agentVersion = this.inFromBus.readUTF();
            this.id = this.inFromBus.readLong();
            this.challenge = this.inFromBus.readUTF();
            this.log("connected");
            this.connected = true;
            while (!this.stopped) {
                int cmdFromBus = this.inFromBus.readInt();
                switch (cmdFromBus) {
                    case 257: {
                        long jobId = -1L;
                        NTalkServer nTalkServer = this;
                        synchronized (nTalkServer) {
                            jobId = this.inFromBus.readLong();
                            this.onJobResponseFailure(jobId);
                            break;
                        }
                    }
                    case 259: {
                        long jobId = -1L;
                        NTalkServer nTalkServer = this;
                        synchronized (nTalkServer) {
                            jobId = this.inFromBus.readLong();
                            this.onJobResponseSuccess(jobId);
                            break;
                        }
                    }
                    case 13: {
                        byte[] bytes0;
                        long cli0;
                        long jobId0;
                        this.log("NEW_JOB:start");
                        NTalkServer nTalkServer = this;
                        synchronized (nTalkServer) {
                            jobId0 = this.inFromBus.readLong();
                            cli0 = this.inFromBus.readLong();
                            bytes0 = NTalkUtils.readArray(this.inFromBus);
                        }
                        long jobId = jobId0;
                        long cli = cli0;
                        byte[] bytes = bytes0;
                        this.log("NEW_JOB: handshake ok " + jobId);
                        this.threadPool.submit(() -> {
                            try {
                                this.log("NEW_JOB: run job " + jobId);
                                boolean err = false;
                                byte[] resp = null;
                                try {
                                    resp = this.action.onMessage(jobId, bytes, cli, this.id, this.service);
                                }
                                catch (Exception ex) {
                                    err = true;
                                    resp = ex.toString().getBytes();
                                }
                                this.log("NEW_JOB: send response " + jobId);
                                NTalkServer nTalkServer = this;
                                synchronized (nTalkServer) {
                                    this.outToBus.writeInt(err ? 13 : 12);
                                    this.outToBus.writeLong(jobId);
                                    this.outToBus.writeLong(cli);
                                    NTalkUtils.writeArray(resp, this.outToBus);
                                }
                                this.log("NEW_JOB: finish " + jobId);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        });
                        break;
                    }
                    default: {
                        this.log("<COMMAND?>: unknown");
                        this.stopped = true;
                    }
                }
            }
        }
        catch (EOFException | SocketException e) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.connected = false;
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.socket = null;
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.outToBus.writeInt(255);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.inFromBus != null) {
                    this.inFromBus.close();
                    this.inFromBus = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.outToBus != null) {
                    this.outToBus.close();
                    this.outToBus = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void onJobResponseSuccess(long jobId) {
    }

    private void onJobResponseFailure(long jobId) {
    }

    private void log(String msg) {
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface Action {
        public byte[] onMessage(long var1, byte[] var3, long var4, long var6, String var8);
    }
}

