/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.nanodb;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBBeanSerializer;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBIntegerSerializer;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBStringSerializer;

public class NanoDBSerializers {
    private Map<ClassWithNullable, NanoDBSerializer> config = new HashMap<ClassWithNullable, NanoDBSerializer>();
    private Map<ClassWithNullable, NanoDBSerializer> cache = new HashMap<ClassWithNullable, NanoDBSerializer>();

    public NanoDBSerializer ofBean(Class clz) {
        return this.ofBean(clz, true);
    }

    public NanoDBSerializer ofBean(Class clz, boolean nullable) {
        return nullable ? new NanoDBBeanSerializer.Null(clz, this) : new NanoDBBeanSerializer.NonNull(clz, this);
    }

    public NanoDBSerializer of(Class clz, boolean nullable) {
        NanoDBSerializer u = this.findSerializer(clz, nullable);
        if (u != null) {
            return u;
        }
        ClassWithNullable id = new ClassWithNullable(clz, nullable);
        throw new IllegalArgumentException("missing serializer for " + id);
    }

    public void setSerializer(Class clz, boolean nullable, NanoDBSerializer ser) {
        ClassWithNullable id = new ClassWithNullable(clz, nullable);
        this.cache.remove(id);
        if (ser == null) {
            this.config.remove(id);
        } else {
            this.config.put(id, ser);
        }
    }

    public NanoDBSerializer findSerializer(Class clz, boolean nullable) {
        ClassWithNullable id = new ClassWithNullable(clz, nullable);
        NanoDBSerializer t = this.cache.get(id);
        if (t != null) {
            return t;
        }
        t = this.config.get(id);
        if (t == null) {
            t = this.findDefaultSerializer(id);
        }
        if (t != null) {
            this.cache.put(id, t);
            return t;
        }
        return null;
    }

    private NanoDBSerializer findDefaultSerializer(ClassWithNullable id) {
        switch (id.getCls().getName()) {
            case "int": {
                return new NanoDBIntegerSerializer.NonNull();
            }
            case "java.lang.Integer": {
                return id.isNullable() ? new NanoDBIntegerSerializer.Null() : new NanoDBIntegerSerializer.NonNull();
            }
            case "java.lang.String": {
                return id.isNullable() ? new NanoDBStringSerializer.Null() : new NanoDBStringSerializer.NonNull();
            }
        }
        return null;
    }

    private static class ClassWithNullable {
        private final Class cls;
        private final boolean nullable;

        public ClassWithNullable(Class cls, boolean nullable) {
            this.cls = cls;
            this.nullable = nullable;
        }

        public Class getCls() {
            return this.cls;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassWithNullable that = (ClassWithNullable)o;
            return this.nullable == that.nullable && Objects.equals(this.cls, that.cls);
        }

        public int hashCode() {
            return Objects.hash(this.cls, this.nullable);
        }

        public String toString() {
            if (this.cls.isPrimitive()) {
                if (this.nullable) {
                    return "nullable-" + this.cls.getName();
                }
                return this.cls.getName();
            }
            if (!this.nullable) {
                return "non-nullable-" + this.cls.getName();
            }
            return this.cls.getName();
        }
    }
}

