/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.nanodb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.thevpc.nuts.runtime.bundles.nanodb.DBIndexValueStore;
import net.thevpc.nuts.runtime.bundles.nanodb.DBIndexValueStoreFactory;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBAbstractIndex;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBDefaultInputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBDefaultOutputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBSerializer;

public class NanoDBDefaultIndex<T>
extends NanoDBAbstractIndex<T> {
    public static final String NANODB_INDEX_0_8_1 = "nanodb-index-0.8.1";
    private Map<T, DBIndexValueStore> index = new HashMap<T, DBIndexValueStore>();
    private DBIndexValueStoreFactory storeFactory;
    private File file;

    public NanoDBDefaultIndex(NanoDBSerializer<T> ser, DBIndexValueStoreFactory storeFactory, Map<T, DBIndexValueStore> index, File file) {
        super(ser);
        this.index = index;
        this.storeFactory = storeFactory;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void load() {
        if (this.file.exists()) {
            this.load(this.file);
        }
    }

    @Override
    public void flush() {
        this.file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(this.file);){
            this.store(new NanoDBDefaultOutputStream(out));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void put(T s, long position) {
        DBIndexValueStore store = this.index.get(s);
        if (store == null) {
            store = this.storeFactory.create(this, s);
            this.index.put(s, store);
        }
        store.add(position);
    }

    @Override
    public LongStream get(T s) {
        DBIndexValueStore store = this.index.get(s);
        return store == null ? Arrays.stream(new long[0]) : store.stream();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public Stream<T> findAll() {
        return this.index.keySet().stream();
    }

    public void storeKey(T k, NanoDBOutputStream dos) throws IOException {
        this.ser.write(k, dos);
    }

    public void store(NanoDBOutputStream dos) {
        try {
            dos.writeUTF(NANODB_INDEX_0_8_1);
            dos.writeLong(this.index.size());
            for (Map.Entry<T, DBIndexValueStore> e : this.index.entrySet()) {
                this.storeKey(e.getKey(), dos);
                DBIndexValueStore store = e.getValue();
                boolean mem = store.isMem();
                if (mem) {
                    long[] pos = store.stream().toArray();
                    dos.writeByte(0);
                    dos.writeInt(pos.length);
                    for (long po : pos) {
                        dos.writeLong(po);
                    }
                    continue;
                }
                dos.writeByte(1);
                store.flush();
            }
            dos.flush();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void load(NanoDBInputStream in) {
        try {
            String header = in.readUTF();
            if (!NANODB_INDEX_0_8_1.equals(header)) {
                throw new UncheckedIOException(new IOException("Unsupported index file " + header));
            }
            long r = in.readLong();
            this.index = new HashMap<T, DBIndexValueStore>(r <= 10L ? 10 : (int)r);
            for (long i = 0L; i < r; ++i) {
                T o = this.readKey(in);
                byte type = in.readByte();
                if (type == 0) {
                    int len = in.readInt();
                    long[] pos = new long[len];
                    for (int j = 0; j < len; ++j) {
                        pos[j] = in.readLong();
                    }
                    this.index.put(o, this.storeFactory.load(this, o, pos));
                    continue;
                }
                if (type == 1) {
                    this.index.put(o, this.storeFactory.loadExternal(this, o));
                    continue;
                }
                this.index.put(o, this.storeFactory.loadExternal(this, o));
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected T readKey(NanoDBInputStream in) throws IOException {
        return this.ser.read(in);
    }

    public void store(File stream) throws IOException {
        try (FileOutputStream out = new FileOutputStream(stream);){
            this.store(new NanoDBDefaultOutputStream(out));
        }
    }

    public void load(File stream) {
        try (FileInputStream out = new FileInputStream(stream);){
            this.load(new NanoDBDefaultInputStream(out));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

