/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.nanodb;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.nanodb.DBIndexValueStoreDefaultFactory;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBDefaultIndex;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBFieldIndexDefinition;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBSerializers;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBTableDefinition;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBTableFile;

public class NanoDB
implements AutoCloseable {
    private Map<String, NanoDBTableFile> tables = new HashMap<String, NanoDBTableFile>();
    private File dir;
    private NanoDBSerializers serializers = new NanoDBSerializers();

    public NanoDB(File dir) {
        this.dir = dir;
        dir.mkdirs();
    }

    public void flush() {
        for (NanoDBTableFile value : this.tables.values()) {
            value.flush();
        }
    }

    @Override
    public void close() {
        for (NanoDBTableFile value : this.tables.values()) {
            value.close();
        }
    }

    public NanoDBSerializers getSerializers() {
        return this.serializers;
    }

    public NanoDBTableFile getTable(String name) {
        NanoDBTableFile tableFile = this.tables.get(name);
        if (tableFile == null) {
            throw new IllegalArgumentException("table does not exists: " + name);
        }
        return tableFile;
    }

    public <T> NanoDBTableDefinition<T> createBeanDefinition(Class<T> type, boolean nullable, String ... indices) {
        return this.createBeanDefinition(type.getSimpleName(), type, nullable, indices);
    }

    public <T> NanoDBTableDefinition<T> createBeanDefinition(String name, Class<T> type, boolean nullable, String ... indices) {
        ArrayList defs = new ArrayList();
        block0: for (String index : indices) {
            for (Field declaredField : type.getDeclaredFields()) {
                if (!declaredField.getName().equals(index)) continue;
                defs.add(new NanoDBFieldIndexDefinition(declaredField));
                continue block0;
            }
        }
        return new NanoDBTableDefinition<T>(name, type, this.serializers.ofBean(type, nullable), defs.toArray(new NanoDBIndexDefinition[0]));
    }

    public <T> NanoDBTableFile<T> createTable(NanoDBTableDefinition<T> def) {
        return this.createTable(def, false);
    }

    public <T> NanoDBTableFile<T> createTable(NanoDBTableDefinition<T> def, boolean getOrCreate) {
        if (def == null) {
            throw new IllegalArgumentException("null table definition");
        }
        String name = def.getName();
        if (getOrCreate) {
            NanoDBTableFile oldTable = this.tables.get(name);
            if (this.tables.containsKey(name)) {
                return oldTable;
            }
        }
        if (NutsUtilStrings.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("invalid table definition: null name");
        }
        NanoDBSerializer serializer = def.getSerializer();
        Class<T> serSupportedType = serializer != null ? serializer.getSupportedType() : null;
        Class<T> defType = def.getType();
        if (defType == null) {
            defType = serSupportedType;
        }
        if (serSupportedType == null) {
            serSupportedType = defType;
        }
        if (defType == null || serSupportedType == null) {
            throw new IllegalArgumentException("invalid table definition: invalid type");
        }
        if (serializer == null) {
            serializer = this.getSerializers().of(defType, true);
        }
        if (!serSupportedType.isAssignableFrom(defType)) {
            throw new IllegalArgumentException("invalid table definition: invalid type: " + defType.getName() + "; unsupported by a serializer for " + serSupportedType.getName());
        }
        if (this.tables.containsKey(name)) {
            throw new IllegalArgumentException("table already defined: " + name);
        }
        NanoDBIndexDefinition<T>[] indices = def.getIndices();
        if (indices == null) {
            indices = new NanoDBIndexDefinition[]{};
        }
        for (NanoDBIndexDefinition<T> index : indices) {
            if (index != null) continue;
            throw new IllegalArgumentException("invalid table definition: null index");
        }
        NanoDBTableFile<T> f = new NanoDBTableFile<T>(this.dir, name, serializer, this, indices);
        this.tables.put(name, f);
        return f;
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName);
    }

    public <T> NanoDBIndex<T> createIndexFor(NanoDBSerializer ser, File file) {
        return new NanoDBDefaultIndex(ser, new DBIndexValueStoreDefaultFactory(), new HashMap(), file);
    }
}

