/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.mvn;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.bundles.mvn.PomId;
import net.thevpc.nuts.runtime.bundles.mvn.PomLogger;
import net.thevpc.nuts.runtime.bundles.mvn.PomUrlReader;
import net.thevpc.nuts.runtime.bundles.mvn.PomXmlParser;
import net.thevpc.nuts.runtime.bundles.mvn.URLFilter;
import net.thevpc.nuts.runtime.bundles.mvn.URLParts;

public class PomIdResolver {
    private PomUrlReader pomUrlReader;
    private PomLogger logger;

    public PomIdResolver(PomUrlReader pomUrlReader, PomLogger logger) {
        this.pomUrlReader = pomUrlReader;
        if (this.pomUrlReader == null) {
            this.pomUrlReader = PomUrlReader.DEFAULT;
        }
        this.logger = logger;
        if (this.logger == null) {
            this.logger = PomLogger.DEFAULT;
        }
    }

    public PomId[] resolvePomId(URL baseUrl, String referenceResourcePath, NutsSession session) {
        ArrayList<PomId> all = new ArrayList<PomId>();
        URLParts aa = new URLParts(baseUrl);
        String basePath = aa.getLastPart().getPath().substring(0, aa.getLastPart().getPath().length() - referenceResourcePath.length());
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        URLParts p = aa.getParent().append(basePath + "META-INF/maven");
        int beforeSize = all.size();
        URL[] children = new URL[]{};
        try {
            children = p.getChildren(false, true, new MyURLFilter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (URL url : children) {
            if (url == null) continue;
            Properties prop = new Properties();
            try {
                prop.load(url.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = prop.getProperty("version");
            String groupId = prop.getProperty("groupId");
            String artifactId = prop.getProperty("artifactId");
            if (version == null || version.trim().length() == 0) continue;
            all.add(new PomId(groupId, artifactId, version));
        }
        if (beforeSize == all.size() && basePath.endsWith("/target/classes/")) {
            String s2 = basePath.substring(0, basePath.length() - "/target/classes/".length()) + "/pom.xml";
            try {
                all.add(new PomXmlParser(this.logger).parse(new URL(s2), session).getPomId());
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "failed to parse pom file {0} : {1}", s2, ex);
            }
        }
        return all.toArray(new PomId[0]);
    }

    public PomId[] resolvePomIds(Class clazz, NutsSession session) {
        ArrayList<PomId> all = new ArrayList<PomId>();
        try {
            String n = clazz.getName().replace('.', '/').concat(".class");
            Enumeration<URL> r = clazz.getClassLoader().getResources(n);
            for (URL url : Collections.list(r)) {
                all.addAll(Arrays.asList(this.resolvePomId(url, n, session)));
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.FINE, "error : {0}", ex);
        }
        return all.toArray(new PomId[0]);
    }

    public PomId resolvePomId(Class clazz, NutsSession session) {
        return this.resolvePomId(clazz, new PomId("dev", "dev", "dev"), session);
    }

    public PomId resolvePomId(Class clazz, PomId defaultValue, NutsSession session) {
        PomId[] pomIdArray;
        int n;
        int n2;
        PomId[] pomIds = this.resolvePomIds(clazz, session);
        if (pomIds.length > 1 && this.logger != null) {
            this.logger.log(Level.INFO, "multiple ids found : " + Arrays.asList(pomIds) + " for class " + clazz + " and id " + defaultValue, new Object[0]);
        }
        if ((n2 = 0) < (n = (pomIdArray = pomIds).length)) {
            PomId v = pomIdArray[n2];
            return v;
        }
        return defaultValue;
    }

    public PomId resolvePomId(Class clazz, String groupId, String artifactId, String defaultValue) {
        String ver = this.resolvePomVersion(clazz, groupId, artifactId, defaultValue);
        return new PomId(groupId, artifactId, ver);
    }

    public String resolvePomVersion(String groupId, String artifactId, String defaultValue) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (url != null) {
            Properties p = new Properties();
            try {
                p.load(url.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = p.getProperty("version");
            if (version != null && version.trim().length() != 0) {
                return version;
            }
        }
        return defaultValue;
    }

    public String resolvePomVersion(Class clazz, String groupId, String artifactId, String defaultValue) {
        URL url = clazz.getClassLoader().getResource("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (url != null) {
            Properties p = new Properties();
            try {
                p.load(url.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = p.getProperty("version");
            if (version != null && version.trim().length() != 0) {
                return version;
            }
        }
        return defaultValue;
    }

    public PomId resolvePropertiesPomId(InputStream stream) {
        Properties prop = new Properties();
        try {
            prop.load(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String version = prop.getProperty("version");
        String groupId = prop.getProperty("groupId");
        String artifactId = prop.getProperty("artifactId");
        if (version != null && version.trim().length() != 0) {
            return new PomId(groupId, artifactId, version);
        }
        return null;
    }

    public PomId[] resolveJarPomIds(InputStream jarStream) throws IOException {
        final ArrayList list = new ArrayList();
        this.visitZipStream(jarStream, new InputStreamVisitor(){

            @Override
            public boolean visit(String path, InputStream inputStream) {
                PomId id;
                if (path.startsWith("META-INF/") && path.endsWith("/pom.properties") && (id = PomIdResolver.this.resolvePropertiesPomId(inputStream)) != null) {
                    list.add(new PomId(id.getGroupId(), id.getArtifactId(), id.getVersion()));
                }
                return true;
            }
        });
        return list.toArray(new PomId[0]);
    }

    public PomId resolveJarPomId(InputStream jarStream) throws IOException {
        PomId[] v = this.resolveJarPomIds(jarStream);
        if (v.length == 0) {
            return null;
        }
        if (v.length >= 2) {
            throw new IllegalArgumentException("too many Ids");
        }
        return v[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitZipStream(InputStream zipFile, InputStreamVisitor visitor) throws IOException {
        try (ZipInputStream zis = null;){
            zis = new ZipInputStream(zipFile);
            ZipEntry ze = zis.getNextEntry();
            final ZipInputStream finalZis = zis;
            InputStream entryInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return finalZis.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return finalZis.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return finalZis.read(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    finalZis.closeEntry();
                }
            };
            while (ze != null) {
                String fileName = ze.getName();
                if (!fileName.endsWith("/") && !visitor.visit(fileName, entryInputStream)) {
                    break;
                }
                ze = zis.getNextEntry();
            }
        }
        return false;
    }

    private static class MyURLFilter
    implements URLFilter {
        @Override
        public boolean accept(URL path) {
            return new URLParts(path).getName().equals("pom.properties");
        }
    }

    private static interface InputStreamVisitor {
        public boolean visit(String var1, InputStream var2) throws IOException;
    }
}

