/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.mvn;

import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.runtime.bundles.mvn.PomId;

public class PomDependency {
    private String groupId;
    private String artifactId;
    private String version;
    private String scope;
    private String classifier;
    private String os;
    private String arch;
    private String optional;
    private String type;
    private PomId[] exclusions;

    public PomDependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, null, version, null, null, null, null, null, new PomId[0]);
    }

    public PomDependency(String groupId, String artifactId, String classifier, String version, String scope, String optional, String os, String arch, String type, PomId[] exclusions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.optional = optional;
        this.scope = scope;
        this.os = os;
        this.arch = arch;
        this.type = type;
        this.classifier = classifier;
        this.exclusions = exclusions;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String getOptional() {
        return this.optional;
    }

    public PomId[] getExclusions() {
        return this.exclusions;
    }

    public PomDependency setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public PomDependency setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public PomDependency setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public PomDependency setVersion(String version) {
        this.version = version;
        return this;
    }

    public PomDependency setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public PomDependency setOptional(String optional) {
        this.optional = optional;
        return this;
    }

    public PomDependency setExclusions(PomId[] exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PomDependency that = (PomDependency)o;
        return Objects.equals(PomDependency.toUniformGroupId(this.groupId), PomDependency.toUniformGroupId(that.groupId)) && Objects.equals(PomDependency.toUniformGroupId(this.artifactId), PomDependency.toUniformGroupId(that.artifactId)) && Objects.equals(PomDependency.toUniformGroupId(this.version), PomDependency.toUniformGroupId(that.version)) && Objects.equals(PomDependency.toUniformGroupId(this.os), PomDependency.toUniformGroupId(that.os)) && Objects.equals(PomDependency.toUniformGroupId(this.arch), PomDependency.toUniformGroupId(that.arch)) && Objects.equals(PomDependency.toUniformScope(this.scope), PomDependency.toUniformScope(that.scope)) && Objects.equals(PomDependency.toUniformOptional(this.optional), PomDependency.toUniformOptional(that.optional)) && Arrays.equals(this.exclusions, that.exclusions);
    }

    private static String toUniformGroupId(String s) {
        return s == null ? "" : s.trim();
    }

    private static String toUniformScope(String s) {
        String string = s = s == null ? "" : s.trim().toLowerCase();
        if (s.isEmpty()) {
            return "compile";
        }
        return s;
    }

    private static String toUniformOptional(String s) {
        s = s == null ? "" : s.trim().toLowerCase();
        return s;
    }

    public int hashCode() {
        int result = Objects.hash(this.groupId, this.artifactId, this.version, this.scope, this.optional, this.os, this.arch);
        result = 31 * result + Arrays.hashCode(this.exclusions);
        return result;
    }

    public String toString() {
        return "PomDependency{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", scope='" + this.scope + '\'' + ", os='" + this.os + '\'' + ", arch='" + this.arch + '\'' + ", optional='" + this.optional + '\'' + ", type='" + this.type + '\'' + ", exclusions=" + Arrays.toString(this.exclusions) + '}';
    }
}

