/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.mvn;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import net.thevpc.nuts.runtime.bundles.collections.EvictingQueue;

public class DirtyLuceneIndexParser
implements Iterator<String>,
Closeable {
    private PushbackReader reader;
    private String last;
    private EvictingQueue<Integer> whites = new EvictingQueue(10);
    private long count = 0L;
    private boolean closed = false;

    public DirtyLuceneIndexParser(InputStream reader) {
        this.reader = new PushbackReader(new InputStreamReader(reader));
    }

    public static boolean isVisibleChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == '|';
    }

    @Override
    public boolean hasNext() {
        this.last = this.preload();
        return this.last != null;
    }

    @Override
    public String next() {
        return this.last;
    }

    private String preload() {
        try {
            block2: while (true) {
                if (this.reader == null || this.closed) {
                    return null;
                }
                int c = this.reader.read();
                if (c >= 0) {
                    if (DirtyLuceneIndexParser.isVisibleChar((char)c)) {
                        StringBuilder sb = new StringBuilder();
                        boolean withPipe = c == 124;
                        sb.append((char)c);
                        while ((c = this.reader.read()) >= 0) {
                            if (!DirtyLuceneIndexParser.isVisibleChar((char)c)) {
                                this.reader.unread(c);
                                break;
                            }
                            withPipe |= c == 124;
                            sb.append((char)c);
                        }
                        if (!withPipe) continue;
                        String s = sb.toString();
                        boolean ignore = false;
                        if (this.whites.size() == 3 && this.whites.get(0).equals(0) && this.whites.get(1).equals(0) && this.whites.get(2).equals(0)) {
                            s = s.substring(1);
                        }
                        if (!ignore) {
                            if (s.startsWith("|")) {
                                s = s.substring(1);
                            }
                            if (s.contains("|sources|") || s.contains("|javadoc|")) {
                                ignore = true;
                            } else if (s.endsWith("|tests|jar")) {
                                ignore = true;
                            }
                        }
                        if (ignore) continue;
                        String[] split = s.split("[|]");
                        if (split.length < 3) {
                            ignore = true;
                        } else if (split[0].indexOf(46) < 0) {
                            ignore = true;
                        }
                        if (ignore) continue;
                        ++this.count;
                        return split[0] + ":" + split[1] + "#" + split[2];
                    }
                    this.whites.clear();
                    this.whites.add(c);
                    while (true) {
                        if ((c = this.reader.read()) < 0) continue block2;
                        if (DirtyLuceneIndexParser.isVisibleChar((char)c)) {
                            this.reader.unread(c);
                            continue block2;
                        }
                        this.whites.add(c);
                    }
                }
                break;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.close();
        return null;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

