/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.mvn;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.thevpc.nuts.runtime.bundles.mvn.PomId;
import net.thevpc.nuts.runtime.bundles.mvn.PomIdFilter;

public class ArchetypeCatalogParser {
    public static Iterator<PomId> createArchetypeCatalogIterator(final InputStream stream, final PomIdFilter filter, final boolean autoCloseStream) {
        return new Iterator<PomId>(){
            PomId last;
            InputStream stream2;
            XMLInputFactory factory;
            XMLEventReader eventReader;
            Stack<String> nodePath;
            StringBuilder groupId;
            StringBuilder artifactId;
            StringBuilder version;
            {
                this.stream2 = stream;
                this.nodePath = new Stack();
                this.groupId = new StringBuilder();
                this.artifactId = new StringBuilder();
                this.version = new StringBuilder();
                this.factory = XMLInputFactory.newInstance();
                this.factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
                try {
                    this.eventReader = this.factory.createXMLEventReader(new InputStreamReader(this.stream2));
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                if (this.eventReader == null || this.stream2 == null) {
                    this.autoCloseStream();
                    return false;
                }
                try {
                    while (this.eventReader.hasNext()) {
                        XMLEvent event = this.eventReader.nextEvent();
                        switch (event.getEventType()) {
                            case 1: {
                                StartElement startElement = event.asStartElement();
                                String qName = startElement.getName().getLocalPart();
                                this.nodePath.push(qName);
                                if (!ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype"})) break;
                                ArchetypeCatalogParser.clear(this.groupId);
                                ArchetypeCatalogParser.clear(this.artifactId);
                                ArchetypeCatalogParser.clear(this.version);
                                break;
                            }
                            case 4: {
                                if (ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype", "groupId"})) {
                                    this.groupId.append(event.asCharacters().getData());
                                    break;
                                }
                                if (ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype", "artifactId"})) {
                                    this.artifactId.append(event.asCharacters().getData());
                                    break;
                                }
                                if (!ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype", "version"})) break;
                                this.version.append(event.asCharacters().getData());
                                break;
                            }
                            case 2: {
                                if (ArchetypeCatalogParser.isStackPath(this.nodePath, new String[]{"archetype-catalog", "archetypes", "archetype"})) {
                                    this.last = new PomId(this.groupId.toString(), this.artifactId.toString(), this.version.toString());
                                    if (filter == null || filter.accept(this.last)) {
                                        this.nodePath.pop();
                                        return true;
                                    }
                                }
                                this.nodePath.pop();
                            }
                        }
                    }
                }
                catch (XMLStreamException ex) {
                    this.autoCloseStream();
                    return false;
                }
                this.autoCloseStream();
                return false;
            }

            @Override
            public PomId next() {
                return this.last;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unsupported operation: remove");
            }

            protected void finalize() throws Throwable {
                super.finalize();
                this.autoCloseStream();
            }

            private void autoCloseStream() {
                if (autoCloseStream && this.stream2 != null) {
                    try {
                        this.stream2.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.stream2 = null;
                }
            }
        };
    }

    private static StringBuilder clear(StringBuilder c) {
        return c.delete(0, c.length());
    }

    private static boolean isStackPath(Stack<String> stack, String ... path) {
        if (stack.size() != path.length) {
            return false;
        }
        for (int i = 0; i < path.length; ++i) {
            if (((String)stack.get(stack.size() - path.length + i)).equals(path[i])) continue;
            return false;
        }
        return true;
    }
}

