/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;

public class QueueIterator<T>
implements Iterator<T> {
    private Queue<Iterator<T>> children = new LinkedList<Iterator<T>>();
    private int size;

    public void addNonNull(Iterator<T> child) {
        if (child != null) {
            this.add(child);
        }
    }

    public void addNonEmpty(Iterator<T> child) {
        if ((child = IteratorUtils.nullifyIfEmpty(child)) != null) {
            this.add(child);
        }
    }

    public void add(Iterator<T> child) {
        if (child == null) {
            throw new NullPointerException();
        }
        this.children.add(child);
        ++this.size;
    }

    @Override
    public boolean hasNext() {
        while (!this.children.isEmpty()) {
            if (this.children.peek().hasNext()) {
                return true;
            }
            this.children.poll();
            --this.size;
        }
        return false;
    }

    @Override
    public T next() {
        return this.children.peek().next();
    }

    public int size() {
        return this.size;
    }

    @Override
    public void remove() {
        this.children.peek().remove();
    }

    public Iterator<T>[] getChildren() {
        return this.children.toArray(new Iterator[0]);
    }

    public String toString() {
        return "QueueIterator(" + this.children + ')';
    }
}

