/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsPredicates;
import net.thevpc.nuts.runtime.bundles.io.FileDepthFirstIterator;
import net.thevpc.nuts.runtime.bundles.iter.CoalesceIterator;
import net.thevpc.nuts.runtime.bundles.iter.ConvertedIterator;
import net.thevpc.nuts.runtime.bundles.iter.ConvertedNonNullIterator;
import net.thevpc.nuts.runtime.bundles.iter.DistinctPredicate;
import net.thevpc.nuts.runtime.bundles.iter.DistinctWithConverterPredicate;
import net.thevpc.nuts.runtime.bundles.iter.ErrorHandlerIterator;
import net.thevpc.nuts.runtime.bundles.iter.FilteredIterator;
import net.thevpc.nuts.runtime.bundles.iter.IteratorErrorHandlerType;
import net.thevpc.nuts.runtime.bundles.iter.PushBackIterator;
import net.thevpc.nuts.runtime.bundles.iter.QueueIterator;

public class IteratorUtils {
    public static final Predicate NON_NULL = NutsPredicates.isNull().negate();
    public static final Predicate NON_BLANK = NutsPredicates.blank().negate();
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public static FileDepthFirstIterator dsf(File file) {
        return new FileDepthFirstIterator(file);
    }

    public static <T> Iterator<T> safe(IteratorErrorHandlerType type, Iterator<T> t) {
        return new ErrorHandlerIterator<T>(type, t);
    }

    public static <T> Iterator<T> safeIgnore(Iterator<T> t) {
        return new ErrorHandlerIterator<T>(IteratorErrorHandlerType.IGNORE, t);
    }

    public static <T> Iterator<T> safePospone(Iterator<T> t) {
        return new ErrorHandlerIterator<T>(IteratorErrorHandlerType.POSPONE, t);
    }

    public static <T> boolean isNullOrEmpty(Iterator<T> t) {
        return t == null || t == EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Iterator<T> nonNull(Iterator<T> t) {
        if (t == null) {
            return IteratorUtils.emptyIterator();
        }
        return t;
    }

    public static <T> Iterator<T> concat(List<Iterator<T>> all) {
        if (all == null || all.isEmpty()) {
            return IteratorUtils.emptyIterator();
        }
        QueueIterator<T> t = new QueueIterator<T>();
        for (Iterator<T> it : all) {
            if (IteratorUtils.isNullOrEmpty(it)) continue;
            if (it instanceof QueueIterator) {
                QueueIterator tt = (QueueIterator)it;
                for (Iterator it1 : tt.getChildren()) {
                    t.add(it1);
                }
                continue;
            }
            t.add(it);
        }
        int tsize = t.size();
        if (tsize == 0) {
            return IteratorUtils.emptyIterator();
        }
        if (tsize == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static <T> Iterator<T> coalesce(List<Iterator<T>> all) {
        if (all == null || all.isEmpty()) {
            return IteratorUtils.emptyIterator();
        }
        CoalesceIterator<T> t = new CoalesceIterator<T>();
        for (Iterator<T> it : all) {
            if (IteratorUtils.isNullOrEmpty(it)) continue;
            t.add(it);
        }
        int tsize = t.size();
        if (tsize == 0) {
            return IteratorUtils.emptyIterator();
        }
        if (tsize == 1) {
            return t.getChildren()[0];
        }
        return t;
    }

    public static <T> Iterator<T> filter(Iterator<T> from, Predicate<T> filter) {
        if (from == null) {
            return IteratorUtils.emptyIterator();
        }
        if (filter == null) {
            return from;
        }
        return new FilteredIterator<T>(from, filter);
    }

    public static <T> Iterator<T> name(String name, Iterator<T> from) {
        return new NamedIterator<T>(from, name);
    }

    public static <T> Iterator<T> flatCollection(Iterator<Collection<T>> from) {
        return IteratorUtils.flatMap(from, c -> c.iterator());
    }

    public static <T> Iterator<T> flatIterator(Iterator<Iterator<T>> from) {
        return IteratorUtils.flatMap(from, c -> c);
    }

    public static <B, T> Iterator<T> flatMap(Iterator<B> from, Function<B, Iterator<T>> fun) {
        if (from == null) {
            return IteratorUtils.emptyIterator();
        }
        return new FlatMapIterator<B, T>(from, fun);
    }

    public static <T> Iterator<T> supplier(Supplier<Iterator<T>> from) {
        return new SupplierIterator<T>(from, null);
    }

    public static <T> Iterator<T> supplier(Supplier<Iterator<T>> from, String name) {
        return new SupplierIterator<T>(from, name);
    }

    public static <T> Iterator<T> onFinish(Iterator<T> from, Runnable r) {
        if (from == null) {
            return IteratorUtils.emptyIterator();
        }
        return new OnFinishIterator<T>(from, r);
    }

    public static <F, T> Iterator<T> convert(Iterator<F> from, Function<F, T> converter, String name) {
        if (IteratorUtils.isNullOrEmpty(from)) {
            return IteratorUtils.emptyIterator();
        }
        return new ConvertedIterator<F, T>(from, converter, name);
    }

    public static <F, T> Iterator<T> convertNonNull(Iterator<F> from, Function<F, T> converter, String name) {
        if (IteratorUtils.isNullOrEmpty(from)) {
            return IteratorUtils.emptyIterator();
        }
        return new ConvertedNonNullIterator<F, T>(from, converter, name);
    }

    public static <T> List<T> toList(Iterator<T> it) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptyList();
        }
        ArrayList<T> a = new ArrayList<T>();
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Set<T> toSet(Iterator<T> it) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> a = new LinkedHashSet<T>();
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Set<T> toTreeSet(Iterator<T> it, Comparator<T> c) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return Collections.emptySet();
        }
        TreeSet<T> a = new TreeSet<T>(c);
        while (it.hasNext()) {
            a.add(it.next());
        }
        return a;
    }

    public static <T> Iterator<T> sort(Iterator<T> it, Comparator<T> c, boolean removeDuplicates) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return IteratorUtils.emptyIterator();
        }
        return new SortIterator<T>(it, c, removeDuplicates);
    }

    public static <T> Iterator<T> distinct(Iterator<T> it) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return IteratorUtils.emptyIterator();
        }
        DistinctPredicate filter = new DistinctPredicate();
        return new FilteredIterator<T>(it, filter);
    }

    public static <F, T> Iterator<F> distinct(Iterator<F> it, Function<F, T> converter) {
        if (IteratorUtils.isNullOrEmpty(it)) {
            return IteratorUtils.emptyIterator();
        }
        DistinctWithConverterPredicate<F, T> filter = new DistinctWithConverterPredicate<F, T>(converter);
        return new FilteredIterator<F>(it, filter);
    }

    public static <T> CollectorIterator<T> collector(Iterator<T> it) {
        if (it == null) {
            return new CollectorIterator<T>(null, IteratorUtils.emptyIterator());
        }
        return new CollectorIterator<T>(null, it);
    }

    public static <T> Iterator<T> nullifyIfEmpty(Iterator<T> other) {
        if (other == null) {
            return null;
        }
        if (other instanceof PushBackIterator) {
            PushBackIterator b = (PushBackIterator)other;
            if (!b.isEmpty()) {
                return b;
            }
            return null;
        }
        PushBackIterator<T> b = new PushBackIterator<T>(other);
        if (!b.isEmpty()) {
            return b;
        }
        return null;
    }

    private static class SortIterator<T>
    implements Iterator<T> {
        private final boolean removeDuplicates;
        private final Iterator<T> it;
        private final Comparator<T> c;
        Iterator<T> base;

        public SortIterator(Iterator<T> it, Comparator<T> c, boolean removeDuplicates) {
            this.removeDuplicates = removeDuplicates;
            this.it = it;
            this.c = c;
            this.base = null;
        }

        public Iterator<T> getBase() {
            if (this.base == null) {
                if (this.removeDuplicates) {
                    this.base = IteratorUtils.toTreeSet(this.it, this.c).iterator();
                } else {
                    List<T> a = IteratorUtils.toList(this.it);
                    a.sort(this.c);
                    this.base = a.iterator();
                }
            }
            return this.base;
        }

        @Override
        public boolean hasNext() {
            return this.getBase().hasNext();
        }

        @Override
        public T next() {
            return this.getBase().next();
        }

        public String toString() {
            return "sort(" + this.it + ")";
        }
    }

    private static class FlatMapIterator<B, T>
    implements Iterator<T> {
        private final Iterator<B> from;
        private final Function<B, Iterator<T>> fun;
        Iterator<T> n;

        public FlatMapIterator(Iterator<B> from, Function<B, Iterator<T>> fun) {
            this.from = from;
            this.fun = fun;
            this.n = null;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.n == null) {
                    if (this.from.hasNext()) {
                        B p = this.from.next();
                        if (p == null) {
                            this.n = Collections.emptyIterator();
                        } else {
                            this.n = this.fun.apply(p);
                            if (this.n == null) {
                                this.n = Collections.emptyIterator();
                            }
                        }
                    } else {
                        return false;
                    }
                }
                if (this.n.hasNext()) {
                    return true;
                }
                this.n = null;
            }
        }

        @Override
        public T next() {
            return this.n.next();
        }

        public String toString() {
            return "flattenIterator(" + this.from + ")";
        }
    }

    public static class CollectorIterator<T>
    implements Iterator<T> {
        private String name;
        private Iterator<T> base;
        private List<T> collected = new ArrayList<T>();

        public CollectorIterator(String name, Iterator<T> base) {
            this.name = name;
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public T next() {
            T x = this.base.next();
            this.collected.add(x);
            return x;
        }

        public List<T> getCollected() {
            return this.collected;
        }

        public String toString() {
            if (this.name == null) {
                return "collector(" + this.base + ")";
            }
            return String.valueOf(this.name);
        }
    }

    private static class NamedIterator<T>
    implements Iterator<T> {
        private final Iterator<T> from;
        private final String name;

        public NamedIterator(Iterator<T> from, String name) {
            this.from = from;
            this.name = name;
        }

        @Override
        public boolean hasNext() {
            return this.from != null && this.from.hasNext();
        }

        @Override
        public T next() {
            return this.from.next();
        }

        public String toString() {
            return String.valueOf(this.name);
        }
    }

    private static class SupplierIterator<T>
    implements Iterator<T> {
        private final Supplier<Iterator<T>> from;
        private Iterator<T> it;
        private String name;

        public SupplierIterator(Supplier<Iterator<T>> from, String name) {
            this.from = from;
            this.name = name;
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                this.it = this.from.get();
            }
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }

        public String toString() {
            if (this.name == null) {
                return "supplier(" + this.from + ")";
            }
            return String.valueOf(this.name);
        }
    }

    private static class OnFinishIterator<T>
    implements Iterator<T> {
        private final Iterator<T> from;
        private final Runnable r;

        public OnFinishIterator(Iterator<T> from, Runnable r) {
            this.from = from;
            this.r = r;
        }

        @Override
        public boolean hasNext() {
            boolean n = this.from.hasNext();
            if (!n) {
                this.r.run();
            }
            return n;
        }

        @Override
        public T next() {
            return this.from.next();
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
        }

        public String toString() {
            return "EmptyIterator";
        }
    }
}

