/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.bundles.iter;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.runtime.bundles.io.FileDepthFirstIterator;
import net.thevpc.nuts.runtime.bundles.iter.ConvertedIterator;
import net.thevpc.nuts.runtime.bundles.iter.ConvertedToListIterator;
import net.thevpc.nuts.runtime.bundles.iter.ErrorHandlerIterator;
import net.thevpc.nuts.runtime.bundles.iter.FilteredIterator;
import net.thevpc.nuts.runtime.bundles.iter.IteratorErrorHandlerType;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.bundles.iter.LazyIterator;
import net.thevpc.nuts.runtime.bundles.iter.NamedIterable;
import net.thevpc.nuts.runtime.core.util.CoreCollectionUtils;

public class IteratorBuilder<T> {
    private final Iterator<T> it;

    private IteratorBuilder(Iterator<T> it) {
        if (it == null) {
            it = IteratorUtils.emptyIterator();
        }
        this.it = it;
    }

    public static <T> IteratorBuilder<T> ofCoalesce(List<Iterator<T>> t) {
        return new IteratorBuilder<T>(IteratorUtils.coalesce(t));
    }

    public static <T> IteratorBuilder<T> ofList(List<Iterator<T>> t) {
        return new IteratorBuilder<T>(IteratorUtils.concat(t));
    }

    public static <T> IteratorBuilder<T> of(Iterator<T> t) {
        return new IteratorBuilder<T>(t);
    }

    public static <T> IteratorBuilder<T> ofLazyNamed(String name, final Iterable<T> t) {
        return IteratorBuilder.ofLazy(new NamedIterable<T>(name){

            @Override
            public Iterator<T> iterator() {
                return t.iterator();
            }
        });
    }

    public static <T> IteratorBuilder<T> ofLazy(Iterable<T> t) {
        return new IteratorBuilder<T>(new LazyIterator<T>(t));
    }

    public static IteratorBuilder<File> ofFileDfs(File file) {
        return IteratorBuilder.of(new FileDepthFirstIterator(file));
    }

    public static <T> IteratorBuilder<T> ofArray(T ... t) {
        return IteratorBuilder.of(t == null ? IteratorUtils.emptyIterator() : Arrays.asList(t).iterator());
    }

    public static IteratorBuilder<File> ofFileList(File file) {
        return IteratorBuilder.ofArray(file.listFiles());
    }

    public static IteratorBuilder<File> ofFileList(File file, boolean intcludeSelf) {
        if (intcludeSelf) {
            return IteratorBuilder.ofArray(file).concat(IteratorBuilder.ofArray(file.listFiles()));
        }
        return IteratorBuilder.ofArray(file.listFiles());
    }

    public IteratorBuilder<T> filter(Predicate<T> t) {
        if (t == null) {
            return this;
        }
        return new IteratorBuilder<T>(new FilteredIterator<T>(this.it, t));
    }

    public IteratorBuilder<T> concat(IteratorBuilder<T> t) {
        return this.concat(t.it);
    }

    public IteratorBuilder<T> concat(Iterator<T> t) {
        if (t == null) {
            return this;
        }
        return new IteratorBuilder(IteratorUtils.concat(Arrays.asList(this.it, t)));
    }

    public <V> IteratorBuilder<V> map(Function<T, V> t) {
        return new IteratorBuilder<T>(new ConvertedIterator<T, V>(this.it, t, null));
    }

    public <V> IteratorBuilder<V> map(Function<T, V> t, String name) {
        return new IteratorBuilder<T>(new ConvertedIterator<T, V>(this.it, t, name));
    }

    public <V> IteratorBuilder<V> convert(Function<T, V> t) {
        return new IteratorBuilder<T>(new ConvertedIterator<T, V>(this.it, t, null));
    }

    public <V> IteratorBuilder<V> convert(Function<T, V> t, String name) {
        return new IteratorBuilder<T>(new ConvertedIterator<T, V>(this.it, t, name));
    }

    public <V> IteratorBuilder<V> mapMulti(Function<T, List<V>> t) {
        return new IteratorBuilder<T>(new ConvertedToListIterator<T, V>(this.it, t));
    }

    public <V> IteratorBuilder<V> flatMap(Function<T, Iterator<V>> fun) {
        return new IteratorBuilder<V>(IteratorUtils.flatMap(this.it, fun));
    }

    public <V> IteratorBuilder<V> convertMulti(Function<T, List<V>> t) {
        return new IteratorBuilder<T>(new ConvertedToListIterator<T, V>(this.it, t));
    }

    public <V> IteratorBuilder<T> sort(Comparator<T> t, boolean removeDuplicates) {
        return new IteratorBuilder<T>(IteratorUtils.sort(this.it, t, true));
    }

    public <V> IteratorBuilder<T> distinct() {
        return this.distinct(null);
    }

    public <V> IteratorBuilder<T> distinct(Function<T, V> t) {
        if (t == null) {
            return new IteratorBuilder<T>(IteratorUtils.distinct(this.it));
        }
        return new IteratorBuilder<T>(IteratorUtils.distinct(this.it, t));
    }

    public IteratorBuilder<T> safe(IteratorErrorHandlerType type) {
        return new IteratorBuilder<T>(new ErrorHandlerIterator<T>(type, this.it));
    }

    public IteratorBuilder<T> safeIgnore() {
        return this.safe(IteratorErrorHandlerType.IGNORE);
    }

    public IteratorBuilder<T> safePospone() {
        return this.safe(IteratorErrorHandlerType.POSPONE);
    }

    public IteratorBuilder<T> notNull() {
        return this.filter(IteratorUtils.NON_NULL);
    }

    public IteratorBuilder<String> notBlank() {
        return this.filter(IteratorUtils.NON_BLANK);
    }

    public Iterator<T> iterator() {
        return this.it;
    }

    public List<T> list() {
        return CoreCollectionUtils.toList(this.it);
    }

    public Iterator<T> build() {
        return this.it;
    }

    public List<T> toList() {
        return IteratorUtils.toList(this.it);
    }
}

